/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import opennlp.tools.util.Parameters;

public class TrainingParameters
implements Parameters {
    private final Map<String, Object> parameters = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);

    public TrainingParameters() {
    }

    public TrainingParameters(TrainingParameters trainingParameters) {
        this.parameters.putAll(trainingParameters.parameters);
    }

    public TrainingParameters(Map<String, Object> map) {
        this.parameters.putAll(map);
    }

    public TrainingParameters(InputStream in) throws IOException {
        Properties properties = new Properties();
        properties.load(in);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.parameters.put((String)entry.getKey(), entry.getValue());
        }
    }

    public String algorithm(String namespace) {
        return (String)this.parameters.get(Parameters.getKey((String)namespace, (String)"Algorithm"));
    }

    public String algorithm() {
        return (String)this.parameters.get("Algorithm");
    }

    public Map<String, Object> getObjectSettings(String namespace) {
        HashMap<String, Object> trainingParams = new HashMap<String, Object>();
        String prefix = namespace + ".";
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            String key = entry.getKey();
            if (namespace != null) {
                if (!key.startsWith(prefix)) continue;
                trainingParams.put(key.substring(prefix.length()), entry.getValue());
                continue;
            }
            if (key.contains(".")) continue;
            trainingParams.put(key, entry.getValue());
        }
        return Collections.unmodifiableMap(trainingParams);
    }

    public Map<String, Object> getObjectSettings() {
        return this.getObjectSettings(null);
    }

    public TrainingParameters getParameters(String namespace) {
        TrainingParameters params = new TrainingParameters();
        Map<String, Object> settings = this.getObjectSettings(namespace);
        for (Map.Entry<String, Object> entry : settings.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Integer) {
                params.put(key, (Integer)value);
                continue;
            }
            if (value instanceof Double) {
                params.put(key, (Double)value);
                continue;
            }
            if (value instanceof Boolean) {
                params.put(key, (Boolean)value);
                continue;
            }
            params.put(key, (String)value);
        }
        return params;
    }

    public void putIfAbsent(String namespace, String key, String value) {
        this.parameters.putIfAbsent(Parameters.getKey((String)namespace, (String)key), value);
    }

    public void putIfAbsent(String key, String value) {
        this.putIfAbsent(null, key, value);
    }

    public void putIfAbsent(String namespace, String key, int value) {
        this.parameters.putIfAbsent(Parameters.getKey((String)namespace, (String)key), value);
    }

    public void putIfAbsent(String key, int value) {
        this.putIfAbsent((String)null, key, value);
    }

    public void putIfAbsent(String namespace, String key, double value) {
        this.parameters.putIfAbsent(Parameters.getKey((String)namespace, (String)key), value);
    }

    public void putIfAbsent(String key, double value) {
        this.putIfAbsent(null, key, value);
    }

    public void putIfAbsent(String namespace, String key, boolean value) {
        this.parameters.putIfAbsent(Parameters.getKey((String)namespace, (String)key), value);
    }

    public void putIfAbsent(String key, boolean value) {
        this.putIfAbsent(null, key, value);
    }

    public void put(String namespace, String key, String value) {
        this.parameters.put(Parameters.getKey((String)namespace, (String)key), value);
    }

    public void put(String key, String value) {
        this.put(null, key, value);
    }

    public void put(String namespace, String key, int value) {
        this.parameters.put(Parameters.getKey((String)namespace, (String)key), value);
    }

    public void put(String key, int value) {
        this.put((String)null, key, value);
    }

    public void put(String namespace, String key, double value) {
        this.parameters.put(Parameters.getKey((String)namespace, (String)key), value);
    }

    public void put(String key, double value) {
        this.put(null, key, value);
    }

    public void put(String namespace, String key, boolean value) {
        this.parameters.put(Parameters.getKey((String)namespace, (String)key), value);
    }

    public void put(String key, boolean value) {
        this.put(null, key, value);
    }

    public void serialize(OutputStream out) throws IOException {
        Properties properties = new Properties();
        properties.putAll(this.parameters);
        properties.store(out, null);
    }

    public String getStringParameter(String key, String defaultValue) {
        return this.getStringParameter(null, key, defaultValue);
    }

    public String getStringParameter(String namespace, String key, String defaultValue) {
        Object value = this.parameters.get(Parameters.getKey((String)namespace, (String)key));
        if (value == null) {
            return defaultValue;
        }
        return (String)value;
    }

    public int getIntParameter(String key, int defaultValue) {
        return this.getIntParameter(null, key, defaultValue);
    }

    public int getIntParameter(String namespace, String key, int defaultValue) {
        Object value = this.parameters.get(Parameters.getKey((String)namespace, (String)key));
        if (value == null) {
            return defaultValue;
        }
        try {
            return (Integer)value;
        }
        catch (ClassCastException e) {
            return Integer.parseInt((String)value);
        }
    }

    public double getDoubleParameter(String key, double defaultValue) {
        return this.getDoubleParameter(null, key, defaultValue);
    }

    public double getDoubleParameter(String namespace, String key, double defaultValue) {
        Object value = this.parameters.get(Parameters.getKey((String)namespace, (String)key));
        if (value == null) {
            return defaultValue;
        }
        try {
            return (Double)value;
        }
        catch (ClassCastException e) {
            return Double.parseDouble((String)value);
        }
    }

    public boolean getBooleanParameter(String key, boolean defaultValue) {
        return this.getBooleanParameter(null, key, defaultValue);
    }

    public boolean getBooleanParameter(String namespace, String key, boolean defaultValue) {
        Object value = this.parameters.get(Parameters.getKey((String)namespace, (String)key));
        if (value == null) {
            return defaultValue;
        }
        try {
            return (Boolean)value;
        }
        catch (ClassCastException e) {
            return Boolean.parseBoolean((String)value);
        }
    }

    public static TrainingParameters defaultParams() {
        TrainingParameters mlParams = new TrainingParameters();
        mlParams.put("Algorithm", "MAXENT");
        mlParams.put("TrainerType", "Event");
        mlParams.put("Iterations", 100);
        mlParams.put("Cutoff", 5);
        return mlParams;
    }

    public static TrainingParameters setParams(String[] params) {
        TrainingParameters mlParams = new TrainingParameters();
        mlParams.put("Algorithm", "MAXENT");
        mlParams.put("TrainerType", "Event");
        mlParams.put("Iterations", null != TrainingParameters.getIntParameter("-" + "Iterations".toLowerCase(), params) ? TrainingParameters.getIntParameter("-" + "Iterations".toLowerCase(), params) : 100);
        mlParams.put("Cutoff", null != TrainingParameters.getIntParameter("-" + "Cutoff".toLowerCase(), params) ? TrainingParameters.getIntParameter("-" + "Cutoff".toLowerCase(), params) : 5);
        return mlParams;
    }

    private static Integer getIntParameter(String param, String[] args) {
        String value = TrainingParameters.getParameter(param, args);
        try {
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static String getParameter(String param, String[] args) {
        int i = TrainingParameters.getParameterIndex(param, args);
        if (-1 < i && ++i < args.length) {
            return args[i];
        }
        return null;
    }

    private static int getParameterIndex(String param, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-") || !args[i].equals(param)) continue;
            return i;
        }
        return -1;
    }
}

