/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.perceptron;

import java.io.File;
import java.io.IOException;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.AbstractModelReader;
import opennlp.tools.ml.model.Context;
import opennlp.tools.ml.model.DataReader;
import opennlp.tools.ml.perceptron.PerceptronModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerceptronModelReader
extends AbstractModelReader {
    private static final Logger logger = LoggerFactory.getLogger(PerceptronModelReader.class);

    public PerceptronModelReader(File file) throws IOException {
        super(file);
    }

    public PerceptronModelReader(DataReader dataReader) {
        super(dataReader);
    }

    public AbstractModel constructModel() throws IOException {
        String[] outcomeLabels = this.getOutcomes();
        int[][] outcomePatterns = this.getOutcomePatterns();
        String[] predLabels = this.getPredicates();
        Context[] params = this.getParameters(outcomePatterns);
        return new PerceptronModel(params, predLabels, outcomeLabels);
    }

    public void checkModelType() throws IOException {
        String modelType = this.readUTF();
        if (!modelType.equals("Perceptron")) {
            logger.error("Attempting to load a {}  model as a Perceptron model. You should expect problems.", (Object)modelType);
        }
    }
}

