/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import java.util.LinkedList;
import opennlp.tools.sentdetect.EmptyLinePreprocessorStream;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

public class SentenceSampleStream
extends FilterObjectStream<String, SentenceSample> {
    public SentenceSampleStream(ObjectStream<String> sentences) {
        super(new EmptyLinePreprocessorStream(sentences));
    }

    public static String replaceNewLineEscapeTags(String s) {
        return s.replace("<LF>", "\n").replace("<CR>", "\r");
    }

    public SentenceSample read() throws IOException {
        String sentence;
        StringBuilder sentencesString = new StringBuilder();
        LinkedList<Span> sentenceSpans = new LinkedList<Span>();
        while ((sentence = (String)this.samples.read()) != null && !sentence.isEmpty()) {
            int begin = sentencesString.length();
            sentence = sentence.trim();
            sentence = SentenceSampleStream.replaceNewLineEscapeTags(sentence);
            sentencesString.append(sentence);
            int end = sentencesString.length();
            sentenceSpans.add(new Span(begin, end));
            sentencesString.append(' ');
        }
        if (!sentenceSpans.isEmpty()) {
            return new SentenceSample((CharSequence)sentencesString.toString(), sentenceSpans.toArray(new Span[0]));
        }
        return null;
    }
}

