/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.cp;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.cp.BeanCreateMethodFinder;
import org.apache.juneau.cp.BeanCreator;
import org.apache.juneau.cp.BeanStoreEntry;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.FluentSetters;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.SimpleLock;
import org.apache.juneau.internal.SimpleReadWriteLock;
import org.apache.juneau.marshaller.Json5;
import org.apache.juneau.reflect.AnnotationInfo;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.ExecutableInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.reflect.ParamInfo;

public class BeanStore {
    public static final BeanStore INSTANCE = BeanStore.create().readOnly().build();
    private final Deque<BeanStoreEntry<?>> entries;
    private final Map<Class<?>, BeanStoreEntry<?>> unnamedEntries;
    final Optional<BeanStore> parent;
    final Optional<Object> outer;
    final boolean readOnly;
    final boolean threadSafe;
    final SimpleReadWriteLock lock;

    public static Builder create() {
        return new Builder();
    }

    public static BeanStore of(BeanStore parent) {
        return BeanStore.create().parent(parent).build();
    }

    public static BeanStore of(BeanStore parent, Object outer) {
        return BeanStore.create().parent(parent).outer(outer).build();
    }

    BeanStore() {
        this(BeanStore.create());
    }

    protected BeanStore(Builder builder) {
        this.parent = CollectionUtils.optional(builder.parent);
        this.outer = CollectionUtils.optional(builder.outer);
        this.readOnly = builder.readOnly;
        this.threadSafe = builder.threadSafe;
        this.lock = this.threadSafe ? new SimpleReadWriteLock() : SimpleReadWriteLock.NO_OP;
        this.entries = this.threadSafe ? new ConcurrentLinkedDeque() : CollectionUtils.linkedList(new BeanStoreEntry[0]);
        this.unnamedEntries = this.threadSafe ? new ConcurrentHashMap() : CollectionUtils.map();
    }

    public <T> BeanStore addBean(Class<T> beanType, T bean) {
        return this.addBean(beanType, bean, null);
    }

    public <T> BeanStore addBean(Class<T> beanType, T bean, String name) {
        return this.addSupplier(beanType, () -> bean, name);
    }

    public <T> BeanStore addSupplier(Class<T> beanType, Supplier<T> bean) {
        return this.addSupplier(beanType, bean, null);
    }

    public <T> BeanStore addSupplier(Class<T> beanType, Supplier<T> bean, String name) {
        this.assertCanWrite();
        BeanStoreEntry<T> e = this.createEntry(beanType, bean, name);
        try (SimpleLock x = this.lock.write();){
            this.entries.addFirst(e);
            if (StringUtils.isEmpty((String)name)) {
                this.unnamedEntries.put(beanType, e);
            }
        }
        return this;
    }

    public <T> T add(Class<T> beanType, T bean) {
        this.add(beanType, bean, null);
        return bean;
    }

    public <T> T add(Class<T> beanType, T bean, String name) {
        this.addBean(beanType, bean, name);
        return bean;
    }

    public BeanStore clear() {
        this.assertCanWrite();
        try (SimpleLock x = this.lock.write();){
            this.unnamedEntries.clear();
            this.entries.clear();
        }
        return this;
    }

    public <T> Optional<T> getBean(Class<T> beanType) {
        try (SimpleLock x = this.lock.read();){
            BeanStoreEntry<?> e = this.unnamedEntries.get(beanType);
            if (e != null) {
                Optional<?> optional = CollectionUtils.optional(e.get());
                return optional;
            }
            if (this.parent.isPresent()) {
                Optional<T> optional = this.parent.get().getBean(beanType);
                return optional;
            }
            Optional optional = CollectionUtils.empty();
            return optional;
        }
    }

    public <T> Optional<T> getBean(Class<T> beanType, String name) {
        try (SimpleLock x = this.lock.read();){
            BeanStoreEntry e = this.entries.stream().filter(x2 -> x2.matches(beanType, name)).findFirst().orElse(null);
            if (e != null) {
                Optional optional = CollectionUtils.optional(e.get());
                return optional;
            }
            if (this.parent.isPresent()) {
                Optional<T> optional = this.parent.get().getBean(beanType, name);
                return optional;
            }
            Optional optional = CollectionUtils.empty();
            return optional;
        }
    }

    public <T> Stream<BeanStoreEntry<T>> stream(Class<T> beanType) {
        Stream<BeanStoreEntry<T>> s = this.entries.stream().filter(x -> x.matches(beanType)).map(x -> x);
        if (this.parent.isPresent()) {
            s = Stream.concat(s, this.parent.get().stream(beanType));
        }
        return s;
    }

    public BeanStore removeBean(Class<?> beanType) {
        return this.removeBean(beanType, null);
    }

    public BeanStore removeBean(Class<?> beanType, String name) {
        this.assertCanWrite();
        try (SimpleLock x = this.lock.write();){
            if (name == null) {
                this.unnamedEntries.remove(beanType);
            }
            this.entries.removeIf(y -> y.matches(beanType, name));
        }
        return this;
    }

    public boolean hasBean(Class<?> beanType) {
        return this.unnamedEntries.containsKey(beanType) || this.parent.map(x -> x.hasBean(beanType)).orElse(false) != false;
    }

    public boolean hasBean(Class<?> beanType, String name) {
        return this.entries.stream().anyMatch(x -> x.matches(beanType, name)) || this.parent.map(x -> x.hasBean(beanType, name)).orElse(false) != false;
    }

    public <T> BeanCreator<T> createBean(Class<T> beanType) {
        return new BeanCreator<T>(beanType, this);
    }

    public <T> BeanCreateMethodFinder<T> createMethodFinder(Class<T> beanType, Object resource) {
        return new BeanCreateMethodFinder<T>(beanType, resource, this);
    }

    public <T> BeanCreateMethodFinder<T> createMethodFinder(Class<T> beanType, Class<?> resourceClass) {
        return new BeanCreateMethodFinder<T>(beanType, resourceClass, this);
    }

    public <T> BeanCreateMethodFinder<T> createMethodFinder(Class<T> beanType) {
        return new BeanCreateMethodFinder<T>(beanType, this.outer.orElseThrow(() -> new IllegalArgumentException("Method cannot be used without outer bean definition.")), this);
    }

    public String getMissingParams(ExecutableInfo executable) {
        List<ParamInfo> params = executable.getParams();
        ArrayList<String> l = CollectionUtils.list(new String[0]);
        for (int i = 0; i < params.size(); ++i) {
            ParamInfo pi = params.get(i);
            ClassInfo pt = pi.getParameterType();
            if (i == 0 && this.outer.isPresent() && pt.isInstance(this.outer.get()) || pt.is(Optional.class) || pt.is(BeanStore.class)) continue;
            String beanName = this.findBeanName(pi);
            Class ptc = pt.inner();
            if (beanName == null && !this.hasBean(ptc)) {
                l.add(pt.getSimpleName());
            }
            if (beanName == null || this.hasBean(ptc, beanName)) continue;
            l.add(pt.getSimpleName() + "@" + beanName);
        }
        return l.isEmpty() ? null : l.stream().sorted().collect(Collectors.joining(","));
    }

    public boolean hasAllParams(ExecutableInfo executable) {
        for (int i = 0; i < executable.getParamCount(); ++i) {
            ParamInfo pi = executable.getParam(i);
            ClassInfo pt = pi.getParameterType();
            if (i == 0 && this.outer.isPresent() && pt.isInstance(this.outer.get()) || pt.is(Optional.class) || pt.is(BeanStore.class)) continue;
            String beanName = this.findBeanName(pi);
            Class ptc = pt.inner();
            if ((beanName != null || this.hasBean(ptc)) && (beanName == null || this.hasBean(ptc, beanName))) continue;
            return false;
        }
        return true;
    }

    public Object[] getParams(ExecutableInfo executable) {
        Object[] o = new Object[executable.getParamCount()];
        for (int i = 0; i < executable.getParamCount(); ++i) {
            ParamInfo pi = executable.getParam(i);
            ClassInfo pt = pi.getParameterType();
            if (i == 0 && this.outer.isPresent() && pt.isInstance(this.outer.get())) {
                o[i] = this.outer.get();
                continue;
            }
            if (pt.is(BeanStore.class)) {
                o[i] = this;
                continue;
            }
            String beanName = this.findBeanName(pi);
            Class ptc = pt.unwrap(Optional.class).inner();
            Optional<Object> o2 = beanName == null ? this.getBean(ptc) : this.getBean(ptc, beanName);
            o[i] = pt.is(Optional.class) ? o2 : o2.orElse(null);
        }
        return o;
    }

    public String toString() {
        return Json5.of(this.properties());
    }

    protected <T> BeanStoreEntry<T> createEntry(Class<T> type, Supplier<T> bean, String name) {
        return BeanStoreEntry.create(type, bean, name);
    }

    private String findBeanName(ParamInfo pi) {
        Annotation n = pi.getAnnotation(Annotation.class, x -> x.annotationType().getSimpleName().equals("Named"));
        if (n != null) {
            return AnnotationInfo.of((ClassInfo)null, n).getValue(String.class, "value", StringUtils.NOT_EMPTY).orElse(null);
        }
        return null;
    }

    private void assertCanWrite() {
        if (this.readOnly) {
            throw new IllegalStateException("Method cannot be used because BeanStore is read-only.");
        }
    }

    private JsonMap properties() {
        Predicate<Boolean> nf = ObjectUtils::isTrue;
        return JsonMap.filteredMap().append("identity", ObjectUtils.identity(this)).append("entries", this.entries.stream().map(BeanStoreEntry::properties).collect(Collectors.toList())).append("outer", ObjectUtils.identity(this.outer.orElse(null))).append("parent", this.parent.map(BeanStore::properties).orElse(null)).appendIf(nf, "readOnly", this.readOnly).appendIf(nf, "threadSafe", this.threadSafe);
    }

    @FluentSetters
    public static class Builder {
        BeanStore parent;
        boolean readOnly;
        boolean threadSafe;
        Object outer;
        Class<? extends BeanStore> type;
        BeanStore impl;

        protected Builder() {
        }

        public BeanStore build() {
            if (this.impl != null) {
                return this.impl;
            }
            if (this.type == null || this.type == BeanStore.class) {
                return new BeanStore(this);
            }
            ClassInfo c = ClassInfo.of(this.type);
            MethodInfo m = c.getDeclaredMethod(x -> x.isPublic() && x.hasNoParams() && x.isStatic() && x.hasName("getInstance"));
            if (m != null) {
                return (BeanStore)m.invoke(null, new Object[0]);
            }
            ConstructorInfo ci = c.getPublicConstructor(x -> x.canAccept(this));
            if (ci != null) {
                return (BeanStore)ci.invoke(this);
            }
            ci = c.getDeclaredConstructor(x -> x.isProtected() && x.canAccept(this));
            if (ci != null) {
                return (BeanStore)ci.accessible().invoke(this);
            }
            throw new BasicRuntimeException("Could not find a way to instantiate class {0}", this.type);
        }

        @FluentSetter
        public Builder parent(BeanStore value) {
            this.parent = value;
            return this;
        }

        @FluentSetter
        public Builder readOnly() {
            this.readOnly = true;
            return this;
        }

        @FluentSetter
        public Builder threadSafe() {
            this.threadSafe = true;
            return this;
        }

        @FluentSetter
        public Builder outer(Object value) {
            this.outer = value;
            return this;
        }

        @FluentSetter
        public Builder impl(BeanStore value) {
            this.impl = value;
            return this;
        }

        @FluentSetter
        public Builder type(Class<? extends BeanStore> value) {
            this.type = value;
            return this;
        }
    }

    public static final class Void
    extends BeanStore {
    }
}

