/*
 * Decompiled with CFR 0.152.
 */
package tdb2;

import arq.cmdline.ModLangOutput;
import java.io.OutputStream;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.Txn;
import tdb2.cmdline.CmdTDB;

public class tdbdump
extends CmdTDB {
    static ModLangOutput modLangOutput = new ModLangOutput();

    public static void main(String ... argv) {
        CmdTDB.init();
        new tdbdump(argv).mainRun();
    }

    protected tdbdump(String[] argv) {
        super(argv);
        this.addModule(modLangOutput);
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " : Write a dataset to stdout (defaults to N-Quads)";
    }

    @Override
    protected void exec() {
        DatasetGraph dsg = this.getDatasetGraph();
        RDFFormat fmt = modLangOutput.getOutputStreamFormat();
        if (fmt == null) {
            fmt = modLangOutput.getOutputFormatted();
        }
        if (fmt == null) {
            fmt = RDFFormat.NQUADS;
        }
        if (!RDFLanguages.isQuads((Lang)fmt.getLang())) {
            throw new CmdException("Databases can be dumped only in quad formats (e.g. Trig, N-Quads), not " + String.valueOf(fmt.getLang()));
        }
        RDFFormat fmtFinal = fmt;
        Txn.executeRead((Transactional)dsg, () -> RDFDataMgr.write((OutputStream)System.out, (DatasetGraph)dsg, (RDFFormat)fmtFinal));
    }
}

