/*
 * Decompiled with CFR 0.152.
 */
package org.jtransforms.dct;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.util.FastMath;
import org.jtransforms.fft.FloatFFT_1D;
import org.jtransforms.utils.CommonUtils;
import pl.edu.icm.jlargearrays.ConcurrencyUtils;
import pl.edu.icm.jlargearrays.FloatLargeArray;
import pl.edu.icm.jlargearrays.LargeArray;
import pl.edu.icm.jlargearrays.LargeArrayUtils;
import pl.edu.icm.jlargearrays.LongLargeArray;

public class FloatDCT_1D {
    private int n;
    private long nl;
    private int[] ip;
    private LongLargeArray ipl;
    private float[] w;
    private FloatLargeArray wl;
    private int nw;
    private long nwl;
    private int nc;
    private long ncl;
    private boolean isPowerOfTwo = false;
    private FloatFFT_1D fft;
    private static final float PI = (float)Math.PI;
    private boolean useLargeArrays;

    public FloatDCT_1D(long n) {
        if (n < 1L) {
            throw new IllegalArgumentException("n must be greater than 0");
        }
        this.useLargeArrays = CommonUtils.isUseLargeArrays() || n > (long)LargeArray.getMaxSizeOf32bitArray();
        this.n = (int)n;
        this.nl = n;
        if (!this.useLargeArrays) {
            if (n > 0x10000000L) {
                throw new IllegalArgumentException("n must be smaller or equal to 268435456 when useLargeArrays argument is set to false");
            }
            if (CommonUtils.isPowerOf2(n)) {
                this.isPowerOfTwo = true;
                this.ip = new int[(int)FastMath.ceil(2 + (1 << (int)(FastMath.log((double)(n / 2L) + 0.5) / FastMath.log(2.0)) / 2))];
                this.w = new float[this.n * 5 / 4];
                this.nw = this.ip[0];
                if (n > (long)(this.nw << 2)) {
                    this.nw = this.n >> 2;
                    CommonUtils.makewt(this.nw, this.ip, this.w);
                }
                this.nc = this.ip[1];
                if (n > (long)this.nc) {
                    this.nc = this.n;
                    CommonUtils.makect(this.nc, this.w, this.nw, this.ip);
                }
            } else {
                this.w = this.makect(this.n);
                this.fft = new FloatFFT_1D(2L * n);
            }
        } else if (CommonUtils.isPowerOf2(n)) {
            this.isPowerOfTwo = true;
            this.ipl = new LongLargeArray((long)FastMath.ceil(2L + (1L << (int)((long)(FastMath.log((double)(n / 2L) + 0.5) / FastMath.log(2.0)) / 2L))));
            this.wl = new FloatLargeArray(this.nl * 5L / 4L);
            this.nwl = this.ipl.getLong(0L);
            if (n > this.nwl << 2) {
                this.nwl = this.nl >> 2;
                CommonUtils.makewt(this.nwl, this.ipl, this.wl);
            }
            this.ncl = this.ipl.getLong(1L);
            if (n > this.ncl) {
                this.ncl = this.nl;
                CommonUtils.makect(this.ncl, this.wl, this.nwl, this.ipl);
            }
        } else {
            this.wl = this.makect(n);
            this.fft = new FloatFFT_1D(2L * n);
        }
    }

    public void forward(float[] a, boolean scale) {
        this.forward(a, 0, scale);
    }

    public void forward(FloatLargeArray a, boolean scale) {
        this.forward(a, 0L, scale);
    }

    public void forward(final float[] a, final int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.forward(new FloatLargeArray(a), (long)offa, scale);
        } else if (this.isPowerOfTwo) {
            float xr = a[offa + this.n - 1];
            for (int j = this.n - 2; j >= 2; j -= 2) {
                a[offa + j + 1] = a[offa + j] - a[offa + j - 1];
                int n = offa + j;
                a[n] = a[n] + a[offa + j - 1];
            }
            a[offa + 1] = a[offa] - xr;
            int n = offa;
            a[n] = a[n] + xr;
            if (this.n > 4) {
                FloatDCT_1D.rftbsub(this.n, a, offa, this.nc, this.w, this.nw);
                CommonUtils.cftbsub(this.n, a, offa, this.ip, this.nw, this.w);
            } else if (this.n == 4) {
                CommonUtils.cftbsub(this.n, a, offa, this.ip, this.nw, this.w);
            }
            CommonUtils.dctsub(this.n, a, offa, this.nc, this.w, this.nw);
            if (scale) {
                CommonUtils.scale(this.n, (float)FastMath.sqrt(2.0 / (double)this.n), a, offa, false);
                a[offa] = a[offa] / (float)FastMath.sqrt(2.0);
            }
        } else {
            int i;
            int twon = 2 * this.n;
            final float[] t2 = new float[twon];
            System.arraycopy(a, offa, t2, 0, this.n);
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            for (i = this.n; i < twon; ++i) {
                t2[i] = t2[twon - i - 1];
            }
            this.fft.realForward(t2);
            if (nthreads > 1 && (long)this.n > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                nthreads = 2;
                int k = this.n / nthreads;
                Future[] futures = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == nthreads - 1 ? this.n : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = firstIdx; i < lastIdx; ++i) {
                                int twoi = 2 * i;
                                int idx = offa + i;
                                a[idx] = FloatDCT_1D.this.w[twoi] * t2[twoi] - FloatDCT_1D.this.w[twoi + 1] * t2[twoi + 1];
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDCT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDCT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (i = 0; i < this.n; ++i) {
                    int twoi = 2 * i;
                    int idx = offa + i;
                    a[idx] = this.w[twoi] * t2[twoi] - this.w[twoi + 1] * t2[twoi + 1];
                }
            }
            if (scale) {
                CommonUtils.scale(this.n, 1.0f / (float)FastMath.sqrt(twon), a, offa, false);
                a[offa] = a[offa] / (float)FastMath.sqrt(2.0);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void forward(final FloatLargeArray a, final long offa, boolean scale) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (a.isLarge() || a.isConstant() || offa >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.forward(a.getData(), (int)offa, scale);
            return;
        } else if (this.isPowerOfTwo) {
            float xr = a.getFloat(offa + this.nl - 1L);
            for (long j = this.nl - 2L; j >= 2L; j -= 2L) {
                a.setFloat(offa + j + 1L, a.getFloat(offa + j) - a.getFloat(offa + j - 1L));
                a.setFloat(offa + j, a.getFloat(offa + j) + a.getFloat(offa + j - 1L));
            }
            a.setFloat(offa + 1L, a.getFloat(offa) - xr);
            a.setFloat(offa, a.getFloat(offa) + xr);
            if (this.nl > 4L) {
                FloatDCT_1D.rftbsub(this.nl, a, offa, this.ncl, this.wl, this.nwl);
                CommonUtils.cftbsub(this.nl, a, offa, this.ipl, this.nwl, this.wl);
            } else if (this.nl == 4L) {
                CommonUtils.cftbsub(this.nl, a, offa, this.ipl, this.nwl, this.wl);
            }
            CommonUtils.dctsub(this.nl, a, offa, this.ncl, this.wl, this.nwl);
            if (!scale) return;
            CommonUtils.scale(this.nl, (float)FastMath.sqrt(2.0 / (double)this.nl), a, offa, false);
            a.setFloat(offa, a.getFloat(offa) / (float)FastMath.sqrt(2.0));
            return;
        } else {
            long i;
            long twon = 2L * this.nl;
            final FloatLargeArray t2 = new FloatLargeArray(twon);
            LargeArrayUtils.arraycopy(a, offa, t2, 0L, this.nl);
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            for (i = this.nl; i < twon; ++i) {
                t2.setFloat(i, t2.getFloat(twon - i - 1L));
            }
            this.fft.realForward(t2);
            if (nthreads > 1 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                nthreads = 2;
                long k = this.nl / (long)nthreads;
                Future[] futures = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? this.nl : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = firstIdx; i < lastIdx; ++i) {
                                long twoi = 2L * i;
                                long idx = offa + i;
                                a.setFloat(idx, FloatDCT_1D.this.wl.getFloat(twoi) * t2.getFloat(twoi) - FloatDCT_1D.this.wl.getFloat(twoi + 1L) * t2.getFloat(twoi + 1L));
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDCT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDCT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (i = 0L; i < this.nl; ++i) {
                    long twoi = 2L * i;
                    long idx = offa + i;
                    a.setFloat(idx, this.wl.getFloat(twoi) * t2.getFloat(twoi) - this.wl.getFloat(twoi + 1L) * t2.getFloat(twoi + 1L));
                }
            }
            if (!scale) return;
            CommonUtils.scale(this.nl, 1.0f / (float)FastMath.sqrt(twon), a, offa, false);
            a.setFloat(offa, a.getFloat(offa) / (float)FastMath.sqrt(2.0));
        }
    }

    public void inverse(float[] a, boolean scale) {
        this.inverse(a, 0, scale);
    }

    public void inverse(FloatLargeArray a, boolean scale) {
        this.inverse(a, 0L, scale);
    }

    public void inverse(final float[] a, final int offa, boolean scale) {
        if (this.n == 1) {
            return;
        }
        if (this.useLargeArrays) {
            this.inverse(new FloatLargeArray(a), (long)offa, scale);
        } else if (this.isPowerOfTwo) {
            if (scale) {
                CommonUtils.scale(this.n, (float)FastMath.sqrt(2.0 / (double)this.n), a, offa, false);
                a[offa] = a[offa] / (float)FastMath.sqrt(2.0);
            }
            CommonUtils.dctsub(this.n, a, offa, this.nc, this.w, this.nw);
            if (this.n > 4) {
                CommonUtils.cftfsub(this.n, a, offa, this.ip, this.nw, this.w);
                FloatDCT_1D.rftfsub(this.n, a, offa, this.nc, this.w, this.nw);
            } else if (this.n == 4) {
                CommonUtils.cftfsub(this.n, a, offa, this.ip, this.nw, this.w);
            }
            float xr = a[offa] - a[offa + 1];
            int n = offa;
            a[n] = a[n] + a[offa + 1];
            for (int j = 2; j < this.n; j += 2) {
                a[offa + j - 1] = a[offa + j] - a[offa + j + 1];
                int n2 = offa + j;
                a[n2] = a[n2] + a[offa + j + 1];
            }
            a[offa + this.n - 1] = xr;
        } else {
            int twon = 2 * this.n;
            if (scale) {
                CommonUtils.scale(this.n, (float)FastMath.sqrt(twon), a, offa, false);
                a[offa] = a[offa] * (float)FastMath.sqrt(2.0);
            }
            final float[] t2 = new float[twon];
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && (long)this.n > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                nthreads = 2;
                int k = this.n / nthreads;
                Future[] futures = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final int firstIdx = j * k;
                    final int lastIdx = j == nthreads - 1 ? this.n : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = firstIdx; i < lastIdx; ++i) {
                                int twoi = 2 * i;
                                float elem = a[offa + i];
                                t2[twoi] = FloatDCT_1D.this.w[twoi] * elem;
                                t2[twoi + 1] = -FloatDCT_1D.this.w[twoi + 1] * elem;
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDCT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDCT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (int i = 0; i < this.n; ++i) {
                    int twoi = 2 * i;
                    float elem = a[offa + i];
                    t2[twoi] = this.w[twoi] * elem;
                    t2[twoi + 1] = -this.w[twoi + 1] * elem;
                }
            }
            this.fft.realInverse(t2, true);
            System.arraycopy(t2, 0, a, offa, this.n);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void inverse(final FloatLargeArray a, final long offa, boolean scale) {
        if (this.nl == 1L) {
            return;
        }
        if (!this.useLargeArrays) {
            if (a.isLarge() || a.isConstant() || offa >= Integer.MAX_VALUE) throw new IllegalArgumentException("The data array is too big.");
            this.inverse(a.getData(), (int)offa, scale);
            return;
        } else if (this.isPowerOfTwo) {
            if (scale) {
                CommonUtils.scale(this.nl, (float)FastMath.sqrt(2.0 / (double)this.nl), a, offa, false);
                a.setFloat(offa, a.getFloat(offa) / (float)FastMath.sqrt(2.0));
            }
            CommonUtils.dctsub(this.nl, a, offa, this.ncl, this.wl, this.nwl);
            if (this.nl > 4L) {
                CommonUtils.cftfsub(this.nl, a, offa, this.ipl, this.nwl, this.wl);
                FloatDCT_1D.rftfsub(this.nl, a, offa, this.ncl, this.wl, this.nwl);
            } else if (this.nl == 4L) {
                CommonUtils.cftfsub(this.nl, a, offa, this.ipl, this.nwl, this.wl);
            }
            float xr = a.getFloat(offa) - a.getFloat(offa + 1L);
            a.setFloat(offa, a.getFloat(offa) + a.getFloat(offa + 1L));
            for (long j = 2L; j < this.nl; j += 2L) {
                a.setFloat(offa + j - 1L, a.getFloat(offa + j) - a.getFloat(offa + j + 1L));
                a.setFloat(offa + j, a.getFloat(offa + j) + a.getFloat(offa + j + 1L));
            }
            a.setFloat(offa + this.nl - 1L, xr);
            return;
        } else {
            long twon = 2L * this.nl;
            if (scale) {
                CommonUtils.scale(this.nl, (float)FastMath.sqrt(twon), a, offa, false);
                a.setFloat(offa, a.getFloat(offa) * (float)FastMath.sqrt(2.0));
            }
            final FloatLargeArray t2 = new FloatLargeArray(twon);
            int nthreads = ConcurrencyUtils.getNumberOfThreads();
            if (nthreads > 1 && this.nl > CommonUtils.getThreadsBeginN_1D_FFT_2Threads()) {
                nthreads = 2;
                long k = this.nl / (long)nthreads;
                Future[] futures = new Future[nthreads];
                for (int j = 0; j < nthreads; ++j) {
                    final long firstIdx = (long)j * k;
                    final long lastIdx = j == nthreads - 1 ? this.nl : firstIdx + k;
                    futures[j] = ConcurrencyUtils.submit(new Runnable(){

                        @Override
                        public void run() {
                            for (long i = firstIdx; i < lastIdx; ++i) {
                                long twoi = 2L * i;
                                float elem = a.getFloat(offa + i);
                                t2.setFloat(twoi, FloatDCT_1D.this.wl.getFloat(twoi) * elem);
                                t2.setFloat(twoi + 1L, -FloatDCT_1D.this.wl.getFloat(twoi + 1L) * elem);
                            }
                        }
                    });
                }
                try {
                    ConcurrencyUtils.waitForCompletion(futures);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(FloatDCT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (ExecutionException ex) {
                    Logger.getLogger(FloatDCT_1D.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                for (long i = 0L; i < this.nl; ++i) {
                    long twoi = 2L * i;
                    float elem = a.getFloat(offa + i);
                    t2.setFloat(twoi, this.wl.getFloat(twoi) * elem);
                    t2.setFloat(twoi + 1L, -this.wl.getFloat(twoi + 1L) * elem);
                }
            }
            this.fft.realInverse(t2, true);
            LargeArrayUtils.arraycopy(t2, 0L, a, offa, this.nl);
        }
    }

    private float[] makect(int n) {
        int twon = 2 * n;
        float delta = (float)Math.PI / (float)twon;
        float[] c = new float[twon];
        c[0] = 1.0f;
        for (int j = 1; j < n; ++j) {
            int idx = 2 * j;
            float deltaj = delta * (float)j;
            c[idx] = (float)FastMath.cos(deltaj);
            c[idx + 1] = -((float)FastMath.sin(deltaj));
        }
        return c;
    }

    private FloatLargeArray makect(long n) {
        long twon = 2L * n;
        float delta = (float)Math.PI / (float)twon;
        FloatLargeArray c = new FloatLargeArray(twon);
        c.setFloat(0L, 1.0f);
        for (long j = 1L; j < n; ++j) {
            long idx = 2L * j;
            float deltaj = delta * (float)j;
            c.setFloat(idx, (float)FastMath.cos(deltaj));
            c.setFloat(idx + 1L, -((float)FastMath.sin(deltaj)));
        }
        return c;
    }

    private static void rftfsub(int n, float[] a, int offa, int nc, float[] c, int startc) {
        int m4 = n >> 1;
        int ks = 2 * nc / m4;
        int kk = 0;
        for (int j = 2; j < m4; j += 2) {
            int k = n - j;
            float wkr = 0.5f - c[startc + nc - (kk += ks)];
            float wki = c[startc + kk];
            int idx1 = offa + j;
            int idx2 = offa + k;
            float xr = a[idx1] - a[idx2];
            float xi = a[idx1 + 1] + a[idx2 + 1];
            float yr = wkr * xr - wki * xi;
            float yi = wkr * xi + wki * xr;
            int n2 = idx1;
            a[n2] = a[n2] - yr;
            int n3 = idx1 + 1;
            a[n3] = a[n3] - yi;
            int n4 = idx2;
            a[n4] = a[n4] + yr;
            int n5 = idx2 + 1;
            a[n5] = a[n5] - yi;
        }
    }

    private static void rftfsub(long n, FloatLargeArray a, long offa, long nc, FloatLargeArray c, long startc) {
        long m4 = n >> 1;
        long ks = 2L * nc / m4;
        long kk = 0L;
        for (long j = 2L; j < m4; j += 2L) {
            long k = n - j;
            float wkr = 0.5f - c.getFloat(startc + nc - (kk += ks));
            float wki = c.getFloat(startc + kk);
            long idx1 = offa + j;
            long idx2 = offa + k;
            float xr = a.getFloat(idx1) - a.getFloat(idx2);
            float xi = a.getFloat(idx1 + 1L) + a.getFloat(idx2 + 1L);
            float yr = wkr * xr - wki * xi;
            float yi = wkr * xi + wki * xr;
            a.setFloat(idx1, a.getFloat(idx1) - yr);
            a.setFloat(idx1 + 1L, a.getFloat(idx1 + 1L) - yi);
            a.setFloat(idx2, a.getFloat(idx2) + yr);
            a.setFloat(idx2 + 1L, a.getFloat(idx2 + 1L) - yi);
        }
    }

    private static void rftbsub(int n, float[] a, int offa, int nc, float[] c, int startc) {
        int m4 = n >> 1;
        int ks = 2 * nc / m4;
        int kk = 0;
        for (int j = 2; j < m4; j += 2) {
            int k = n - j;
            float wkr = 0.5f - c[startc + nc - (kk += ks)];
            float wki = c[startc + kk];
            int idx1 = offa + j;
            int idx2 = offa + k;
            float xr = a[idx1] - a[idx2];
            float xi = a[idx1 + 1] + a[idx2 + 1];
            float yr = wkr * xr + wki * xi;
            float yi = wkr * xi - wki * xr;
            int n2 = idx1;
            a[n2] = a[n2] - yr;
            int n3 = idx1 + 1;
            a[n3] = a[n3] - yi;
            int n4 = idx2;
            a[n4] = a[n4] + yr;
            int n5 = idx2 + 1;
            a[n5] = a[n5] - yi;
        }
    }

    private static void rftbsub(long n, FloatLargeArray a, long offa, long nc, FloatLargeArray c, long startc) {
        long m4 = n >> 1;
        long ks = 2L * nc / m4;
        long kk = 0L;
        for (long j = 2L; j < m4; j += 2L) {
            long k = n - j;
            float wkr = 0.5f - c.getFloat(startc + nc - (kk += ks));
            float wki = c.getFloat(startc + kk);
            long idx1 = offa + j;
            long idx2 = offa + k;
            float xr = a.getFloat(idx1) - a.getFloat(idx2);
            float xi = a.getFloat(idx1 + 1L) + a.getFloat(idx2 + 1L);
            float yr = wkr * xr + wki * xi;
            float yi = wkr * xi - wki * xr;
            a.setFloat(idx1, a.getFloat(idx1) - yr);
            a.setFloat(idx1 + 1L, a.getFloat(idx1 + 1L) - yi);
            a.setFloat(idx2, a.getFloat(idx2) + yr);
            a.setFloat(idx2 + 1L, a.getFloat(idx2 + 1L) - yi);
        }
    }
}

