/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.seata.core.serializer;

import org.apache.seata.common.loader.EnhancedServiceNotFoundException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import java.util.List;

public class SerializerServiceLoaderTest {

    @Test
    public void testGetSupportedSerializers() {
        List<SerializerType> supportedSerializers = SerializerServiceLoader.getSupportedSerializers();
        Assertions.assertNotNull(supportedSerializers);
        Assertions.assertFalse(supportedSerializers.isEmpty());
    }

    @Test
    public void testGetDefaultSerializerType() {
        SerializerType defaultType = SerializerServiceLoader.getDefaultSerializerType();
        Assertions.assertNotNull(defaultType);
    }

    @Test
    public void testGetSupportedSerializersDistinct() {
        List<SerializerType> supportedSerializers = SerializerServiceLoader.getSupportedSerializers();
        long distinctCount = supportedSerializers.stream().distinct().count();
        Assertions.assertEquals(supportedSerializers.size(), distinctCount);
    }

    @Test
    public void testLoadProtobufSerializerWithoutDependency() {
        Assertions.assertThrows(EnhancedServiceNotFoundException.class, () -> {
            SerializerServiceLoader.load(SerializerType.PROTOBUF);
        });
    }

    @Test
    public void testLoadProtobufSerializerWithTypeAndVersionWithoutDependency() {
        Assertions.assertThrows(EnhancedServiceNotFoundException.class, () -> {
            SerializerServiceLoader.load(SerializerType.PROTOBUF, (byte) 0);
        });
    }
}
