/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.gravitino.Entity;
import org.apache.gravitino.HasIdentifier;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NonEmptyEntityException;
import org.apache.gravitino.meta.CatalogEntity;
import org.apache.gravitino.meta.SchemaEntity;
import org.apache.gravitino.storage.relational.mapper.CatalogMetaMapper;
import org.apache.gravitino.storage.relational.mapper.FilesetMetaMapper;
import org.apache.gravitino.storage.relational.mapper.FilesetVersionMapper;
import org.apache.gravitino.storage.relational.mapper.ModelMetaMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionAliasRelMapper;
import org.apache.gravitino.storage.relational.mapper.ModelVersionMetaMapper;
import org.apache.gravitino.storage.relational.mapper.OwnerMetaMapper;
import org.apache.gravitino.storage.relational.mapper.SchemaMetaMapper;
import org.apache.gravitino.storage.relational.mapper.SecurableObjectMapper;
import org.apache.gravitino.storage.relational.mapper.TableColumnMapper;
import org.apache.gravitino.storage.relational.mapper.TableMetaMapper;
import org.apache.gravitino.storage.relational.mapper.TagMetadataObjectRelMapper;
import org.apache.gravitino.storage.relational.mapper.TopicMetaMapper;
import org.apache.gravitino.storage.relational.po.CatalogPO;
import org.apache.gravitino.storage.relational.service.CommonMetaService;
import org.apache.gravitino.storage.relational.service.SchemaMetaService;
import org.apache.gravitino.storage.relational.utils.ExceptionUtils;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.NamespaceUtil;

public class CatalogMetaService {
    private static final CatalogMetaService INSTANCE = new CatalogMetaService();

    public static CatalogMetaService getInstance() {
        return INSTANCE;
    }

    private CatalogMetaService() {
    }

    public CatalogPO getCatalogPOByMetalakeIdAndName(Long metalakeId, String catalogName) {
        CatalogPO catalogPO = SessionUtils.getWithoutCommit(CatalogMetaMapper.class, mapper -> mapper.selectCatalogMetaByMetalakeIdAndName(metalakeId, catalogName));
        if (catalogPO == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.CATALOG.name().toLowerCase(), catalogName});
        }
        return catalogPO;
    }

    @Nullable
    public CatalogPO getCatalogPOById(Long catalogId) {
        CatalogPO catalogPO = SessionUtils.getWithoutCommit(CatalogMetaMapper.class, mapper -> mapper.selectCatalogMetaById(catalogId));
        return catalogPO;
    }

    public Long getCatalogIdByMetalakeIdAndName(Long metalakeId, String catalogName) {
        Long catalogId = SessionUtils.getWithoutCommit(CatalogMetaMapper.class, mapper -> mapper.selectCatalogIdByMetalakeIdAndName(metalakeId, catalogName));
        if (catalogId == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.CATALOG.name().toLowerCase(), catalogName});
        }
        return catalogId;
    }

    public CatalogEntity getCatalogByIdentifier(NameIdentifier identifier) {
        NameIdentifierUtil.checkCatalog(identifier);
        String catalogName = identifier.name();
        Long metalakeId = CommonMetaService.getInstance().getParentEntityIdByNamespace(identifier.namespace());
        CatalogPO catalogPO = this.getCatalogPOByMetalakeIdAndName(metalakeId, catalogName);
        return POConverters.fromCatalogPO(catalogPO, identifier.namespace());
    }

    public List<CatalogEntity> listCatalogsByNamespace(Namespace namespace) {
        NamespaceUtil.checkCatalog(namespace);
        Long metalakeId = CommonMetaService.getInstance().getParentEntityIdByNamespace(namespace);
        List catalogPOS = SessionUtils.getWithoutCommit(CatalogMetaMapper.class, mapper -> mapper.listCatalogPOsByMetalakeId(metalakeId));
        return POConverters.fromCatalogPOs(catalogPOS, namespace);
    }

    public void insertCatalog(CatalogEntity catalogEntity, boolean overwrite) throws IOException {
        try {
            NameIdentifierUtil.checkCatalog(catalogEntity.nameIdentifier());
            Long metalakeId = CommonMetaService.getInstance().getParentEntityIdByNamespace(catalogEntity.namespace());
            SessionUtils.doWithCommit(CatalogMetaMapper.class, mapper -> {
                CatalogPO po = POConverters.initializeCatalogPOWithVersion(catalogEntity, metalakeId);
                if (overwrite) {
                    mapper.insertCatalogMetaOnDuplicateKeyUpdate(po);
                } else {
                    mapper.insertCatalogMeta(po);
                }
            });
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.CATALOG, catalogEntity.nameIdentifier().toString());
            throw re;
        }
    }

    public <E extends Entity & HasIdentifier> CatalogEntity updateCatalog(NameIdentifier identifier, Function<E, E> updater) throws IOException {
        Integer updateResult;
        NameIdentifierUtil.checkCatalog(identifier);
        String catalogName = identifier.name();
        Long metalakeId = CommonMetaService.getInstance().getParentEntityIdByNamespace(identifier.namespace());
        CatalogPO oldCatalogPO = this.getCatalogPOByMetalakeIdAndName(metalakeId, catalogName);
        CatalogEntity oldCatalogEntity = POConverters.fromCatalogPO(oldCatalogPO, identifier.namespace());
        CatalogEntity newEntity = (CatalogEntity)updater.apply(oldCatalogEntity);
        Preconditions.checkArgument((boolean)Objects.equals(oldCatalogEntity.id(), newEntity.id()), (String)"The updated catalog entity id: %s should be same with the catalog entity id before: %s", (Object)newEntity.id(), (Object)oldCatalogEntity.id());
        try {
            updateResult = SessionUtils.doWithCommitAndFetchResult(CatalogMetaMapper.class, mapper -> mapper.updateCatalogMeta(POConverters.updateCatalogPOWithVersion(oldCatalogPO, newEntity, metalakeId), oldCatalogPO));
        }
        catch (RuntimeException re) {
            ExceptionUtils.checkSQLException(re, Entity.EntityType.CATALOG, newEntity.nameIdentifier().toString());
            throw re;
        }
        if (updateResult > 0) {
            return newEntity;
        }
        throw new IOException("Failed to update the entity: " + identifier);
    }

    public boolean deleteCatalog(NameIdentifier identifier, boolean cascade) {
        NameIdentifierUtil.checkCatalog(identifier);
        String catalogName = identifier.name();
        Long metalakeId = CommonMetaService.getInstance().getParentEntityIdByNamespace(identifier.namespace());
        Long catalogId = this.getCatalogIdByMetalakeIdAndName(metalakeId, catalogName);
        if (cascade) {
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(CatalogMetaMapper.class, mapper -> mapper.softDeleteCatalogMetasByCatalogId(catalogId)), () -> SessionUtils.doWithoutCommit(SchemaMetaMapper.class, mapper -> mapper.softDeleteSchemaMetasByCatalogId(catalogId)), () -> SessionUtils.doWithoutCommit(TableMetaMapper.class, mapper -> mapper.softDeleteTableMetasByCatalogId(catalogId)), () -> SessionUtils.doWithoutCommit(TableColumnMapper.class, mapper -> mapper.softDeleteColumnsByCatalogId(catalogId)), () -> SessionUtils.doWithoutCommit(FilesetMetaMapper.class, mapper -> mapper.softDeleteFilesetMetasByCatalogId(catalogId)), () -> SessionUtils.doWithoutCommit(FilesetVersionMapper.class, mapper -> mapper.softDeleteFilesetVersionsByCatalogId(catalogId)), () -> SessionUtils.doWithoutCommit(TopicMetaMapper.class, mapper -> mapper.softDeleteTopicMetasByCatalogId(catalogId)), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByCatalogId(catalogId)), () -> SessionUtils.doWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.softDeleteObjectRelsByCatalogId(catalogId)), () -> SessionUtils.doWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.softDeleteTagMetadataObjectRelsByCatalogId(catalogId)), () -> SessionUtils.doWithoutCommit(ModelVersionAliasRelMapper.class, mapper -> mapper.softDeleteModelVersionAliasRelsByCatalogId(catalogId)), () -> SessionUtils.doWithoutCommit(ModelVersionMetaMapper.class, mapper -> mapper.softDeleteModelVersionMetasByCatalogId(catalogId)), () -> SessionUtils.doWithoutCommit(ModelMetaMapper.class, mapper -> mapper.softDeleteModelMetasByCatalogId(catalogId)));
        } else {
            List<SchemaEntity> schemaEntities = SchemaMetaService.getInstance().listSchemasByNamespace(NamespaceUtil.ofSchema(identifier.namespace().level(0), catalogName));
            if (!schemaEntities.isEmpty()) {
                throw new NonEmptyEntityException("Entity %s has sub-entities, you should remove sub-entities first", new Object[]{identifier});
            }
            SessionUtils.doMultipleWithCommit(() -> SessionUtils.doWithoutCommit(CatalogMetaMapper.class, mapper -> mapper.softDeleteCatalogMetasByCatalogId(catalogId)), () -> SessionUtils.doWithoutCommit(OwnerMetaMapper.class, mapper -> mapper.softDeleteOwnerRelByMetadataObjectIdAndType(catalogId, MetadataObject.Type.CATALOG.name())), () -> SessionUtils.doWithoutCommit(SecurableObjectMapper.class, mapper -> mapper.softDeleteObjectRelsByMetadataObject(catalogId, MetadataObject.Type.CATALOG.name())), () -> SessionUtils.doWithoutCommit(TagMetadataObjectRelMapper.class, mapper -> mapper.softDeleteTagMetadataObjectRelsByMetadataObject(catalogId, MetadataObject.Type.CATALOG.name())));
        }
        return true;
    }

    public int deleteCatalogMetasByLegacyTimeline(Long legacyTimeline, int limit) {
        return SessionUtils.doWithCommitAndFetchResult(CatalogMetaMapper.class, mapper -> mapper.deleteCatalogMetasByLegacyTimeline(legacyTimeline, limit));
    }
}

