/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.catalog;

import java.time.Instant;
import java.util.Map;
import org.apache.gravitino.Entity;
import org.apache.gravitino.EntityAlreadyExistsException;
import org.apache.gravitino.EntityStore;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.Namespace;
import org.apache.gravitino.Schema;
import org.apache.gravitino.SchemaChange;
import org.apache.gravitino.StringIdentifier;
import org.apache.gravitino.catalog.CatalogManager;
import org.apache.gravitino.catalog.EntityCombinedSchema;
import org.apache.gravitino.catalog.OperationDispatcher;
import org.apache.gravitino.catalog.PropertiesMetadataHelpers;
import org.apache.gravitino.catalog.SchemaDispatcher;
import org.apache.gravitino.connector.HasPropertyMetadata;
import org.apache.gravitino.connector.capability.Capability;
import org.apache.gravitino.exceptions.NoSuchCatalogException;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.exceptions.NoSuchSchemaException;
import org.apache.gravitino.exceptions.NonEmptySchemaException;
import org.apache.gravitino.exceptions.SchemaAlreadyExistsException;
import org.apache.gravitino.lock.LockType;
import org.apache.gravitino.lock.TreeLockUtils;
import org.apache.gravitino.meta.AuditInfo;
import org.apache.gravitino.meta.SchemaEntity;
import org.apache.gravitino.storage.IdGenerator;
import org.apache.gravitino.utils.NameIdentifierUtil;
import org.apache.gravitino.utils.PrincipalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaOperationDispatcher
extends OperationDispatcher
implements SchemaDispatcher {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaOperationDispatcher.class);

    public SchemaOperationDispatcher(CatalogManager catalogManager, EntityStore store, IdGenerator idGenerator) {
        super(catalogManager, store, idGenerator);
    }

    @Override
    public NameIdentifier[] listSchemas(Namespace namespace) throws NoSuchCatalogException {
        return this.doWithCatalog(NameIdentifierUtil.getCatalogIdentifier(NameIdentifier.of((String[])namespace.levels())), c -> c.doWithSchemaOps(s -> s.listSchemas(namespace)), NoSuchCatalogException.class);
    }

    @Override
    public Schema createSchema(NameIdentifier ident, String comment, Map<String, String> properties) throws NoSuchCatalogException, SchemaAlreadyExistsException {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        this.doWithCatalog(catalogIdent, c -> c.doWithPropertiesMeta(p -> {
            PropertiesMetadataHelpers.validatePropertyForCreate(p.schemaPropertiesMetadata(), properties);
            return null;
        }), IllegalArgumentException.class);
        long uid = this.idGenerator.nextId();
        StringIdentifier stringId = StringIdentifier.fromId(uid);
        Map<String, String> updatedProperties = StringIdentifier.newPropertiesWithId(stringId, properties);
        Schema schema = this.doWithCatalog(catalogIdent, c -> c.doWithSchemaOps(s -> s.createSchema(ident, comment, updatedProperties)), NoSuchCatalogException.class, SchemaAlreadyExistsException.class);
        boolean isManagedSchema = this.isManagedEntity(catalogIdent, Capability.Scope.SCHEMA);
        if (isManagedSchema) {
            return EntityCombinedSchema.of(schema).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::schemaPropertiesMetadata, schema.properties()));
        }
        SchemaEntity schemaEntity = SchemaEntity.builder().withId(uid).withName(ident.name()).withNamespace(ident.namespace()).withAuditInfo(AuditInfo.builder().withCreator(PrincipalUtils.getCurrentPrincipal().getName()).withCreateTime(Instant.now()).build()).build();
        try {
            this.store.put(schemaEntity, true);
        }
        catch (Exception e) {
            LOG.error("Failed to {} entity for {} in Gravitino, with this situation the returned object will not contain the metadata from Gravitino.", new Object[]{"put", ident, e});
            return EntityCombinedSchema.of(schema).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::schemaPropertiesMetadata, schema.properties()));
        }
        return EntityCombinedSchema.of(schema, schemaEntity).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::schemaPropertiesMetadata, schema.properties()));
    }

    @Override
    public Schema loadSchema(NameIdentifier ident) throws NoSuchSchemaException {
        EntityCombinedSchema schema = TreeLockUtils.doWithTreeLock(ident, LockType.READ, () -> this.internalLoadSchema(ident));
        if (!schema.imported()) {
            TreeLockUtils.doWithTreeLock(NameIdentifier.of((String[])ident.namespace().levels()), LockType.WRITE, () -> {
                this.importSchema(ident);
                return null;
            });
        }
        return schema;
    }

    @Override
    public Schema alterSchema(NameIdentifier ident, SchemaChange ... changes) throws NoSuchSchemaException {
        this.validateAlterProperties(ident, HasPropertyMetadata::schemaPropertiesMetadata, changes);
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        Schema alteredSchema = this.doWithCatalog(catalogIdent, c -> c.doWithSchemaOps(s -> s.alterSchema(ident, changes)), NoSuchSchemaException.class);
        boolean isManagedSchema = this.isManagedEntity(catalogIdent, Capability.Scope.SCHEMA);
        if (isManagedSchema) {
            return EntityCombinedSchema.of(alteredSchema).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::schemaPropertiesMetadata, alteredSchema.properties()));
        }
        StringIdentifier stringId = this.getStringIdFromProperties(alteredSchema.properties());
        if (stringId == null) {
            return EntityCombinedSchema.of(alteredSchema).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::schemaPropertiesMetadata, alteredSchema.properties()));
        }
        SchemaEntity updatedSchemaEntity = this.operateOnEntity(ident, id -> this.store.update((NameIdentifier)id, SchemaEntity.class, Entity.EntityType.SCHEMA, schemaEntity -> SchemaEntity.builder().withId(schemaEntity.id()).withName(schemaEntity.name()).withNamespace(ident.namespace()).withAuditInfo(AuditInfo.builder().withCreator(schemaEntity.auditInfo().creator()).withCreateTime(schemaEntity.auditInfo().createTime()).withLastModifier(PrincipalUtils.getCurrentPrincipal().getName()).withLastModifiedTime(Instant.now()).build()).build()), "UPDATE", stringId.id());
        return EntityCombinedSchema.of(alteredSchema, updatedSchemaEntity).withHiddenProperties(this.getHiddenPropertyNames(catalogIdent, HasPropertyMetadata::schemaPropertiesMetadata, alteredSchema.properties()));
    }

    @Override
    public boolean dropSchema(NameIdentifier ident, boolean cascade) throws NonEmptySchemaException {
        NameIdentifier catalogIdent = NameIdentifierUtil.getCatalogIdentifier(ident);
        return TreeLockUtils.doWithTreeLock(catalogIdent, LockType.WRITE, () -> {
            boolean droppedFromCatalog = this.doWithCatalog(catalogIdent, c -> c.doWithSchemaOps(s -> s.dropSchema(ident, cascade)), NonEmptySchemaException.class, RuntimeException.class);
            boolean isManagedSchema = this.isManagedEntity(catalogIdent, Capability.Scope.SCHEMA);
            if (isManagedSchema) {
                return droppedFromCatalog;
            }
            try {
                this.store.delete(ident, Entity.EntityType.SCHEMA, cascade);
            }
            catch (NoSuchEntityException e) {
                LOG.warn("The schema to be dropped does not exist in the store: {}", (Object)ident, (Object)e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return droppedFromCatalog;
        });
    }

    private void importSchema(NameIdentifier identifier) {
        long uid;
        EntityCombinedSchema schema = this.internalLoadSchema(identifier);
        if (schema.imported()) {
            return;
        }
        StringIdentifier stringId = null;
        try {
            stringId = schema.stringIdentifier();
        }
        catch (IllegalArgumentException ie) {
            LOG.warn("Failed to get string identifier from schema properties: {}, this maybe caused by the same-name string identifier is set by the user with unsupported format.", (Object)ie.getMessage());
        }
        if (stringId != null) {
            LOG.warn("The Schema uid {} existed but still needs to be imported, this could be happened when Schema is renamed by external systems not controlled by Gravitino. In this case, we need to overwrite the stored entity to keep consistency.", (Object)stringId);
            uid = stringId.id();
        } else {
            uid = this.idGenerator.nextId();
        }
        SchemaEntity schemaEntity = SchemaEntity.builder().withId(uid).withName(identifier.name()).withNamespace(identifier.namespace()).withAuditInfo(AuditInfo.builder().withCreator(schema.auditInfo().creator()).withCreateTime(schema.auditInfo().createTime()).withLastModifier(schema.auditInfo().lastModifier()).withLastModifiedTime(schema.auditInfo().lastModifiedTime()).build()).build();
        try {
            this.store.put(schemaEntity, true);
        }
        catch (EntityAlreadyExistsException e) {
            LOG.error("Failed to import schema {} with id {} to the store.", new Object[]{identifier, uid, e});
            throw new UnsupportedOperationException("Schema managed by multiple catalogs. This may cause unexpected issues such as privilege conflicts. To resolve: Remove all catalogs managing this schema, then recreate one catalog to ensure single-catalog management.");
        }
        catch (Exception e) {
            LOG.error("Failed to {} entity for {} in Gravitino, with this situation the returned object will not contain the metadata from Gravitino.", new Object[]{"put", identifier, e});
            throw new RuntimeException("Fail to import schema entity to the store.", e);
        }
    }

    private EntityCombinedSchema internalLoadSchema(NameIdentifier ident) {
        NameIdentifier catalogIdentifier = NameIdentifierUtil.getCatalogIdentifier(ident);
        Schema schema = this.doWithCatalog(catalogIdentifier, c -> c.doWithSchemaOps(s -> s.loadSchema(ident)), NoSuchSchemaException.class);
        boolean isManagedSchema = this.isManagedEntity(catalogIdentifier, Capability.Scope.SCHEMA);
        if (isManagedSchema) {
            return EntityCombinedSchema.of(schema).withHiddenProperties(this.getHiddenPropertyNames(catalogIdentifier, HasPropertyMetadata::schemaPropertiesMetadata, schema.properties())).withImported(true);
        }
        StringIdentifier stringId = this.getStringIdFromProperties(schema.properties());
        if (stringId == null) {
            return EntityCombinedSchema.of(schema).withHiddenProperties(this.getHiddenPropertyNames(catalogIdentifier, HasPropertyMetadata::schemaPropertiesMetadata, schema.properties())).withImported(this.isEntityExist(ident, Entity.EntityType.SCHEMA));
        }
        SchemaEntity schemaEntity = this.operateOnEntity(ident, identifier -> this.store.get((NameIdentifier)identifier, Entity.EntityType.SCHEMA, SchemaEntity.class), "GET", stringId.id());
        return EntityCombinedSchema.of(schema, schemaEntity).withHiddenProperties(this.getHiddenPropertyNames(catalogIdentifier, HasPropertyMetadata::schemaPropertiesMetadata, schema.properties())).withImported(schemaEntity != null);
    }
}

