/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.impl.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.impl.io.AbstractMessageParser;
import org.apache.hc.core5.http.impl.io.SessionInputBufferImpl;
import org.apache.hc.core5.http.io.SessionInputBuffer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestMessageParser {
    TestMessageParser() {
    }

    @Test
    void testBasicHeaderParsing() throws Exception {
        String s = "header1: stuff\r\nheader2:  stuff \r\nheader3: stuff\r\n     and more stuff\r\n\t and even more stuff\r\n     \r\n\r\n";
        ByteArrayInputStream inputStream = new ByteArrayInputStream("header1: stuff\r\nheader2:  stuff \r\nheader3: stuff\r\n     and more stuff\r\n\t and even more stuff\r\n     \r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, StandardCharsets.US_ASCII.newDecoder());
        Header[] headers = AbstractMessageParser.parseHeaders((SessionInputBuffer)inBuffer, (InputStream)inputStream, (int)-1, (int)-1, null);
        Assertions.assertNotNull((Object)headers);
        Assertions.assertEquals((int)3, (int)headers.length);
        Assertions.assertEquals((Object)"header1", (Object)headers[0].getName());
        Assertions.assertEquals((Object)"stuff", (Object)headers[0].getValue());
        Assertions.assertEquals((Object)"header2", (Object)headers[1].getName());
        Assertions.assertEquals((Object)"stuff", (Object)headers[1].getValue());
        Assertions.assertEquals((Object)"header3", (Object)headers[2].getName());
        Assertions.assertEquals((Object)"stuff and more stuff and even more stuff", (Object)headers[2].getValue());
    }

    @Test
    void testParsingHeader() throws Exception {
        String s = "header1: stuff; param1 = value1; param2 = \"value 2\" \r\n\r\n";
        ByteArrayInputStream inputStream = new ByteArrayInputStream("header1: stuff; param1 = value1; param2 = \"value 2\" \r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, StandardCharsets.US_ASCII.newDecoder());
        Header[] headers = AbstractMessageParser.parseHeaders((SessionInputBuffer)inBuffer, (InputStream)inputStream, (int)-1, (int)-1, null);
        Assertions.assertNotNull((Object)headers);
        Assertions.assertEquals((int)1, (int)headers.length);
        Assertions.assertEquals((Object)"header1: stuff; param1 = value1; param2 = \"value 2\" ", (Object)headers[0].toString());
    }

    @Test
    void testParsingInvalidHeaders() {
        String s1 = "    stuff\r\nheader1: stuff\r\n\r\n";
        ByteArrayInputStream inputStream1 = new ByteArrayInputStream("    stuff\r\nheader1: stuff\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer1 = new SessionInputBufferImpl(16, StandardCharsets.US_ASCII.newDecoder());
        Assertions.assertThrows(ProtocolException.class, () -> TestMessageParser.lambda$testParsingInvalidHeaders$0((SessionInputBuffer)inBuffer1, inputStream1));
        String s2 = "  :  stuff\r\nheader1: stuff\r\n\r\n";
        ByteArrayInputStream inputStream2 = new ByteArrayInputStream("  :  stuff\r\nheader1: stuff\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer2 = new SessionInputBufferImpl(16, StandardCharsets.US_ASCII.newDecoder());
        Assertions.assertThrows(ProtocolException.class, () -> TestMessageParser.lambda$testParsingInvalidHeaders$1((SessionInputBuffer)inBuffer2, inputStream2));
    }

    @Test
    void testParsingMalformedFirstHeader() throws Exception {
        String s = "    header1: stuff\r\nheader2: stuff \r\n";
        ByteArrayInputStream inputStream = new ByteArrayInputStream("    header1: stuff\r\nheader2: stuff \r\n".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, StandardCharsets.US_ASCII.newDecoder());
        Header[] headers = AbstractMessageParser.parseHeaders((SessionInputBuffer)inBuffer, (InputStream)inputStream, (int)-1, (int)-1, null);
        Assertions.assertNotNull((Object)headers);
        Assertions.assertEquals((int)2, (int)headers.length);
        Assertions.assertEquals((Object)"header1", (Object)headers[0].getName());
        Assertions.assertEquals((Object)"stuff", (Object)headers[0].getValue());
        Assertions.assertEquals((Object)"header2", (Object)headers[1].getName());
        Assertions.assertEquals((Object)"stuff", (Object)headers[1].getValue());
    }

    @Test
    void testEmptyDataStream() throws Exception {
        String s = "";
        ByteArrayInputStream inputStream = new ByteArrayInputStream("".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, StandardCharsets.US_ASCII.newDecoder());
        Header[] headers = AbstractMessageParser.parseHeaders((SessionInputBuffer)inBuffer, (InputStream)inputStream, (int)-1, (int)-1, null);
        Assertions.assertNotNull((Object)headers);
        Assertions.assertEquals((int)0, (int)headers.length);
    }

    @Test
    void testMaxHeaderCount() {
        String s = "header1: stuff\r\nheader2: stuff \r\nheader3: stuff\r\n\r\n";
        ByteArrayInputStream inputStream = new ByteArrayInputStream("header1: stuff\r\nheader2: stuff \r\nheader3: stuff\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, StandardCharsets.US_ASCII.newDecoder());
        Assertions.assertThrows(IOException.class, () -> TestMessageParser.lambda$testMaxHeaderCount$2((SessionInputBuffer)inBuffer, inputStream));
    }

    @Test
    void testMaxHeaderCountForFoldedHeader() {
        String s = "header1: stuff\r\n stuff \r\n stuff\r\n\r\n";
        ByteArrayInputStream inputStream = new ByteArrayInputStream("header1: stuff\r\n stuff \r\n stuff\r\n\r\n".getBytes(StandardCharsets.US_ASCII));
        SessionInputBufferImpl inBuffer = new SessionInputBufferImpl(16, StandardCharsets.US_ASCII.newDecoder());
        Assertions.assertThrows(IOException.class, () -> TestMessageParser.lambda$testMaxHeaderCountForFoldedHeader$3((SessionInputBuffer)inBuffer, inputStream));
    }

    private static /* synthetic */ void lambda$testMaxHeaderCountForFoldedHeader$3(SessionInputBuffer inBuffer, ByteArrayInputStream inputStream) throws Throwable {
        AbstractMessageParser.parseHeaders((SessionInputBuffer)inBuffer, (InputStream)inputStream, (int)2, (int)15, null);
    }

    private static /* synthetic */ void lambda$testMaxHeaderCount$2(SessionInputBuffer inBuffer, ByteArrayInputStream inputStream) throws Throwable {
        AbstractMessageParser.parseHeaders((SessionInputBuffer)inBuffer, (InputStream)inputStream, (int)2, (int)-1, null);
    }

    private static /* synthetic */ void lambda$testParsingInvalidHeaders$1(SessionInputBuffer inBuffer2, ByteArrayInputStream inputStream2) throws Throwable {
        AbstractMessageParser.parseHeaders((SessionInputBuffer)inBuffer2, (InputStream)inputStream2, (int)-1, (int)-1, null);
    }

    private static /* synthetic */ void lambda$testParsingInvalidHeaders$0(SessionInputBuffer inBuffer1, ByteArrayInputStream inputStream1) throws Throwable {
        AbstractMessageParser.parseHeaders((SessionInputBuffer)inBuffer1, (InputStream)inputStream1, (int)-1, (int)-1, null);
    }
}

