/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.rest;

import com.codahale.metrics.annotation.ResponseMetered;
import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.gravitino.Entity;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.NameIdentifier;
import org.apache.gravitino.iceberg.service.IcebergExceptionMapper;
import org.apache.gravitino.iceberg.service.IcebergObjectMapper;
import org.apache.gravitino.iceberg.service.IcebergRESTUtils;
import org.apache.gravitino.iceberg.service.authorization.IcebergRESTServerContext;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergNamespaceOperationDispatcher;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.gravitino.server.authorization.MetadataAuthzHelper;
import org.apache.gravitino.server.authorization.annotations.AuthorizationExpression;
import org.apache.gravitino.server.authorization.annotations.AuthorizationMetadata;
import org.apache.gravitino.server.web.Utils;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/{prefix:([^/]*/)?}namespaces")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class IcebergNamespaceOperations {
    private static final Logger LOG = LoggerFactory.getLogger(IcebergNamespaceOperations.class);
    private ObjectMapper icebergObjectMapper;
    private IcebergNamespaceOperationDispatcher namespaceOperationDispatcher;
    @Context
    private HttpServletRequest httpRequest;

    @Inject
    public IcebergNamespaceOperations(IcebergNamespaceOperationDispatcher namespaceOperationDispatcher) {
        this.namespaceOperationDispatcher = namespaceOperationDispatcher;
        this.icebergObjectMapper = IcebergObjectMapper.getInstance();
    }

    @GET
    @Produces(value={"application/json"})
    @Timed(name="list-namespace.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="list-namespace", absolute=true)
    @AuthorizationExpression(expression="ANY_USE_CATALOG || ANY(OWNER, METALAKE, CATALOG)", accessMetadataType=MetadataObject.Type.CATALOG)
    public Response listNamespaces(@DefaultValue(value="") @Encoded @QueryParam(value="parent") String parent, @AuthorizationMetadata(type=Entity.EntityType.CATALOG) @PathParam(value="prefix") String prefix) {
        String catalogName = IcebergRESTUtils.getCatalogName(prefix);
        Namespace parentNamespace = parent.isEmpty() ? Namespace.empty() : RESTUtil.decodeNamespace((String)parent);
        LOG.info("List Iceberg namespaces, catalog: {}, parentNamespace: {}", (Object)catalogName, (Object)parentNamespace);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                ListNamespacesResponse response = this.namespaceOperationDispatcher.listNamespaces(context, parentNamespace);
                IcebergRESTServerContext authContext = IcebergRESTServerContext.getInstance();
                if (authContext.isAuthorizationEnabled()) {
                    response = this.filterListNamespacesResponse(response, authContext.metalakeName(), catalogName);
                }
                return IcebergRESTUtils.ok(response);
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @GET
    @Path(value="{namespace}")
    @Produces(value={"application/json"})
    @Timed(name="load-namespace.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="load-namespace", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || ANY_USE_CATALOG && (SCHEMA::OWNER || ANY_USE_SCHEMA || ANY_CREATE_SCHEMA)", accessMetadataType=MetadataObject.Type.SCHEMA)
    public Response loadNamespace(@AuthorizationMetadata(type=Entity.EntityType.CATALOG) @PathParam(value="prefix") String prefix, @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) @Encoded @PathParam(value="namespace") String namespace) {
        String catalogName = IcebergRESTUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Load Iceberg namespace, catalog: {}, namespace: {}", (Object)catalogName, (Object)icebergNS);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                GetNamespaceResponse getNamespaceResponse = this.namespaceOperationDispatcher.loadNamespace(context, icebergNS);
                return IcebergRESTUtils.ok(getNamespaceResponse);
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @HEAD
    @Path(value="{namespace}")
    @Produces(value={"application/json"})
    @Timed(name="namespace-exists.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="namespace-exists", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || ANY_USE_CATALOG && (SCHEMA::OWNER || ANY_USE_SCHEMA || ANY_CREATE_SCHEMA)", accessMetadataType=MetadataObject.Type.SCHEMA)
    public Response namespaceExists(@AuthorizationMetadata(type=Entity.EntityType.CATALOG) @PathParam(value="prefix") String prefix, @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) @Encoded @PathParam(value="namespace") String namespace) {
        String catalogName = IcebergRESTUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Check Iceberg namespace exists, catalog: {}, namespace: {}", (Object)catalogName, (Object)icebergNS);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                boolean exists = this.namespaceOperationDispatcher.namespaceExists(context, icebergNS);
                if (exists) {
                    return IcebergRESTUtils.noContent();
                }
                return IcebergRESTUtils.notExists();
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @DELETE
    @Path(value="{namespace}")
    @Produces(value={"application/json"})
    @Timed(name="drop-namespace.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="drop-namespace", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG", accessMetadataType=MetadataObject.Type.SCHEMA)
    public Response dropNamespace(@AuthorizationMetadata(type=Entity.EntityType.CATALOG) @PathParam(value="prefix") String prefix, @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) @Encoded @PathParam(value="namespace") String namespace) {
        String catalogName = IcebergRESTUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Drop Iceberg namespace, catalog: {}, namespace: {}", (Object)catalogName, (Object)icebergNS);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                this.namespaceOperationDispatcher.dropNamespace(context, icebergNS);
                return IcebergRESTUtils.noContent();
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Timed(name="create-namespace.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="create-namespace", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || ANY_USE_CATALOG && ANY_CREATE_SCHEMA", accessMetadataType=MetadataObject.Type.CATALOG)
    public Response createNamespace(@AuthorizationMetadata(type=Entity.EntityType.CATALOG) @PathParam(value="prefix") String prefix, CreateNamespaceRequest createNamespaceRequest) {
        String catalogName = IcebergRESTUtils.getCatalogName(prefix);
        LOG.info("Create Iceberg namespace, catalog: {}, createNamespaceRequest: {}", (Object)catalogName, (Object)createNamespaceRequest);
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                CreateNamespaceResponse createNamespaceResponse = this.namespaceOperationDispatcher.createNamespace(context, createNamespaceRequest);
                return IcebergRESTUtils.ok(createNamespaceResponse);
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @POST
    @Path(value="{namespace}/properties")
    @Produces(value={"application/json"})
    @Timed(name="update-namespace.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="update-namespace", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG", accessMetadataType=MetadataObject.Type.SCHEMA)
    public Response updateNamespace(@AuthorizationMetadata(type=Entity.EntityType.CATALOG) @PathParam(value="prefix") String prefix, @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) @Encoded @PathParam(value="namespace") String namespace, UpdateNamespacePropertiesRequest updateNamespacePropertiesRequest) {
        String catalogName = IcebergRESTUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Update Iceberg namespace, catalog: {}, namespace: {}, updateNamespacePropertiesRequest: {}", new Object[]{catalogName, icebergNS, this.SerializeUpdateNamespacePropertiesRequest(updateNamespacePropertiesRequest)});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                UpdateNamespacePropertiesResponse updateNamespacePropertiesResponse = this.namespaceOperationDispatcher.updateNamespace(context, icebergNS, updateNamespacePropertiesRequest);
                return IcebergRESTUtils.ok(updateNamespacePropertiesResponse);
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    @POST
    @Path(value="{namespace}/register")
    @Produces(value={"application/json"})
    @Timed(name="register-table.http-request-duration-seconds", absolute=true)
    @ResponseMetered(name="register-table", absolute=true)
    @AuthorizationExpression(expression="ANY(OWNER, METALAKE, CATALOG) || SCHEMA_OWNER_WITH_USE_CATALOG || ANY_USE_CATALOG && ANY_USE_SCHEMA && ANY_CREATE_TABLE", accessMetadataType=MetadataObject.Type.SCHEMA)
    public Response registerTable(@AuthorizationMetadata(type=Entity.EntityType.CATALOG) @PathParam(value="prefix") String prefix, @AuthorizationMetadata(type=Entity.EntityType.SCHEMA) @Encoded @PathParam(value="namespace") String namespace, RegisterTableRequest registerTableRequest) {
        String catalogName = IcebergRESTUtils.getCatalogName(prefix);
        Namespace icebergNS = RESTUtil.decodeNamespace((String)namespace);
        LOG.info("Register Iceberg table, catalog: {}, namespace: {}, registerTableRequest: {}", new Object[]{catalogName, icebergNS, registerTableRequest});
        try {
            return Utils.doAs((HttpServletRequest)this.httpRequest, () -> {
                IcebergRequestContext context = new IcebergRequestContext(this.httpServletRequest(), catalogName);
                LoadTableResponse loadTableResponse = this.namespaceOperationDispatcher.registerTable(context, icebergNS, registerTableRequest);
                return IcebergRESTUtils.ok(loadTableResponse);
            });
        }
        catch (Exception e) {
            return IcebergExceptionMapper.toRESTResponse(e);
        }
    }

    private NameIdentifier[] toNameIdentifiers(ListNamespacesResponse listNamespacesResponse, String metalake, String catalogName) {
        List namespaces = listNamespacesResponse.namespaces();
        NameIdentifier[] nameIdentifiers = new NameIdentifier[namespaces.size()];
        for (int i = 0; i < namespaces.size(); ++i) {
            Namespace namespace = (Namespace)namespaces.get(i);
            String schemaName = namespace.isEmpty() ? "" : namespace.level(0);
            nameIdentifiers[i] = NameIdentifier.of((String[])new String[]{metalake, catalogName, schemaName});
        }
        return nameIdentifiers;
    }

    private ListNamespacesResponse filterListNamespacesResponse(ListNamespacesResponse listNamespacesResponse, String metalake, String catalogName) {
        NameIdentifier[] idents = MetadataAuthzHelper.filterByExpression((String)metalake, (String)"ANY(OWNER, METALAKE, CATALOG, SCHEMA) || ANY_USE_SCHEMA", (Entity.EntityType)Entity.EntityType.SCHEMA, (NameIdentifier[])this.toNameIdentifiers(listNamespacesResponse, metalake, catalogName));
        ArrayList<Namespace> filteredNamespaces = new ArrayList<Namespace>();
        for (NameIdentifier ident : idents) {
            if (!ident.hasNamespace() || ident.namespace().levels().length < 2) continue;
            String schemaName = ident.name();
            filteredNamespaces.add(Namespace.of((String[])new String[]{schemaName}));
        }
        return ListNamespacesResponse.builder().addAll(filteredNamespaces).build();
    }

    @VisibleForTesting
    HttpServletRequest httpServletRequest() {
        return this.httpRequest;
    }

    private String SerializeUpdateNamespacePropertiesRequest(UpdateNamespacePropertiesRequest updateNamespacePropertiesRequest) {
        try {
            return this.icebergObjectMapper.writeValueAsString((Object)updateNamespacePropertiesRequest);
        }
        catch (JsonProcessingException e) {
            LOG.warn("Serialize update namespace properties failed", (Throwable)e);
            return updateNamespacePropertiesRequest.toString();
        }
    }
}

