/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks.cs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Version;
import org.jgroups.blocks.cs.Connection;
import org.jgroups.blocks.cs.TcpBaseServer;
import org.jgroups.blocks.cs.TcpServer;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Buffer;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public class TcpConnection
extends Connection {
    protected final Socket sock;
    protected final ReentrantLock send_lock = new ReentrantLock();
    protected static final Buffer termination = new Buffer(cookie);
    protected DataOutputStream out;
    protected DataInputStream in;
    protected volatile Sender sender;
    protected volatile Receiver receiver;
    protected final TcpBaseServer server;
    protected boolean connected;

    public TcpConnection(Address peer_addr, TcpBaseServer server) throws Exception {
        this.server = server;
        if (peer_addr == null) {
            throw new IllegalArgumentException("Invalid parameter peer_addr=" + peer_addr);
        }
        this.peer_addr = peer_addr;
        this.sock = server.socketFactory().createSocket("jgroups.tcp.sock");
        this.setSocketParameters(this.sock);
        this.last_access = this.getTimestamp();
    }

    public TcpConnection(Socket s, TcpServer server) throws Exception {
        this.sock = s;
        this.server = server;
        if (s == null) {
            throw new IllegalArgumentException("Invalid parameter s=" + s);
        }
        this.setSocketParameters(s);
        this.out = new DataOutputStream(new BufferedOutputStream(s.getOutputStream()));
        this.in = new DataInputStream(new BufferedInputStream(s.getInputStream()));
        this.connected = this.sock.isConnected();
        this.peer_addr = server.usePeerConnections() ? this.readPeerAddress(s) : new IpAddress((InetSocketAddress)s.getRemoteSocketAddress());
        this.last_access = this.getTimestamp();
    }

    @Override
    public Address localAddress() {
        InetSocketAddress local_addr = this.sock != null ? (InetSocketAddress)this.sock.getLocalSocketAddress() : null;
        return local_addr != null ? new IpAddress(local_addr) : null;
    }

    @Override
    public Address peerAddress() {
        return this.peer_addr;
    }

    protected long getTimestamp() {
        return this.server.timeService() != null ? this.server.timeService().timestamp() : System.nanoTime();
    }

    protected boolean isSenderUsed() {
        return this.server.sendQueueSize() > 0 && this.server.use_send_queues;
    }

    protected String getSockAddress() {
        StringBuilder sb = new StringBuilder();
        if (this.sock != null) {
            sb.append(this.sock.getLocalAddress().getHostAddress()).append(':').append(this.sock.getLocalPort());
            sb.append(" - ").append(this.sock.getInetAddress().getHostAddress()).append(':').append(this.sock.getPort());
        }
        return sb.toString();
    }

    protected void updateLastAccessed() {
        if (this.server.connExpireTime() > 0L) {
            this.last_access = this.getTimestamp();
        }
    }

    @Override
    public void connect(Address dest) throws Exception {
        this.connect(dest, this.server.usePeerConnections());
    }

    protected void connect(Address dest, boolean send_local_addr) throws Exception {
        InetSocketAddress destAddr = new InetSocketAddress(((IpAddress)dest).getIpAddress(), ((IpAddress)dest).getPort());
        try {
            if (!this.server.defer_client_binding) {
                this.sock.bind(new InetSocketAddress(this.server.client_bind_addr, this.server.client_bind_port));
            }
            if (this.sock.getLocalSocketAddress() != null && this.sock.getLocalSocketAddress().equals(destAddr)) {
                throw new IllegalStateException("socket's bind and connect address are the same: " + destAddr);
            }
            Util.connect(this.sock, destAddr, this.server.sock_conn_timeout);
            this.out = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
            this.in = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
            this.connected = this.sock.isConnected();
            if (send_local_addr) {
                this.sendLocalAddress(this.server.localAddress());
            }
        }
        catch (Exception t) {
            Util.close((Closeable)this.sock);
            this.connected = false;
            throw t;
        }
    }

    @Override
    public void start() {
        if (this.receiver != null) {
            this.receiver.stop();
        }
        this.receiver = new Receiver(this.server.factory).start();
        if (this.isSenderUsed()) {
            if (this.sender != null) {
                this.sender.stop();
            }
            this.sender = new Sender(this.server.factory, this.server.sendQueueSize()).start();
        }
    }

    @Override
    public void send(byte[] data, int offset, int length) throws Exception {
        if (this.sender != null) {
            byte[] copy = new byte[length];
            System.arraycopy(data, offset, copy, 0, length);
            this.sender.addToQueue(new Buffer(copy, 0, length));
        } else {
            this._send(data, offset, length, true, true);
        }
    }

    @Override
    public void send(ByteBuffer buf) throws Exception {
        if (buf == null) {
            return;
        }
        int offset = buf.hasArray() ? buf.arrayOffset() + buf.position() : buf.position();
        int len = buf.remaining();
        if (!buf.isDirect()) {
            this.send(buf.array(), offset, len);
        } else {
            byte[] tmp = new byte[len];
            buf.get(tmp, 0, len);
            this.send(tmp, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _send(byte[] data, int offset, int length, boolean acquire_lock, boolean flush) throws Exception {
        if (acquire_lock) {
            this.send_lock.lock();
        }
        try {
            this.doSend(data, offset, length, acquire_lock, flush);
            this.updateLastAccessed();
        }
        catch (InterruptedException iex) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (acquire_lock) {
                this.send_lock.unlock();
            }
        }
    }

    protected void doSend(byte[] data, int offset, int length, boolean acquire_lock, boolean flush) throws Exception {
        if (this.out == null) {
            return;
        }
        this.out.writeInt(length);
        this.out.write(data, offset, length);
        if (!flush || acquire_lock && this.send_lock.hasQueuedThreads()) {
            return;
        }
        this.out.flush();
    }

    protected void flush() throws Exception {
        if (this.out != null) {
            this.out.flush();
        }
    }

    protected void setSocketParameters(Socket client_sock) throws SocketException {
        try {
            client_sock.setSendBufferSize(this.server.send_buf_size);
        }
        catch (IllegalArgumentException ex) {
            this.server.log.error("%s: exception setting send buffer to %d bytes: %s", this.server.local_addr, this.server.send_buf_size, ex);
        }
        try {
            client_sock.setReceiveBufferSize(this.server.recv_buf_size);
        }
        catch (IllegalArgumentException ex) {
            this.server.log.error("%s: exception setting receive buffer to %d bytes: %s", this.server.local_addr, this.server.recv_buf_size, ex);
        }
        client_sock.setKeepAlive(true);
        client_sock.setTcpNoDelay(this.server.tcp_nodelay);
        if (this.server.linger > 0) {
            client_sock.setSoLinger(true, this.server.linger);
        } else {
            client_sock.setSoLinger(false, -1);
        }
    }

    protected void sendLocalAddress(Address local_addr) throws Exception {
        try {
            this.out.write(cookie, 0, cookie.length);
            this.out.writeShort(Version.version);
            this.out.writeShort(local_addr.size());
            local_addr.writeTo(this.out);
            this.out.flush();
            this.updateLastAccessed();
        }
        catch (Exception ex) {
            this.server.socket_factory.close(this.sock);
            this.connected = false;
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Address readPeerAddress(Socket client_sock) throws Exception {
        int timeout = client_sock.getSoTimeout();
        client_sock.setSoTimeout(this.server.peerAddressReadTimeout());
        try {
            byte[] input_cookie = new byte[cookie.length];
            this.in.readFully(input_cookie, 0, input_cookie.length);
            if (!Arrays.equals(cookie, input_cookie)) {
                throw new SocketException(String.format("%s: BaseServer.TcpConnection.readPeerAddress(): cookie sent by %s:%d does not match own cookie; terminating connection", this.server.localAddress(), client_sock.getInetAddress(), client_sock.getPort()));
            }
            short version = this.in.readShort();
            if (!Version.isBinaryCompatible(version)) {
                throw new IOException("packet from " + client_sock.getInetAddress() + ":" + client_sock.getPort() + " has different version (" + Version.print(version) + ") from ours (" + Version.printVersion() + "); discarding it");
            }
            this.in.readShort();
            IpAddress client_peer_addr = new IpAddress();
            client_peer_addr.readFrom(this.in);
            this.updateLastAccessed();
            IpAddress ipAddress = client_peer_addr;
            return ipAddress;
        }
        finally {
            client_sock.setSoTimeout(timeout);
        }
    }

    public String toString() {
        Socket tmp_sock = this.sock;
        if (tmp_sock == null) {
            return "<null socket>";
        }
        InetAddress local = tmp_sock.getLocalAddress();
        InetAddress remote = tmp_sock.getInetAddress();
        String local_str = local != null ? Util.shortName(local) : "<null>";
        String remote_str = remote != null ? Util.shortName(remote) : "<null>";
        return String.format("%s:%s --> %s:%s (%d secs old) [%s] [recv_buf=%d]", local_str, tmp_sock.getLocalPort(), remote_str, tmp_sock.getPort(), TimeUnit.SECONDS.convert(this.getTimestamp() - this.last_access, TimeUnit.NANOSECONDS), this.status(), this.receiver != null ? this.receiver.bufferSize() : 0);
    }

    @Override
    public String status() {
        if (this.sock == null) {
            return "n/a";
        }
        if (this.isConnected()) {
            return "connected";
        }
        if (this.isOpen()) {
            return "open";
        }
        return "closed";
    }

    @Override
    public boolean isExpired(long now) {
        return this.server.conn_expire_time > 0L && now - this.last_access >= this.server.conn_expire_time;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isConnectionPending() {
        return false;
    }

    @Override
    public boolean isOpen() {
        return this.sock != null && !this.sock.isClosed();
    }

    @Override
    public void close() throws IOException {
        this.send_lock.lock();
        try {
            Util.close(this.out, this.in, this.sock);
            if (this.receiver != null) {
                this.receiver.stop();
                this.receiver = null;
            }
            if (this.sender != null) {
                this.sender.stop();
                this.sender = null;
            }
        }
        finally {
            this.connected = false;
            this.send_lock.unlock();
        }
    }

    protected class Sender
    implements Runnable {
        protected final BlockingQueue<Buffer> send_queue;
        protected final Thread runner;
        protected volatile boolean started = true;

        public Sender(ThreadFactory tf, int send_queue_size) {
            this.runner = tf.newThread(this, "Connection.Sender [" + TcpConnection.this.getSockAddress() + "]");
            this.send_queue = new LinkedBlockingQueue<Buffer>(send_queue_size);
        }

        public void addToQueue(Buffer data) throws Exception {
            if (this.canRun() && !this.send_queue.offer(data, TcpConnection.this.server.sock_conn_timeout, TimeUnit.MILLISECONDS)) {
                TcpConnection.this.server.log.warn("%s: discarding message because TCP send_queue is full and hasn't been releasing for %d ms", TcpConnection.this.server.local_addr, TcpConnection.this.server.sock_conn_timeout);
            }
        }

        public Sender start() {
            this.started = true;
            this.runner.start();
            return this;
        }

        public Sender stop() {
            this.send_queue.offer(termination);
            this.started = false;
            return this;
        }

        public boolean isRunning() {
            return this.started;
        }

        public boolean canRun() {
            return this.isRunning() && TcpConnection.this.isConnected();
        }

        @Override
        public void run() {
            Throwable t = null;
            while (this.canRun()) {
                Buffer data;
                block6: {
                    data = null;
                    try {
                        data = this.send_queue.take();
                        if (data.hashCode() == termination.hashCode()) {
                        }
                        break block6;
                    }
                    catch (InterruptedException e) {
                        t = e;
                    }
                    break;
                }
                try {
                    TcpConnection.this._send(data.getBuf(), 0, data.getLength(), false, this.send_queue.isEmpty());
                }
                catch (Throwable ignored) {
                    t = ignored;
                }
            }
            TcpConnection.this.server.notifyConnectionClosed(TcpConnection.this);
        }
    }

    protected class Receiver
    implements Runnable {
        protected final Thread recv;
        protected volatile boolean receiving = true;
        protected volatile byte[] buffer;

        public Receiver(ThreadFactory f) {
            this.recv = f.newThread(this, "Connection.Receiver [" + TcpConnection.this.getSockAddress() + "]");
        }

        public Receiver start() {
            this.receiving = true;
            this.recv.start();
            return this;
        }

        public Receiver stop() {
            this.receiving = false;
            return this;
        }

        public boolean isRunning() {
            return this.receiving;
        }

        public boolean canRun() {
            return this.isRunning() && TcpConnection.this.isConnected();
        }

        public int bufferSize() {
            return this.buffer != null ? this.buffer.length : 0;
        }

        @Override
        public void run() {
            try {
                while (this.canRun()) {
                    int len = TcpConnection.this.in.readInt();
                    if (this.buffer == null || this.buffer.length < len) {
                        this.buffer = new byte[len];
                    }
                    TcpConnection.this.in.readFully(this.buffer, 0, len);
                    TcpConnection.this.updateLastAccessed();
                    TcpConnection.this.server.receive(TcpConnection.this.peer_addr, this.buffer, 0, len);
                }
            }
            catch (EOFException | SocketException len) {
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("failed handling message from %s: %s", TcpConnection.this.peer_addr, e));
            }
            finally {
                TcpConnection.this.server.notifyConnectionClosed(TcpConnection.this);
            }
        }
    }
}

