/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.RegionEntryContext;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.entries.OffHeapRegionEntry;
import org.apache.geode.internal.offheap.OffHeapRegionEntryHelperInstance;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.offheap.TinyStoredObject;

public class OffHeapRegionEntryHelper {
    @Immutable
    private static final OffHeapRegionEntryHelper INSTANCE = new OffHeapRegionEntryHelper(new OffHeapRegionEntryHelperInstance());
    private final OffHeapRegionEntryHelperInstance delegate;

    private OffHeapRegionEntryHelper(OffHeapRegionEntryHelperInstance delegate) {
        this.delegate = delegate;
    }

    private static OffHeapRegionEntryHelperInstance delegate() {
        return OffHeapRegionEntryHelper.INSTANCE.delegate;
    }

    public static Object addressToObject(long ohAddress, boolean decompress, RegionEntryContext context) {
        return OffHeapRegionEntryHelper.delegate().addressToObject(ohAddress, decompress, context);
    }

    public static int getSerializedLength(TinyStoredObject dataAsAddress) {
        return OffHeapRegionEntryHelper.delegate().getSerializedLength(dataAsAddress);
    }

    public static void releaseEntry(OffHeapRegionEntry re) {
        OffHeapRegionEntryHelper.delegate().releaseEntry(re);
    }

    public static void releaseEntry(OffHeapRegionEntry re, StoredObject expectedValue) {
        OffHeapRegionEntryHelper.delegate().releaseEntry(re, expectedValue);
    }

    static long encodeDataAsAddress(byte[] v, boolean isSerialized, boolean isCompressed) {
        return OffHeapRegionEntryHelper.delegate().encodeDataAsAddress(v, isSerialized, isCompressed);
    }

    static Object decodeAddressToObject(long ohAddress) {
        return OffHeapRegionEntryHelper.delegate().decodeAddressToObject(ohAddress);
    }

    static int decodeAddressToDataSize(long addr) {
        return OffHeapRegionEntryHelper.delegate().decodeAddressToDataSize(addr);
    }

    static byte[] decodeUncompressedAddressToBytes(long addr) {
        return OffHeapRegionEntryHelper.delegate().decodeUncompressedAddressToBytes(addr);
    }

    static byte[] decodeAddressToRawBytes(long addr) {
        return OffHeapRegionEntryHelper.delegate().decodeAddressToRawBytes(addr);
    }

    public static void setValue(OffHeapRegionEntry re, Object v) {
        OffHeapRegionEntryHelper.delegate().setValue(re, v);
    }

    public static Token getValueAsToken(OffHeapRegionEntry re) {
        return OffHeapRegionEntryHelper.delegate().getValueAsToken(re);
    }

    public static Object _getValue(OffHeapRegionEntry re) {
        return OffHeapRegionEntryHelper.delegate()._getValue(re);
    }

    public static boolean isOffHeap(long addr) {
        return OffHeapRegionEntryHelper.delegate().isOffHeap(addr);
    }

    public static Object _getValueRetain(OffHeapRegionEntry re, boolean decompress, RegionEntryContext context) {
        return OffHeapRegionEntryHelper.delegate()._getValueRetain(re, decompress, context);
    }

    public static boolean isSerialized(long address) {
        return OffHeapRegionEntryHelper.delegate().isSerialized(address);
    }

    public static boolean isCompressed(long address) {
        return OffHeapRegionEntryHelper.delegate().isCompressed(address);
    }
}

