/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.filewatch.FileWatchingX509ExtendedKeyManager;
import org.apache.geode.internal.net.filewatch.FileWatchingX509ExtendedTrustManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SSLUtil {
    static final String[] SUPPORTED_CONTEXTS = new String[]{"TLSv1.3", "TLSv1.2"};

    @NotNull
    public static SSLContext getSSLContextInstance() throws NoSuchAlgorithmException {
        for (String protocol : SUPPORTED_CONTEXTS) {
            try {
                return SSLContext.getInstance(protocol);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
        }
        throw new NoSuchAlgorithmException();
    }

    @NotNull
    static String[] split(@Nullable String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return new String[0];
        }
        return text.split("[\\s,]+");
    }

    @NotNull
    public static SSLContext createAndConfigureSSLContext(@NotNull SSLConfig sslConfig, boolean skipSslVerification) {
        try {
            if (sslConfig.useDefaultSSLContext()) {
                return SSLContext.getDefault();
            }
            SSLContext ssl = SSLUtil.getSSLContextInstance();
            KeyManager[] keyManagers = sslConfig.getKeystore() != null ? new KeyManager[]{FileWatchingX509ExtendedKeyManager.newFileWatchingKeyManager(sslConfig)} : null;
            TrustManager[] trustManagers = skipSslVerification ? new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }} : (sslConfig.getTruststore() != null ? new TrustManager[]{FileWatchingX509ExtendedTrustManager.newFileWatchingTrustManager(sslConfig)} : null);
            ssl.init(keyManagers, trustManagers, new SecureRandom());
            return ssl;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @NotNull
    static KeyManagerFactory getDefaultKeyManagerFactory() throws NoSuchAlgorithmException {
        return KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
    }

    @NotNull
    static TrustManagerFactory getDefaultTrustManagerFactory() throws NoSuchAlgorithmException {
        return TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
    }
}

