/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.HighPriorityDistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class IdentityRequestMessage
extends DistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private static final int UNINITIALIZED = -1;
    @MakeNotStatic
    private static int latestId = -1;
    private int processorId;

    public static synchronized void setLatestId(int newlatest) {
        if (newlatest > latestId) {
            latestId = newlatest;
        }
    }

    public static synchronized int getLatestId() {
        return latestId;
    }

    public IdentityRequestMessage() {
    }

    public IdentityRequestMessage(Set recipients, int processorId) {
        this.setRecipients(recipients);
        this.processorId = processorId;
    }

    @Override
    protected void process(ClusterDistributionManager dm) {
        try {
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{}: processing message {}", (Object)this.getClass().getName(), (Object)this);
            }
            IdentityReplyMessage.send(this.getSender(), this.getProcessorId(), dm);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            SystemFailure.checkFailure();
            logger.debug("{} Caught throwable {}", (Object)this, (Object)t.getMessage(), (Object)t);
        }
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    @Override
    public int getProcessorType() {
        return 75;
    }

    public static IdentityResponse send(Set recipients, InternalDistributedSystem is) {
        Assert.assertTrue(recipients != null, "IdentityMessage NULL recipients set");
        int i = 0;
        Iterator ri = recipients.iterator();
        while (ri.hasNext()) {
            Assert.assertTrue(null != ri.next(), "IdenityMessage recipient " + i + " is null");
            ++i;
        }
        IdentityResponse p = new IdentityResponse(is, recipients);
        IdentityRequestMessage m = new IdentityRequestMessage(recipients, p.getProcessorId());
        is.getDistributionManager().putOutgoing(m);
        return p;
    }

    public int getDSFID() {
        return 50;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.processorId = in.readInt();
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.processorId);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(sender=" + this.getSender() + "; processorId=" + this.processorId + ")";
    }

    public static class IdentityResponse
    extends ReplyProcessor21 {
        private Integer returnValue;

        public IdentityResponse(InternalDistributedSystem system, Set initMembers) {
            super(system, (Collection)initMembers);
            int localIdent = IdentityRequestMessage.getLatestId();
            if (localIdent != -1) {
                this.returnValue = localIdent;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            block11: {
                try {
                    if (!(msg instanceof IdentityReplyMessage)) break block11;
                    IdentityReplyMessage reply = (IdentityReplyMessage)msg;
                    Integer remoteId = reply.getId();
                    IdentityResponse identityResponse = this;
                    synchronized (identityResponse) {
                        if (remoteId != null) {
                            if (this.returnValue == null) {
                                this.returnValue = remoteId;
                            } else if (remoteId > this.returnValue) {
                                this.returnValue = remoteId;
                            }
                        }
                    }
                    if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                        logger.trace(LogMarker.DM_VERBOSE, "{} return value is {}", (Object)this.getClass().getName(), (Object)this.returnValue);
                    }
                }
                finally {
                    super.process(msg);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Integer waitForId() {
            try {
                this.waitForRepliesUninterruptibly();
            }
            catch (ReplyException e) {
                logger.debug("{} waitBucketSizes ignoring exception {}", (Object)this.getClass().getName(), (Object)e.getMessage(), (Object)e);
            }
            IdentityResponse identityResponse = this;
            synchronized (identityResponse) {
                return this.returnValue;
            }
        }
    }

    public static class IdentityReplyMessage
    extends HighPriorityDistributionMessage {
        private int Id = -1;
        private int processorId;

        public IdentityReplyMessage() {
        }

        private IdentityReplyMessage(int processorId) {
            this.processorId = processorId;
            this.Id = IdentityRequestMessage.getLatestId();
        }

        public static void send(InternalDistributedMember recipient, int processorId, DistributionManager dm) {
            Assert.assertTrue(recipient != null, "IdentityReplyMessage NULL reply message");
            IdentityReplyMessage m = new IdentityReplyMessage(processorId);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        protected void process(ClusterDistributionManager dm) {
            ReplyProcessor21 processor;
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} process invoking reply processor with processorId:{}", (Object)this.getClass().getName(), (Object)this.processorId);
            }
            if ((processor = ReplyProcessor21.getProcessor(this.processorId)) == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "Processor not found: {}", (Object)this.getClass().getName());
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} Processed {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(DistributionStats.getStatTime() - startTime);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            out.writeInt(this.processorId);
            out.writeInt(this.Id);
        }

        public int getDSFID() {
            return 67;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            this.processorId = in.readInt();
            this.Id = in.readInt();
        }

        @Override
        public String toString() {
            return this.getClass().getName() + "(sender=" + this.getSender() + "; processorId=" + this.processorId + "; PRId=" + this.getId() + ")";
        }

        public Integer getId() {
            if (this.Id == -1) {
                return null;
            }
            return this.Id;
        }
    }
}

