/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryExistsException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.ReplySender;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.EnumListenerEvent;
import org.apache.geode.internal.cache.EventID;
import org.apache.geode.internal.cache.FilterRoutingInfo;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.PrimaryBucketException;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.cache.partitioned.PartitionMessageWithDirectReply;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.versions.DiskVersionTag;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class DestroyMessage
extends PartitionMessageWithDirectReply {
    private static final Logger logger = LogService.getLogger();
    private Object key;
    private Object cbArg;
    private Operation op;
    ClientProxyMembershipID bridgeContext;
    EventID eventId;
    InternalDistributedMember originalSender;
    private Object expectedOldValue;
    protected FilterRoutingInfo filterInfo;
    protected VersionTag versionTag;
    private static final byte HAS_VERSION_TAG = 1;
    private static final byte PERSISTENT_TAG = 2;
    protected static final short CACHE_WRITE = 4096;

    public DestroyMessage() {
    }

    protected DestroyMessage(Set recipients, boolean notifyOnly, int regionId, DirectReplyProcessor processor, EntryEventImpl event, Object expectedOldValue) {
        super(recipients, regionId, processor, event);
        this.expectedOldValue = expectedOldValue;
        this.key = event.getKey();
        this.cbArg = event.getRawCallbackArgument();
        this.op = event.getOperation();
        this.notificationOnly = notifyOnly;
        this.bridgeContext = event.getContext();
        this.eventId = event.getEventId();
        this.versionTag = event.getVersionTag();
    }

    DestroyMessage(DestroyMessage original, EntryEventImpl event, Set members) {
        this(original);
        if (event != null) {
            this.posDup = event.isPossibleDuplicate();
            this.versionTag = event.getVersionTag();
        }
    }

    DestroyMessage(DestroyMessage original) {
        this.expectedOldValue = original.expectedOldValue;
        this.regionId = original.regionId;
        this.processorId = original.processorId;
        this.key = original.key;
        this.cbArg = original.cbArg;
        this.op = original.op;
        this.notificationOnly = true;
        this.bridgeContext = original.bridgeContext;
        this.originalSender = original.getSender();
        this.eventId = original.eventId;
        this.posDup = original.posDup;
        this.versionTag = original.versionTag;
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    public static Set notifyListeners(Set cacheOpReceivers, Set adjunctRecipients, FilterRoutingInfo filterRoutingInfo, PartitionedRegion r, EntryEventImpl event, DirectReplyProcessor processor) {
        DestroyMessage msg = new DestroyMessage(Collections.EMPTY_SET, true, r.getPRId(), processor, event, null);
        msg.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        msg.versionTag = event.getVersionTag();
        return msg.relayToListeners(cacheOpReceivers, adjunctRecipients, filterRoutingInfo, event, r, processor);
    }

    public static DestroyResponse send(DistributedMember recipient, PartitionedRegion r, EntryEventImpl event, Object expectedOldValue) throws ForceReattemptException {
        Set<DistributedMember> recipients = Collections.singleton(recipient);
        DestroyResponse p = new DestroyResponse(r.getSystem(), recipients, (Object)false);
        p.requireResponse();
        DestroyMessage m = new DestroyMessage(recipients, false, r.getPRId(), p, event, expectedOldValue);
        m.setTransactionDistributed(r.getCache().getTxManager().isDistributed());
        Set<InternalDistributedMember> failures = r.getDistributionManager().putOutgoing(m);
        if (failures != null && failures.size() > 0) {
            throw new ForceReattemptException(String.format("Failed sending < %s >", m));
        }
        return p;
    }

    @Override
    public PartitionMessage getMessageForRelayToListeners(EntryEventImpl event, Set members) {
        DestroyMessage msg = new DestroyMessage(this, event, members);
        msg.expectedOldValue = null;
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion r, long startTime) throws EntryExistsException, DataLocationException {
        block24: {
            eventSender = this.originalSender;
            if (eventSender == null) {
                eventSender = this.getSender();
            }
            event = null;
            if (this.bridgeContext != null) {
                event = EntryEventImpl.create(r, this.getOperation(), this.key, null, this.getCallbackArg(), false, eventSender, true);
                event.setContext(this.bridgeContext);
            } else {
                event = EntryEventImpl.create((InternalRegion)r, this.getOperation(), this.key, null, this.getCallbackArg(), false, (DistributedMember)eventSender, true, false);
            }
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(this.getSender());
                event.setVersionTag(this.versionTag);
            }
            event.setInvokePRCallbacks(this.notificationOnly == false);
            Assert.assertTrue(this.eventId != null);
            event.setEventId(this.eventId);
            event.setPossibleDuplicate(this.posDup);
            ds = r.getDataStore();
            sendReply = true;
            if (this.notificationOnly) break block24;
            Assert.assertTrue(ds != null, "This process should have storage for an item in " + this);
            try {
                bucket = PartitionedRegionHelper.getHashKey(r, null, this.key, null, this.cbArg);
                event.setCausedByMessage(this);
                r.getDataView().destroyOnRemote(event, true, this.expectedOldValue);
                if (DestroyMessage.logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    DestroyMessage.logger.trace(LogMarker.DM_VERBOSE, "{} updated bucket: {} with key: {}", (Object)this.getClass().getName(), (Object)bucket, this.key);
                }
                ** GOTO lbl46
            }
            catch (CacheWriterException cwe) {
                this.sendReply(this.getSender(), this.processorId, dm, new ReplyException(cwe), r, startTime);
                var10_13 = false;
                if (event == null) return var10_13;
                event.release();
                return var10_13;
            }
            catch (EntryNotFoundException eee) {
                DestroyMessage.logger.trace(LogMarker.DM_VERBOSE, "{}: operateOnRegion caught EntryNotFoundException", (Object)this.getClass().getName());
                ReplyMessage.send(this.getSender(), this.getProcessorId(), new ReplyException(eee), this.getReplySender(dm), r.isInternalRegion());
                sendReply = false;
                {
                    catch (Throwable var11_14) {
                        throw var11_14;
                    }
                    catch (PrimaryBucketException pbe) {}
                    {
                        this.sendReply(this.getSender(), this.getProcessorId(), dm, new ReplyException(pbe), r, startTime);
                        sendReply = false;
                    }
                }
lbl46:
                // 4 sources

                while (true) {
                    var9_12 = sendReply;
                    return var9_12;
                }
            }
            finally {
                this.versionTag = event.getVersionTag();
            }
        }
        e2 = this.createListenerEvent(event, r, dm.getDistributionManagerId());
        try {
            r.invokeDestroyCallbacks(EnumListenerEvent.AFTER_DESTROY, e2, r.isInitialized(), true);
            ** continue;
        }
        finally {
            if (event != null) {
                event.release();
            }
        }
    }

    @Override
    protected void sendReply(InternalDistributedMember member, int procId, DistributionManager dm, ReplyException ex, PartitionedRegion pr, long startTime) {
        if (pr != null && startTime > 0L) {
            pr.getPrStats().endPartitionMessagesProcessing(startTime);
        }
        if (ex == null) {
            DestroyReplyMessage.send(this.getSender(), this.getReplySender(dm), this.processorId, this.versionTag, pr != null && pr.isInternalRegion());
        } else {
            ReplyMessage.send(this.getSender(), this.processorId, ex, this.getReplySender(dm), pr != null && pr.isInternalRegion());
        }
    }

    public int getDSFID() {
        return 73;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        boolean hasFilterInfo;
        super.fromData(in, context);
        this.setKey(DataSerializer.readObject(in));
        this.cbArg = DataSerializer.readObject(in);
        this.op = Operation.fromOrdinal(in.readByte());
        this.notificationOnly = in.readBoolean();
        this.bridgeContext = ClientProxyMembershipID.readCanonicalized(in);
        this.originalSender = (InternalDistributedMember)DataSerializer.readObject(in);
        this.eventId = (EventID)DataSerializer.readObject(in);
        this.expectedOldValue = DataSerializer.readObject(in);
        boolean bl = hasFilterInfo = (this.flags & 0x400) != 0;
        if (hasFilterInfo) {
            this.filterInfo = new FilterRoutingInfo();
            InternalDataSerializer.invokeFromData(this.filterInfo, in);
        }
        this.versionTag = (VersionTag)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        DataSerializer.writeObject(this.getKey(), out);
        DataSerializer.writeObject(this.cbArg, out);
        out.writeByte(this.op.ordinal);
        out.writeBoolean(this.notificationOnly);
        DataSerializer.writeObject(this.bridgeContext, out);
        DataSerializer.writeObject(this.originalSender, out);
        DataSerializer.writeObject(this.eventId, out);
        DataSerializer.writeObject(this.expectedOldValue, out);
        if (this.filterInfo != null) {
            InternalDataSerializer.invokeToData(this.filterInfo, out);
        }
        DataSerializer.writeObject(this.versionTag, out);
    }

    @Override
    protected short computeCompressedShort(short s) {
        s = super.computeCompressedShort(s);
        if (this.filterInfo != null) {
            s = (short)(s | 0x400);
        }
        return s;
    }

    @Override
    public EventID getEventID() {
        return this.eventId;
    }

    EntryEventImpl createListenerEvent(EntryEventImpl sourceEvent, PartitionedRegion r, InternalDistributedMember member) {
        EntryEventImpl e2;
        if (this.notificationOnly && this.bridgeContext == null) {
            e2 = sourceEvent;
        } else {
            e2 = new EntryEventImpl(sourceEvent);
            if (this.bridgeContext != null) {
                e2.setContext(this.bridgeContext);
            }
        }
        e2.setRegion(r);
        e2.setOriginRemote(true);
        e2.setInvokePRCallbacks(!this.notificationOnly);
        if (this.filterInfo != null) {
            e2.setLocalFilterInfo(this.filterInfo.getFilterInfo(member));
        }
        if (this.versionTag != null) {
            this.versionTag.replaceNullIDs(this.getSender());
            e2.setVersionTag(this.versionTag);
        }
        return e2;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; key=").append(this.getKey());
        if (this.originalSender != null) {
            buff.append("; originalSender=").append(this.originalSender);
        }
        if (this.bridgeContext != null) {
            buff.append("; bridgeContext=").append(this.bridgeContext);
        }
        if (this.eventId != null) {
            buff.append("; eventId=").append(this.eventId);
        }
        if (this.versionTag != null) {
            buff.append("; version=").append(this.versionTag);
        }
        if (this.filterInfo != null) {
            buff.append("; ").append(this.filterInfo);
        }
    }

    protected Object getKey() {
        return this.key;
    }

    private void setKey(Object key) {
        this.key = key;
    }

    public Operation getOperation() {
        return this.op;
    }

    protected Object getCallbackArg() {
        return this.cbArg;
    }

    @Override
    public void setFilterInfo(FilterRoutingInfo filterInfo) {
        if (filterInfo != null) {
            this.filterInfo = filterInfo;
        }
    }

    @Override
    protected boolean mayNotifySerialGatewaySender(ClusterDistributionManager dm) {
        return this.notifiesSerialGatewaySender(dm);
    }

    public static class DestroyResponse
    extends PartitionMessage.PartitionResponse {
        VersionTag versionTag;

        DestroyResponse(InternalDistributedSystem ds, Set recipients, Object key) {
            super(ds, recipients, false);
        }

        void setResponse(VersionTag versionTag) {
            this.versionTag = versionTag;
        }

        public VersionTag getVersionTag() {
            return this.versionTag;
        }
    }

    public static class DestroyReplyMessage
    extends ReplyMessage {
        private VersionTag versionTag;

        public DestroyReplyMessage() {
        }

        static void send(InternalDistributedMember recipient, ReplySender dm, int procId, VersionTag versionTag, boolean internal) {
            Assert.assertTrue(recipient != null, "DestroyReplyMessage NULL recipient");
            DestroyReplyMessage m = new DestroyReplyMessage(recipient, procId, versionTag);
            m.internal = internal;
            dm.putOutgoing(m);
        }

        DestroyReplyMessage(InternalDistributedMember recipient, int procId, VersionTag versionTag) {
            this.setProcessorId(procId);
            this.setRecipient(recipient);
            this.versionTag = versionTag;
        }

        @Override
        public int getDSFID() {
            return 150;
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 rp) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "DestroyReplyMessage process invoking reply processor with processorId: {}", (Object)this.processorId);
            }
            if (rp == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "DestroyReplyMessage processor not found");
                }
                return;
            }
            if (this.versionTag != null) {
                this.versionTag.replaceNullIDs(this.getSender());
            }
            if (rp instanceof DestroyResponse) {
                DestroyResponse processor = (DestroyResponse)rp;
                if (this.versionTag != null) {
                    this.versionTag.replaceNullIDs(this.getSender());
                }
                processor.setResponse(this.versionTag);
            }
            rp.process(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} processed {} ", (Object)rp, (Object)this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            int b = this.versionTag != null ? 1 : 0;
            b = (byte)(b | (this.versionTag instanceof DiskVersionTag ? 2 : 0));
            out.writeByte(b);
            if (this.versionTag != null) {
                InternalDataSerializer.invokeToData(this.versionTag, out);
            }
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            boolean persistentTag;
            super.fromData(in, context);
            byte b = in.readByte();
            boolean hasTag = (b & 1) != 0;
            boolean bl = persistentTag = (b & 2) != 0;
            if (hasTag) {
                this.versionTag = VersionTag.create(persistentTag, in);
            }
        }

        @Override
        public String toString() {
            StringBuilder sb = super.getStringBuilder();
            if (this.versionTag != null) {
                sb.append(" version=").append(this.versionTag);
            }
            sb.append(" from ");
            sb.append(this.getSender());
            ReplyException ex = this.getException();
            if (ex != null) {
                sb.append(" with exception ");
                sb.append(ex);
            }
            return sb.toString();
        }

        @Override
        public boolean getInlineProcess() {
            return true;
        }
    }
}

