/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.TreeSet;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.DistTXCommitMessage;
import org.apache.geode.internal.cache.DistTXCoordinatorInterface;
import org.apache.geode.internal.cache.DistTXPrecommitMessage;
import org.apache.geode.internal.cache.DistTXRollbackMessage;
import org.apache.geode.internal.cache.DistTXState;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionHelper;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.tx.DistTxEntryEvent;
import org.apache.geode.internal.statistics.StatisticsClock;

public class DistTXStateOnCoordinator
extends DistTXState
implements DistTXCoordinatorInterface {
    private ArrayList<DistTxEntryEvent> primaryTransactionalOperations = new ArrayList();
    private ArrayList<DistTxEntryEvent> secondaryTransactionalOperations = new ArrayList();
    private boolean preCommitResponse = false;
    private boolean rollbackResponse = false;

    public DistTXStateOnCoordinator(TXStateProxy proxy, boolean onBehalfOfRemoteStub, StatisticsClock statisticsClock) {
        super(proxy, onBehalfOfRemoteStub, statisticsClock);
    }

    @Override
    public ArrayList<DistTxEntryEvent> getPrimaryTransactionalOperations() throws UnsupportedOperationInTransactionException {
        return this.primaryTransactionalOperations;
    }

    private void addPrimaryTransactionalOperations(DistTxEntryEvent dtop) {
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXStateOnCoordinator.addPrimaryTransactionalOperations add " + dtop + " ,stub before=" + this + " ,isUpdatingTxStateDuringPreCommit=" + this.isUpdatingTxStateDuringPreCommit());
        }
        if (!this.isUpdatingTxStateDuringPreCommit()) {
            this.primaryTransactionalOperations.add(dtop);
            if (logger.isDebugEnabled()) {
                logger.debug("DistTXStateOnCoordinator.addPrimaryTransactionalOperations  add primary op = {}", (Object)dtop);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXStateOnCoordinator.addPrimaryTransactionalOperations stub after add = " + this);
        }
    }

    @Override
    public void addSecondaryTransactionalOperations(DistTxEntryEvent dtop) throws UnsupportedOperationInTransactionException {
        this.secondaryTransactionalOperations.add(dtop);
    }

    @Override
    public void precommit() {
        boolean retVal = this.applyOpsOnRedundantCopy(this.proxy.getCache().getDistributedSystem().getDistributedMember(), this.secondaryTransactionalOperations);
        if (retVal) {
            super.precommit();
        }
        this.preCommitResponse = retVal;
    }

    @Override
    public void rollback() {
        super.rollback();
        this.rollbackResponse = true;
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) {
        return this.putEntry(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed, true, false);
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed, boolean invokeCallbacks, boolean throwsConcurrentModification) {
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXStateOnCoordinator.putEntry " + event.getKeyInfo().getKey());
        }
        boolean returnValue = super.putEntry(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed, invokeCallbacks, throwsConcurrentModification);
        if (!event.getOperation().isPutAll()) {
            this.addPrimaryTransactionalOperations(new DistTxEntryEvent(event));
        }
        return returnValue;
    }

    @Override
    public boolean putEntryOnRemote(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws DataLocationException {
        if (logger.isDebugEnabled()) {
            logger.debug("DistTXStateOnCoordinator.putEntryOnRemote " + event.getKeyInfo().getKey());
        }
        boolean returnValue = super.putEntryOnRemote(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed);
        if (!event.getOperation().isPutAll()) {
            this.addPrimaryTransactionalOperations(new DistTxEntryEvent(event));
        }
        return returnValue;
    }

    @Override
    public void destroyExistingEntry(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws EntryNotFoundException {
        super.destroyExistingEntry(event, cacheWrite, expectedOldValue);
        if (!event.getOperation().isRemoveAll()) {
            this.addPrimaryTransactionalOperations(new DistTxEntryEvent(event));
        }
    }

    @Override
    public void destroyOnRemote(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws DataLocationException {
        super.destroyOnRemote(event, cacheWrite, expectedOldValue);
        if (!event.getOperation().isRemoveAll()) {
            this.addPrimaryTransactionalOperations(new DistTxEntryEvent(event));
        }
    }

    @Override
    public void invalidateExistingEntry(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        super.invalidateExistingEntry(event, invokeCallbacks, forceNewEntry);
        this.addPrimaryTransactionalOperations(new DistTxEntryEvent(event));
    }

    @Override
    public void invalidateOnRemote(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) throws DataLocationException {
        super.invalidateExistingEntry(event, invokeCallbacks, forceNewEntry);
        this.addPrimaryTransactionalOperations(new DistTxEntryEvent(event));
    }

    @Override
    public void postPutAll(DistributedPutAllOperation putallOp, VersionedObjectList successfulPuts, InternalRegion reg) {
        super.postPutAll(putallOp, successfulPuts, reg);
        EntryEventImpl event = EntryEventImpl.createPutAllEvent(putallOp, reg, Operation.PUTALL_CREATE, putallOp.getBaseEvent().getKey(), putallOp.getBaseEvent().getValue());
        event.setEventId(putallOp.getBaseEvent().getEventId());
        DistTxEntryEvent dtop = new DistTxEntryEvent(event);
        dtop.setPutAllOperation(putallOp);
        this.addPrimaryTransactionalOperations(dtop);
    }

    @Override
    public void postRemoveAll(DistributedRemoveAllOperation removeAllOp, VersionedObjectList successfulOps, InternalRegion reg) {
        super.postRemoveAll(removeAllOp, successfulOps, reg);
        EntryEventImpl event = EntryEventImpl.createRemoveAllEvent(removeAllOp, reg, removeAllOp.getBaseEvent().getKey());
        event.setEventId(removeAllOp.getBaseEvent().getEventId());
        DistTxEntryEvent dtop = new DistTxEntryEvent(event);
        dtop.setRemoveAllOperation(removeAllOp);
        this.addPrimaryTransactionalOperations(dtop);
    }

    @Override
    public boolean getPreCommitResponse() throws UnsupportedOperationInTransactionException {
        return this.preCommitResponse;
    }

    @Override
    public boolean getRollbackResponse() throws UnsupportedOperationInTransactionException {
        return this.rollbackResponse;
    }

    @Override
    public void setPrecommitMessage(DistTXPrecommitMessage precommitMsg, DistributionManager dm) throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(String.format("precommit() operation %s meant for Dist Tx is not supported", "setPrecommitMessage"));
    }

    @Override
    public void setCommitMessage(DistTXCommitMessage commitMsg, DistributionManager dm) throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(String.format("precommit() operation %s meant for Dist Tx is not supported", "setCommitMessage"));
    }

    @Override
    public void setRollbackMessage(DistTXRollbackMessage rollbackMsg, DistributionManager dm) throws UnsupportedOperationInTransactionException {
        throw new UnsupportedOperationInTransactionException(String.format("rollback() operation %s meant for Dist Tx is not supported", "setRollbackMessage"));
    }

    @Override
    public void gatherAffectedRegions(HashSet<InternalRegion> regionSet, boolean includePrimaryRegions, boolean includeRedundantRegions) throws UnsupportedOperationInTransactionException {
        if (includePrimaryRegions) {
            for (DistTxEntryEvent dtos : this.primaryTransactionalOperations) {
                regionSet.add(dtos.getRegion());
            }
        }
        if (includeRedundantRegions) {
            for (DistTxEntryEvent dtos : this.secondaryTransactionalOperations) {
                regionSet.add(dtos.getRegion());
            }
        }
    }

    @Override
    public void gatherAffectedRegionsName(TreeSet<String> sortedRegionName, boolean includePrimaryRegions, boolean includeRedundantRegions) throws UnsupportedOperationInTransactionException {
        if (includePrimaryRegions) {
            DistTXStateOnCoordinator.gatherAffectedRegions(sortedRegionName, this.primaryTransactionalOperations);
        }
        if (includeRedundantRegions) {
            DistTXStateOnCoordinator.gatherAffectedRegions(sortedRegionName, this.secondaryTransactionalOperations);
        }
    }

    public static void gatherAffectedRegions(TreeSet<String> sortedRegionName, ArrayList<DistTxEntryEvent> regionOps) {
        for (DistTxEntryEvent dtos : regionOps) {
            InternalRegion ir = dtos.getRegion();
            if (ir instanceof PartitionedRegion) {
                sortedRegionName.add(PartitionedRegionHelper.getBucketFullPath(ir.getFullPath(), dtos.getKeyInfo().getBucketId()));
                continue;
            }
            sortedRegionName.add(ir.getFullPath());
        }
    }

    @Override
    protected boolean applyIndividualOp(DistTxEntryEvent dtop) throws DataLocationException {
        boolean result = true;
        if (dtop.op.isUpdate() || dtop.op.isCreate()) {
            if (dtop.op.isPutAll()) {
                assert (dtop.getPutAllOperation() != null);
                VersionedObjectList versions = new VersionedObjectList(dtop.getPutAllOperation().putAllDataSize, true, dtop.getRegion().getConcurrencyChecksEnabled());
                this.postPutAll(dtop.getPutAllOperation(), versions, dtop.getRegion());
            } else {
                result = this.putEntry(dtop, false, false, null, false, 0L, true);
            }
        } else if (dtop.op.isDestroy()) {
            if (dtop.op.isRemoveAll()) {
                assert (dtop.getRemoveAllOperation() != null);
                VersionedObjectList versions = new VersionedObjectList(dtop.getRemoveAllOperation().removeAllDataSize, true, dtop.getRegion().getConcurrencyChecksEnabled());
                this.postRemoveAll(dtop.getRemoveAllOperation(), versions, dtop.getRegion());
            } else {
                this.destroyExistingEntry(dtop, false, null);
            }
        } else if (dtop.op.isInvalidate()) {
            this.invalidateExistingEntry(dtop, true, false);
        } else {
            logger.debug("DistTXCommitPhaseOneMessage: unsupported TX operation {}", (Object)dtop);
            assert (false);
        }
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + " ,primary txOps=" + this.primaryTransactionalOperations + " ,secondary txOps=" + this.secondaryTransactionalOperations + " ,preCommitResponse=" + this.preCommitResponse + " ,rollbackResponse=" + this.rollbackResponse;
    }

    @Override
    public boolean isCreatedOnDistTxCoordinator() {
        return true;
    }

    @Override
    public void finalCleanup() {
        this.cleanup();
    }
}

