/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.fediz.jetty9;

import java.security.Principal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import javax.servlet.ServletRequest;
import org.apache.cxf.fediz.core.config.FedizContext;
import org.apache.cxf.fediz.core.config.Protocol;
import org.apache.cxf.fediz.core.exception.ProcessingException;
import org.apache.cxf.fediz.core.processor.FedizProcessor;
import org.apache.cxf.fediz.core.processor.FedizProcessorFactory;
import org.apache.cxf.fediz.core.processor.FedizRequest;
import org.apache.cxf.fediz.core.processor.FedizResponse;
import org.apache.cxf.fediz.jetty9.FederationIdentityService;
import org.apache.cxf.fediz.jetty9.FederationUserIdentity;
import org.apache.cxf.fediz.jetty9.FederationUserPrincipal;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class FederationLoginService
extends AbstractLifeCycle
implements LoginService {
    private static final Logger LOG = Log.getLogger(FederationLoginService.class);
    protected IdentityService identityService = new FederationIdentityService();
    protected String name;

    public FederationLoginService() {
    }

    public FederationLoginService(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.isRunning()) {
            throw new IllegalStateException("Running");
        }
        this.name = name;
    }

    protected void doStart() throws Exception {
        LOG.debug("doStart", new Object[0]);
        super.doStart();
    }

    public UserIdentity login(String username, Object credentials, FedizContext config) {
        try {
            List<String> roles;
            FedizResponse wfRes;
            FedizRequest wfReq = (FedizRequest)credentials;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Process SignIn request", new Object[0]);
                LOG.debug("token=\n" + wfReq.getResponseToken(), new Object[0]);
            }
            FedizProcessor wfProc = FedizProcessorFactory.newFedizProcessor((Protocol)config.getProtocol());
            try {
                wfRes = wfProc.processRequest(wfReq, config);
            }
            catch (ProcessingException ex) {
                LOG.warn("Federation processing failed: " + ex.getMessage(), new Object[0]);
                return null;
            }
            if (wfRes.getAudience() != null) {
                List audienceURIs = config.getAudienceUris();
                boolean validAudience = false;
                for (String a : audienceURIs) {
                    if (!wfRes.getAudience().startsWith(a)) continue;
                    validAudience = true;
                    break;
                }
                if (!validAudience) {
                    LOG.warn("Token AudienceRestriction [" + wfRes.getAudience() + "] doesn't match with specified list of URIs.", new Object[0]);
                    return null;
                }
            }
            if ((roles = wfRes.getRoles()) == null || roles.isEmpty()) {
                roles = Collections.singletonList("Authenticated");
            } else if (config.isAddAuthenticatedRole()) {
                roles = new ArrayList<String>(roles);
                roles.add("Authenticated");
            }
            FederationUserPrincipal user = new FederationUserPrincipal(wfRes.getUsername(), wfRes);
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)((Object)user));
            String[] aRoles = new String[roles.size()];
            roles.toArray(aRoles);
            return this.identityService.newUserIdentity(subject, (Principal)((Object)user), aRoles);
        }
        catch (Exception ex) {
            LOG.warn((Throwable)ex);
            return null;
        }
    }

    public boolean validate(UserIdentity user) {
        try {
            FederationUserIdentity fui = (FederationUserIdentity)user;
            return fui.getExpiryDate().isAfter(Instant.now());
        }
        catch (ClassCastException ex) {
            LOG.warn("UserIdentity must be instance of FederationUserIdentity", new Object[0]);
            throw new IllegalStateException("UserIdentity must be instance of FederationUserIdentity");
        }
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService service) {
        this.identityService = service;
    }

    public void logout(UserIdentity user) {
    }

    public UserIdentity login(String username, Object credentials, ServletRequest arg2) {
        return null;
    }
}

