/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.impl.PoolImplUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPoolImplUtils {
    private static final Instant INSTANT_1 = Instant.ofEpochMilli(1L);
    private static final Instant INSTANT_0 = Instant.ofEpochMilli(0L);

    @Test
    public void testFactoryTypeNotSimple() {
        Class result = PoolImplUtils.getFactoryType(NotSimpleFactory.class);
        Assertions.assertEquals(Long.class, (Object)result);
    }

    @Test
    public void testFactoryTypeSimple() {
        Class result = PoolImplUtils.getFactoryType(SimpleFactory.class);
        Assertions.assertEquals(String.class, (Object)result);
    }

    @Test
    public void testMaxInstants() {
        Assertions.assertEquals((Object)INSTANT_1, (Object)PoolImplUtils.max((Instant)INSTANT_0, (Instant)INSTANT_1));
        Assertions.assertEquals((Object)INSTANT_1, (Object)PoolImplUtils.max((Instant)INSTANT_1, (Instant)INSTANT_0));
        Assertions.assertEquals((Object)INSTANT_1, (Object)PoolImplUtils.max((Instant)INSTANT_1, (Instant)INSTANT_1));
        Assertions.assertEquals((Object)INSTANT_0, (Object)PoolImplUtils.max((Instant)INSTANT_0, (Instant)INSTANT_0));
    }

    @Test
    public void testMinInstants() {
        Assertions.assertEquals((Object)INSTANT_0, (Object)PoolImplUtils.min((Instant)INSTANT_0, (Instant)INSTANT_1));
        Assertions.assertEquals((Object)INSTANT_0, (Object)PoolImplUtils.min((Instant)INSTANT_1, (Instant)INSTANT_0));
        Assertions.assertEquals((Object)INSTANT_1, (Object)PoolImplUtils.min((Instant)INSTANT_1, (Instant)INSTANT_1));
        Assertions.assertEquals((Object)INSTANT_0, (Object)PoolImplUtils.min((Instant)INSTANT_0, (Instant)INSTANT_0));
    }

    @Test
    public void testToChronoUnit() {
        Assertions.assertEquals((Object)ChronoUnit.NANOS, (Object)PoolImplUtils.toChronoUnit((TimeUnit)TimeUnit.NANOSECONDS));
        Assertions.assertEquals((Object)ChronoUnit.MICROS, (Object)PoolImplUtils.toChronoUnit((TimeUnit)TimeUnit.MICROSECONDS));
        Assertions.assertEquals((Object)ChronoUnit.MILLIS, (Object)PoolImplUtils.toChronoUnit((TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((Object)ChronoUnit.SECONDS, (Object)PoolImplUtils.toChronoUnit((TimeUnit)TimeUnit.SECONDS));
        Assertions.assertEquals((Object)ChronoUnit.MINUTES, (Object)PoolImplUtils.toChronoUnit((TimeUnit)TimeUnit.MINUTES));
        Assertions.assertEquals((Object)ChronoUnit.HOURS, (Object)PoolImplUtils.toChronoUnit((TimeUnit)TimeUnit.HOURS));
        Assertions.assertEquals((Object)ChronoUnit.DAYS, (Object)PoolImplUtils.toChronoUnit((TimeUnit)TimeUnit.DAYS));
    }

    @Test
    public void testToDuration() {
        Assertions.assertEquals((Object)Duration.ZERO, (Object)PoolImplUtils.toDuration((long)0L, (TimeUnit)TimeUnit.MILLISECONDS));
        Assertions.assertEquals((Object)Duration.ofMillis(1L), (Object)PoolImplUtils.toDuration((long)1L, (TimeUnit)TimeUnit.MILLISECONDS));
        for (TimeUnit tu : TimeUnit.values()) {
            Assertions.assertEquals((Object)Duration.ZERO, (Object)PoolImplUtils.toDuration((long)0L, (TimeUnit)tu));
        }
    }

    private static final class NotSimpleFactory
    extends FactoryF<Integer> {
        private NotSimpleFactory() {
        }

        public Long create() throws Exception {
            return null;
        }

        public PooledObject<Long> wrap(Long obj) {
            return null;
        }
    }

    private static final class SimpleFactory
    extends BasePooledObjectFactory<String> {
        private SimpleFactory() {
        }

        public String create() {
            return null;
        }

        public PooledObject<String> wrap(String obj) {
            return null;
        }
    }

    private static abstract class FactoryF<F>
    extends FactoryDE<Long, F> {
        private FactoryF() {
        }
    }

    private static abstract class FactoryDE<D, E>
    extends FactoryC<D> {
        private FactoryDE() {
        }
    }

    private static abstract class FactoryC<C>
    extends FactoryBA<C, String> {
        private FactoryC() {
        }
    }

    private static abstract class FactoryBA<A, B>
    extends FactoryAB<B, A> {
        private FactoryBA() {
        }
    }

    private static abstract class FactoryAB<A, B>
    extends BasePooledObjectFactory<B> {
        private FactoryAB() {
        }
    }
}

