/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.list.SetUniqueList;
import org.apache.commons.collections4.set.UnmodifiableSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SetUniqueListTest<E>
extends AbstractListTest<E> {
    boolean extraVerify = true;

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public E[] getFullNonNullElements() {
        return new Object[]{"", "One", 2, "Three", 4, 5.0, Float.valueOf(6.0f), "Seven", "Eight", "Nine", 10, (short)11, 12L, "Thirteen", "14", "15", (byte)16};
    }

    @Override
    public List<E> makeObject() {
        return new SetUniqueList(new ArrayList(), new HashSet());
    }

    @Test
    public void testAdd() {
        SetUniqueList lset = new SetUniqueList(new ArrayList(), new HashSet());
        Integer obj = 1;
        lset.add((Object)obj);
        lset.add((Object)obj);
        Assertions.assertEquals((int)1, (int)lset.size(), (String)"Duplicate element was added.");
        lset.add((Object)2);
        Assertions.assertEquals((int)2, (int)lset.size(), (String)"Unique element was not added.");
    }

    @Test
    public void testAddAll() {
        SetUniqueList lset = new SetUniqueList(new ArrayList(), new HashSet());
        lset.addAll(Arrays.asList((Object[])new Integer[]{1, 1}));
        Assertions.assertEquals((int)1, (int)lset.size(), (String)"Duplicate element was added.");
    }

    @Override
    @Test
    public void testCollectionAddAll() {
        this.resetEmpty();
        E[] elements = this.getFullElements();
        boolean r = this.getCollection().addAll(Arrays.asList(elements));
        this.getConfirmed().addAll(Arrays.asList(elements));
        this.verify();
        Assertions.assertTrue((boolean)r, (String)"Empty collection should change after addAll");
        for (Object element : elements) {
            Assertions.assertTrue((boolean)this.getCollection().contains(element), (String)"Collection should contain added element");
        }
        this.resetFull();
        int size = this.getCollection().size();
        elements = this.getOtherElements();
        r = this.getCollection().addAll(Arrays.asList(elements));
        this.getConfirmed().addAll(Arrays.asList(elements));
        this.verify();
        Assertions.assertTrue((boolean)r, (String)"Full collection should change after addAll");
        for (int i = 0; i < elements.length; ++i) {
            Assertions.assertTrue((boolean)this.getCollection().contains(elements[i]), (String)("Full collection should contain added element " + i));
        }
        Assertions.assertEquals((int)(size + elements.length), (int)this.getCollection().size(), (String)"Size should increase after addAll");
    }

    @Override
    @Test
    public void testCollectionIteratorRemove() {
        try {
            this.extraVerify = false;
            super.testCollectionIteratorRemove();
        }
        finally {
            this.extraVerify = true;
        }
    }

    @Test
    public void testCollections304() {
        LinkedList list = new LinkedList();
        SetUniqueList decoratedList = SetUniqueList.setUniqueList(list);
        String s1 = "Apple";
        String s2 = "Lemon";
        String s3 = "Orange";
        String s4 = "Strawberry";
        decoratedList.add((Object)"Apple");
        decoratedList.add((Object)"Lemon");
        decoratedList.add((Object)"Orange");
        Assertions.assertEquals((int)3, (int)decoratedList.size());
        decoratedList.set(1, (Object)"Strawberry");
        Assertions.assertEquals((int)3, (int)decoratedList.size());
        decoratedList.add(1, (Object)"Strawberry");
        Assertions.assertEquals((int)3, (int)decoratedList.size());
        decoratedList.add(1, (Object)"Lemon");
        Assertions.assertEquals((int)4, (int)decoratedList.size());
    }

    @Test
    public void testCollections307() {
        ArrayList list = new ArrayList();
        SetUniqueList uniqueList = SetUniqueList.setUniqueList(list);
        String hello = "Hello";
        String world = "World";
        uniqueList.add("Hello");
        uniqueList.add("World");
        List subList = list.subList(0, 0);
        List subUniqueList = uniqueList.subList(0, 0);
        Assertions.assertFalse((boolean)subList.contains("World"));
        Assertions.assertFalse((boolean)subUniqueList.contains("World"));
        ArrayList<String> worldList = new ArrayList<String>();
        worldList.add("World");
        Assertions.assertFalse((boolean)subList.contains("World"));
        Assertions.assertFalse((boolean)subUniqueList.contains("World"));
        list = new ArrayList();
        uniqueList = new SetUniqueList307(list, new TreeSet());
        uniqueList.add("Hello");
        uniqueList.add("World");
        subList = list.subList(0, 0);
        subUniqueList = uniqueList.subList(0, 0);
        Assertions.assertFalse((boolean)subList.contains("World"));
        Assertions.assertFalse((boolean)subUniqueList.contains("World"));
        worldList = new ArrayList();
        worldList.add("World");
        Assertions.assertFalse((boolean)subList.contains("World"));
        Assertions.assertFalse((boolean)subUniqueList.contains("World"));
    }

    @Test
    public void testCollections701() {
        SetUniqueList uniqueList = new SetUniqueList(new ArrayList(), new HashSet());
        Integer obj1 = 1;
        Integer obj2 = 2;
        uniqueList.add((Object)obj1);
        uniqueList.add((Object)obj2);
        Assertions.assertEquals((int)2, (int)uniqueList.size());
        uniqueList.add((Object)uniqueList);
        Assertions.assertEquals((int)3, (int)uniqueList.size());
        LinkedList list = new LinkedList();
        SetUniqueList decoratedList = SetUniqueList.setUniqueList(list);
        String s1 = "Apple";
        String s2 = "Lemon";
        String s3 = "Orange";
        String s4 = "Strawberry";
        decoratedList.add((Object)"Apple");
        decoratedList.add((Object)"Lemon");
        decoratedList.add((Object)"Orange");
        Assertions.assertEquals((int)3, (int)decoratedList.size());
        decoratedList.set(1, (Object)"Strawberry");
        Assertions.assertEquals((int)3, (int)decoratedList.size());
        decoratedList.add((Object)decoratedList);
        Assertions.assertEquals((int)4, (int)decoratedList.size());
    }

    @Test
    public void testCreateSetBasedOnList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("One");
        list.add("Two");
        SetUniqueList setUniqueList = (SetUniqueList)this.makeObject();
        Set setBasedOnList = setUniqueList.createSetBasedOnList(new HashSet(), list);
        Assertions.assertEquals((int)list.size(), (int)setBasedOnList.size());
        list.forEach(item -> Assertions.assertTrue((boolean)setBasedOnList.contains(item)));
        Set setBasedOnList1 = setUniqueList.createSetBasedOnList(new TreeSet(), list);
        Assertions.assertEquals((int)list.size(), (int)setBasedOnList1.size());
        list.forEach(item -> Assertions.assertTrue((boolean)setBasedOnList1.contains(item)));
        Set setBasedOnList2 = setUniqueList.createSetBasedOnList(UnmodifiableSet.unmodifiableSet(new HashSet()), list);
        Assertions.assertEquals((int)list.size(), (int)setBasedOnList2.size());
        list.forEach(item -> Assertions.assertTrue((boolean)setBasedOnList2.contains(item)));
        Assertions.assertThrows(NullPointerException.class, () -> setUniqueList.createSetBasedOnList(null, list));
        Assertions.assertThrows(NullPointerException.class, () -> setUniqueList.createSetBasedOnList(new HashSet(), null));
    }

    @Test
    public void testFactory() {
        Integer[] array = new Integer[]{1, 2, 1};
        ArrayList<Integer> list = new ArrayList<Integer>(Arrays.asList(array));
        SetUniqueList lset = SetUniqueList.setUniqueList(list);
        Assertions.assertEquals((int)2, (int)lset.size(), (String)"Duplicate element was added.");
        Assertions.assertEquals((Integer)1, (Integer)((Integer)lset.get(0)));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)lset.get(1)));
        Assertions.assertEquals((Integer)1, (Integer)list.get(0));
        Assertions.assertEquals((Integer)2, (Integer)list.get(1));
    }

    @Test
    public void testIntCollectionAddAll() {
        SetUniqueList list = new SetUniqueList(new ArrayList(), new HashSet());
        Integer existingElement = 1;
        list.add(existingElement);
        Integer firstNewElement = 2;
        Integer secondNewElement = 3;
        List<Integer> collection = Arrays.asList(firstNewElement, secondNewElement);
        list.addAll(0, collection);
        Assertions.assertEquals((int)3, (int)list.size(), (String)"Unique elements should be added.");
        Assertions.assertEquals((Integer)firstNewElement, (Integer)((Integer)list.get(0)), (String)"First new element should be at index 0");
        Assertions.assertEquals((Integer)secondNewElement, (Integer)((Integer)list.get(1)), (String)"Second new element should be at index 1");
        Assertions.assertEquals((Integer)existingElement, (Integer)((Integer)list.get(2)), (String)"Existing element should shift to index 2");
        Integer thirdNewElement = 4;
        collection = Arrays.asList(existingElement, thirdNewElement);
        list.addAll(0, collection);
        Assertions.assertEquals((int)4, (int)list.size(), (String)"Duplicate element should not be added, unique element should be added.");
        Assertions.assertEquals((Integer)thirdNewElement, (Integer)((Integer)list.get(0)), (String)"Third new element should be at index 0");
    }

    @Test
    public void testListIterator() {
        SetUniqueList lset = new SetUniqueList(new ArrayList(), new HashSet());
        Integer obj1 = 1;
        Integer obj2 = 2;
        lset.add((Object)obj1);
        lset.add((Object)obj2);
        ListIterator it = lset.listIterator();
        while (it.hasNext()) {
            it.next();
            if (it.hasNext()) continue;
            it.add(obj1);
            break;
        }
        Assertions.assertEquals((int)2, (int)lset.size(), (String)"Duplicate element was added");
    }

    @Override
    @Test
    public void testListIteratorAdd() {
        this.resetEmpty();
        Collection list1 = this.getCollection();
        Collection list2 = this.getConfirmed();
        E[] elements = this.getOtherElements();
        ListIterator iter1 = list1.listIterator();
        ListIterator iter2 = list2.listIterator();
        for (Object element : elements) {
            iter1.add(element);
            iter2.add(element);
            super.verify();
        }
        this.resetFull();
        iter1 = this.getCollection().listIterator();
        iter2 = this.getConfirmed().listIterator();
        for (Object element : elements) {
            iter1.next();
            iter2.next();
            iter1.add(element);
            iter2.add(element);
            super.verify();
        }
    }

    @Override
    @Test
    public void testListIteratorSet() {
        this.resetFull();
        ListIterator it = this.getCollection().listIterator();
        it.next();
        Assertions.assertThrows(UnsupportedOperationException.class, () -> it.set(null));
    }

    @Override
    @Test
    public void testListSetByIndex() {
        this.resetFull();
        int size = this.getCollection().size();
        this.getCollection().set(0, 1000L);
        Assertions.assertEquals((int)size, (int)this.getCollection().size());
        this.getCollection().set(2, 1000L);
        Assertions.assertEquals((int)(size - 1), (int)this.getCollection().size());
        Assertions.assertEquals((Object)1000L, this.getCollection().get(1));
    }

    @Test
    public void testRetainAll() {
        ArrayList list = new ArrayList(10);
        SetUniqueList uniqueList = SetUniqueList.setUniqueList(list);
        for (int i = 0; i < 10; ++i) {
            uniqueList.add((Object)i);
        }
        ArrayList<Integer> retained = new ArrayList<Integer>(5);
        for (int i = 0; i < 5; ++i) {
            retained.add(i * 2);
        }
        Assertions.assertTrue((boolean)uniqueList.retainAll(retained));
        Assertions.assertEquals((int)5, (int)uniqueList.size());
        Assertions.assertTrue((boolean)uniqueList.contains((Object)0));
        Assertions.assertTrue((boolean)uniqueList.contains((Object)2));
        Assertions.assertTrue((boolean)uniqueList.contains((Object)4));
        Assertions.assertTrue((boolean)uniqueList.contains((Object)6));
        Assertions.assertTrue((boolean)uniqueList.contains((Object)8));
    }

    @Test
    public void testRetainAllWithInitialList() {
        ArrayList<Integer> list = new ArrayList<Integer>(10);
        for (int i = 0; i < 5; ++i) {
            list.add(i);
        }
        SetUniqueList uniqueList = SetUniqueList.setUniqueList(list);
        for (int i = 5; i < 10; ++i) {
            uniqueList.add((Object)i);
        }
        ArrayList<Integer> retained = new ArrayList<Integer>(5);
        for (int i = 0; i < 5; ++i) {
            retained.add(i * 2);
        }
        Assertions.assertTrue((boolean)uniqueList.retainAll(retained));
        Assertions.assertEquals((int)5, (int)uniqueList.size());
        Assertions.assertTrue((boolean)uniqueList.contains((Object)0));
        Assertions.assertTrue((boolean)uniqueList.contains((Object)2));
        Assertions.assertTrue((boolean)uniqueList.contains((Object)4));
        Assertions.assertTrue((boolean)uniqueList.contains((Object)6));
        Assertions.assertTrue((boolean)uniqueList.contains((Object)8));
    }

    @Test
    public void testSet() {
        SetUniqueList lset = new SetUniqueList(new ArrayList(), new HashSet());
        Integer obj1 = 1;
        Integer obj2 = 2;
        Integer obj3 = 3;
        lset.add((Object)obj1);
        lset.add((Object)obj2);
        lset.set(0, (Object)obj1);
        Assertions.assertEquals((int)2, (int)lset.size());
        Assertions.assertSame((Object)obj1, (Object)lset.get(0));
        Assertions.assertSame((Object)obj2, (Object)lset.get(1));
        lset.clear();
        lset.add((Object)obj1);
        lset.add((Object)obj2);
        lset.set(0, (Object)obj2);
        Assertions.assertEquals((int)1, (int)lset.size());
        Assertions.assertSame((Object)obj2, (Object)lset.get(0));
        lset.clear();
        lset.add((Object)obj1);
        lset.add((Object)obj2);
        lset.set(0, (Object)obj3);
        Assertions.assertEquals((int)2, (int)lset.size());
        Assertions.assertSame((Object)obj3, (Object)lset.get(0));
        Assertions.assertSame((Object)obj2, (Object)lset.get(1));
        lset.clear();
        lset.add((Object)obj1);
        lset.add((Object)obj2);
        lset.set(1, (Object)obj1);
        Assertions.assertEquals((int)1, (int)lset.size());
        Assertions.assertSame((Object)obj1, (Object)lset.get(0));
    }

    @Test
    public void testSetCollections444() {
        SetUniqueList lset = new SetUniqueList(new ArrayList(), new HashSet());
        Integer obj1 = 1;
        Integer obj2 = 2;
        lset.add((Object)obj1);
        lset.add((Object)obj2);
        lset.set(0, (Object)obj1);
        Assertions.assertEquals((int)2, (int)lset.size());
        Assertions.assertSame((Object)obj1, (Object)lset.get(0));
        Assertions.assertSame((Object)obj2, (Object)lset.get(1));
        Assertions.assertTrue((boolean)lset.contains((Object)obj1));
        Assertions.assertTrue((boolean)lset.contains((Object)obj2));
    }

    @Test
    public void testSetDownwardsInList() {
        ArrayList l = new ArrayList();
        HashSet s = new HashSet();
        SetUniqueList ul = new SetUniqueList(l, s);
        Object a = new Object();
        Object b = new Object();
        ul.add(a);
        ul.add(b);
        Assertions.assertEquals((Object)a, l.get(0));
        Assertions.assertEquals((Object)b, l.get(1));
        Assertions.assertTrue((boolean)s.contains(a));
        Assertions.assertTrue((boolean)s.contains(b));
        Assertions.assertEquals((Object)a, (Object)ul.set(0, b));
        Assertions.assertEquals((int)1, (int)s.size());
        Assertions.assertEquals((int)1, (int)l.size());
        Assertions.assertEquals((Object)b, l.get(0));
        Assertions.assertTrue((boolean)s.contains(b));
        Assertions.assertFalse((boolean)s.contains(a));
    }

    @Test
    public void testSetInBiggerList() {
        ArrayList l = new ArrayList();
        HashSet s = new HashSet();
        SetUniqueList ul = new SetUniqueList(l, s);
        Object a = new Object();
        Object b = new Object();
        Object c = new Object();
        ul.add(a);
        ul.add(b);
        ul.add(c);
        Assertions.assertEquals((Object)a, l.get(0));
        Assertions.assertEquals((Object)b, l.get(1));
        Assertions.assertEquals((Object)c, l.get(2));
        Assertions.assertTrue((boolean)s.contains(a));
        Assertions.assertTrue((boolean)s.contains(b));
        Assertions.assertTrue((boolean)s.contains(c));
        Assertions.assertEquals((Object)a, (Object)ul.set(0, b));
        Assertions.assertEquals((int)2, (int)s.size());
        Assertions.assertEquals((int)2, (int)l.size());
        Assertions.assertEquals((Object)b, l.get(0));
        Assertions.assertEquals((Object)c, l.get(1));
        Assertions.assertFalse((boolean)s.contains(a));
        Assertions.assertTrue((boolean)s.contains(b));
        Assertions.assertTrue((boolean)s.contains(c));
    }

    @Test
    public void testSetUpwardsInList() {
        ArrayList l = new ArrayList();
        HashSet s = new HashSet();
        SetUniqueList ul = new SetUniqueList(l, s);
        String a = "A";
        String b = "B";
        String c = "C";
        ul.add((Object)a);
        ul.add((Object)b);
        ul.add((Object)c);
        Assertions.assertEquals((Object)a, l.get(0));
        Assertions.assertEquals((Object)b, l.get(1));
        Assertions.assertEquals((Object)c, l.get(2));
        Assertions.assertTrue((boolean)s.contains(a));
        Assertions.assertTrue((boolean)s.contains(b));
        Assertions.assertTrue((boolean)s.contains(c));
        Assertions.assertEquals((Object)b, (Object)ul.set(1, (Object)a));
        Assertions.assertEquals((int)2, (int)s.size());
        Assertions.assertEquals((int)2, (int)l.size());
        Assertions.assertEquals((Object)a, l.get(0));
        Assertions.assertEquals((Object)c, l.get(1));
        Assertions.assertTrue((boolean)s.contains(a));
        Assertions.assertFalse((boolean)s.contains(b));
        Assertions.assertTrue((boolean)s.contains(c));
    }

    @Test
    public void testSubListIsUnmodifiable() {
        this.resetFull();
        List subList = this.getCollection().subList(1, 3);
        Assertions.assertEquals((int)2, (int)subList.size());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> subList.remove(0));
    }

    @Test
    public void testUniqueListDoubleInsert() {
        SetUniqueList l = SetUniqueList.setUniqueList(new LinkedList());
        l.add(new Object());
        l.add(new Object());
        l.set(0, l.get(1));
        Assertions.assertEquals((int)1, (int)l.size());
        l.add(1, l.get(0));
        Assertions.assertEquals((int)1, (int)l.size());
    }

    @Test
    public void testUniqueListReInsert() {
        SetUniqueList l = SetUniqueList.setUniqueList(new LinkedList());
        l.add(new Object());
        l.add(new Object());
        Object a = l.get(0);
        l.set(0, l.get(1));
        Assertions.assertEquals((int)1, (int)l.size());
        l.add(1, a);
        Assertions.assertEquals((int)2, (int)l.size());
    }

    @Override
    public void verify() {
        super.verify();
        if (this.extraVerify) {
            int size = this.getCollection().size();
            this.getCollection().add(1000L);
            Assertions.assertEquals((int)(size + 1), (int)this.getCollection().size());
            this.getCollection().add(1000L);
            Assertions.assertEquals((int)(size + 1), (int)this.getCollection().size());
            Assertions.assertEquals((Object)1000L, this.getCollection().get(size));
            this.getCollection().remove(size);
        }
    }

    final class SetUniqueList307
    extends SetUniqueList<E> {
        private static final long serialVersionUID = 1415013031022962158L;

        SetUniqueList307(List<E> list, Set<E> set) {
            super(list, set);
        }
    }
}

