/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.awt.Color;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils2.converters.AbstractConverter;

public class ColorConverter
extends AbstractConverter<Color> {
    private static final String HEX_COLOR_PREFIX = "#";
    private static final Pattern JAVA_COLOR_PATTERN = Pattern.compile("^(?:[A-Za-z\\d._]+)??\\[?(?:r=)?(\\d{1,3}),(?:g=)?(\\d{1,3}),(?:b=)?(\\d{1,3})\\]?$");

    public ColorConverter() {
    }

    public ColorConverter(Color defaultValue) {
        super(defaultValue);
    }

    @Override
    protected <T> T convertToType(Class<T> type, Object value) throws Throwable {
        if (Color.class.isAssignableFrom(type)) {
            String stringValue = ColorConverter.toString(value);
            switch (ColorConverter.toLowerCase(stringValue)) {
                case "black": {
                    return type.cast(Color.BLACK);
                }
                case "blue": {
                    return type.cast(Color.BLUE);
                }
                case "cyan": {
                    return type.cast(Color.CYAN);
                }
                case "darkgray": 
                case "darkgrey": 
                case "dark_gray": 
                case "dark_grey": {
                    return type.cast(Color.DARK_GRAY);
                }
                case "gray": 
                case "grey": {
                    return type.cast(Color.GRAY);
                }
                case "green": {
                    return type.cast(Color.GREEN);
                }
                case "lightgray": 
                case "lightgrey": 
                case "light_gray": 
                case "light_grey": {
                    return type.cast(Color.LIGHT_GRAY);
                }
                case "magenta": {
                    return type.cast(Color.MAGENTA);
                }
                case "orange": {
                    return type.cast(Color.ORANGE);
                }
                case "pink": {
                    return type.cast(Color.PINK);
                }
                case "red": {
                    return type.cast(Color.RED);
                }
                case "white": {
                    return type.cast(Color.WHITE);
                }
                case "yellow": {
                    return type.cast(Color.YELLOW);
                }
            }
            if (stringValue.startsWith(HEX_COLOR_PREFIX)) {
                return type.cast(this.parseHexadecimalColor(stringValue));
            }
            if (stringValue.contains(",")) {
                return type.cast(this.parseToStringColor(stringValue));
            }
            return type.cast(Color.decode(stringValue));
        }
        throw this.conversionException(type, value);
    }

    @Override
    protected Class<Color> getDefaultType() {
        return Color.class;
    }

    private Color parseHexadecimalColor(String value) {
        Objects.requireNonNull(value);
        switch (value.length()) {
            case 4: {
                return new Color(Integer.parseInt(value.substring(1, 2), 16) * 17, Integer.parseInt(value.substring(2, 3), 16) * 17, Integer.parseInt(value.substring(3, 4), 16) * 17);
            }
            case 5: {
                return new Color(Integer.parseInt(value.substring(1, 2), 16) * 17, Integer.parseInt(value.substring(2, 3), 16) * 17, Integer.parseInt(value.substring(3, 4), 16) * 17, Integer.parseInt(value.substring(4, 5), 16) * 17);
            }
            case 7: {
                return new Color(Integer.parseInt(value.substring(1, 3), 16), Integer.parseInt(value.substring(3, 5), 16), Integer.parseInt(value.substring(5, 7), 16));
            }
            case 9: {
                return new Color(Integer.parseInt(value.substring(1, 3), 16), Integer.parseInt(value.substring(3, 5), 16), Integer.parseInt(value.substring(5, 7), 16), Integer.parseInt(value.substring(7, 9), 16));
            }
        }
        throw new IllegalArgumentException("Value is an malformed hexadecimal color, if literal value decoding is required, prefix with 0x instead of #, otherwise expecting 3, 4, 6, or 8 characters only.");
    }

    private Color parseToStringColor(String value) {
        Objects.requireNonNull(value);
        Matcher matcher = JAVA_COLOR_PATTERN.matcher(value);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid Color String provided. Could not parse.");
        }
        int red = Integer.parseInt(matcher.group(1));
        int green = Integer.parseInt(matcher.group(2));
        int blue = Integer.parseInt(matcher.group(3));
        if (red > 255 || green > 255 || blue > 255) {
            throw new IllegalArgumentException("Color component integers must be between 0 and 255.");
        }
        return new Color(red, green, blue);
    }
}

