/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils2.BasicDynaClass;
import org.apache.commons.beanutils2.DynaBean;
import org.apache.commons.beanutils2.DynaClass;
import org.apache.commons.beanutils2.DynaProperty;
import org.apache.commons.beanutils2.PropertyUtils;
import org.apache.commons.beanutils2.TestBean;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DynaPropertyUtilsTest {
    protected DynaBean bean;
    protected String[] describes = new String[]{"booleanProperty", "booleanSecond", "doubleProperty", "floatProperty", "intArray", "intIndexed", "intProperty", "listIndexed", "longProperty", "mappedObjects", "mappedProperty", "mappedIntProperty", "nested", "nullProperty", "shortProperty", "stringArray", "stringIndexed", "stringProperty"};
    protected TestBean nested;

    protected DynaClass createDynaClass() {
        int[] intArray = new int[]{};
        String[] stringArray = new String[]{};
        return new BasicDynaClass("TestDynaClass", null, new DynaProperty[]{new DynaProperty("booleanProperty", Boolean.TYPE), new DynaProperty("booleanSecond", Boolean.TYPE), new DynaProperty("doubleProperty", Double.TYPE), new DynaProperty("dupProperty", stringArray.getClass()), new DynaProperty("floatProperty", Float.TYPE), new DynaProperty("intArray", intArray.getClass()), new DynaProperty("intIndexed", intArray.getClass()), new DynaProperty("intProperty", Integer.TYPE), new DynaProperty("listIndexed", List.class), new DynaProperty("longProperty", Long.TYPE), new DynaProperty("mapProperty", Map.class), new DynaProperty("mappedObjects", Map.class), new DynaProperty("mappedProperty", Map.class), new DynaProperty("mappedIntProperty", Map.class), new DynaProperty("nested", TestBean.class), new DynaProperty("nullProperty", String.class), new DynaProperty("shortProperty", Short.TYPE), new DynaProperty("stringArray", stringArray.getClass()), new DynaProperty("stringIndexed", stringArray.getClass()), new DynaProperty("stringProperty", String.class)});
    }

    @BeforeEach
    public void setUp() throws Exception {
        DynaClass dynaClass = this.createDynaClass();
        this.bean = dynaClass.newInstance();
        this.bean.set("booleanProperty", (Object)true);
        this.bean.set("booleanSecond", (Object)true);
        this.bean.set("doubleProperty", (Object)321.0);
        this.bean.set("floatProperty", (Object)Float.valueOf(123.0f));
        int[] intArray = new int[]{0, 10, 20, 30, 40};
        this.bean.set("intArray", (Object)intArray);
        int[] intIndexed = new int[]{0, 10, 20, 30, 40};
        this.bean.set("intIndexed", (Object)intIndexed);
        this.bean.set("intProperty", (Object)123);
        ArrayList<String> listIndexed = new ArrayList<String>();
        listIndexed.add("String 0");
        listIndexed.add("String 1");
        listIndexed.add("String 2");
        listIndexed.add("String 3");
        listIndexed.add("String 4");
        this.bean.set("listIndexed", listIndexed);
        this.bean.set("longProperty", (Object)321L);
        HashMap<String, String> mapProperty = new HashMap<String, String>();
        mapProperty.put("First Key", "First Value");
        mapProperty.put("Second Key", "Second Value");
        this.bean.set("mapProperty", mapProperty);
        HashMap<String, String> mappedObjects = new HashMap<String, String>();
        mappedObjects.put("First Key", "First Value");
        mappedObjects.put("Second Key", "Second Value");
        this.bean.set("mappedObjects", mappedObjects);
        HashMap<String, String> mappedProperty = new HashMap<String, String>();
        mappedProperty.put("First Key", "First Value");
        mappedProperty.put("Second Key", "Second Value");
        this.bean.set("mappedProperty", mappedProperty);
        HashMap<String, Integer> mappedIntProperty = new HashMap<String, Integer>();
        mappedIntProperty.put("One", 1);
        mappedIntProperty.put("Two", 2);
        this.bean.set("mappedIntProperty", mappedIntProperty);
        this.nested = new TestBean();
        this.bean.set("nested", (Object)this.nested);
        this.bean.set("shortProperty", (Object)987);
        String[] stringArray = new String[]{"String 0", "String 1", "String 2", "String 3", "String 4"};
        this.bean.set("stringArray", (Object)stringArray);
        String[] stringIndexed = new String[]{"String 0", "String 1", "String 2", "String 3", "String 4"};
        this.bean.set("stringIndexed", (Object)stringIndexed);
        this.bean.set("stringProperty", (Object)"This is a string");
    }

    @AfterEach
    public void tearDown() {
        this.bean = null;
        this.nested = null;
    }

    @Test
    public void testCopyPropertiesMap() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("booleanProperty", Boolean.FALSE);
        map.put("doubleProperty", 333.0);
        map.put("dupProperty", new String[]{"New 0", "New 1", "New 2"});
        map.put("floatProperty", Float.valueOf(222.0f));
        map.put("intArray", new int[]{0, 100, 200});
        map.put("intProperty", 111);
        map.put("longProperty", 444L);
        map.put("shortProperty", (short)555);
        map.put("stringProperty", "New String Property");
        PropertyUtils.copyProperties((Object)this.bean, map);
        Assertions.assertEquals((Object)false, (Object)((Boolean)this.bean.get("booleanProperty")), (String)"booleanProperty");
        Assertions.assertEquals((double)333.0, (double)((Double)this.bean.get("doubleProperty")), (double)0.005, (String)"doubleProperty");
        Assertions.assertEquals((float)222.0f, (float)((Float)this.bean.get("floatProperty")).floatValue(), (float)0.005f, (String)"floatProperty");
        Assertions.assertEquals((int)111, (int)((Integer)this.bean.get("intProperty")), (String)"intProperty");
        Assertions.assertEquals((long)444L, (long)((Long)this.bean.get("longProperty")), (String)"longProperty");
        Assertions.assertEquals((short)555, (short)((Short)this.bean.get("shortProperty")), (String)"shortProperty");
        Assertions.assertEquals((Object)"New String Property", (Object)((String)this.bean.get("stringProperty")), (String)"stringProperty");
        String[] dupProperty = (String[])this.bean.get("dupProperty");
        Assertions.assertNotNull((Object)dupProperty, (String)"dupProperty present");
        Assertions.assertEquals((int)3, (int)dupProperty.length, (String)"dupProperty length");
        Assertions.assertEquals((Object)"New 0", (Object)dupProperty[0], (String)"dupProperty[0]");
        Assertions.assertEquals((Object)"New 1", (Object)dupProperty[1], (String)"dupProperty[1]");
        Assertions.assertEquals((Object)"New 2", (Object)dupProperty[2], (String)"dupProperty[2]");
        int[] intArray = (int[])this.bean.get("intArray");
        Assertions.assertNotNull((Object)intArray, (String)"intArray present");
        Assertions.assertEquals((int)3, (int)intArray.length, (String)"intArray length");
        Assertions.assertEquals((int)0, (int)intArray[0], (String)"intArray[0]");
        Assertions.assertEquals((int)100, (int)intArray[1], (String)"intArray[1]");
        Assertions.assertEquals((int)200, (int)intArray[2], (String)"intArray[2]");
    }

    @Test
    public void testDescribe() throws Exception {
        Map map = PropertyUtils.describe((Object)this.bean);
        for (String describe : this.describes) {
            Assertions.assertTrue((boolean)map.containsKey(describe), (String)("Property '" + describe + "' is present"));
        }
        Assertions.assertFalse((boolean)map.containsKey("writeOnlyProperty"), (String)"Property 'writeOnlyProperty' is not present");
        Assertions.assertEquals((Object)Boolean.TRUE, map.get("booleanProperty"), (String)"Value of 'booleanProperty'");
        Assertions.assertEquals((Object)321.0, map.get("doubleProperty"), (String)"Value of 'doubleProperty'");
        Assertions.assertEquals((Object)Float.valueOf(123.0f), map.get("floatProperty"), (String)"Value of 'floatProperty'");
        Assertions.assertEquals((Object)123, map.get("intProperty"), (String)"Value of 'intProperty'");
        Assertions.assertEquals((Object)321L, map.get("longProperty"), (String)"Value of 'longProperty'");
        Assertions.assertEquals((Object)987, map.get("shortProperty"), (String)"Value of 'shortProperty'");
        Assertions.assertEquals((Object)"This is a string", (Object)((String)map.get("stringProperty")), (String)"Value of 'stringProperty'");
    }

    @Test
    public void testGetIndexedArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getIndexedProperty(null, (String)"intArray", (int)0));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, null, (int)0));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getIndexedProperty(null, (String)"intArray[0]"));
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"[0]"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray"));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getIndexedProperty(null, (String)"intIndexed", (int)0));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, null, (int)0));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getIndexedProperty(null, (String)"intIndexed[0]"));
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"[0]"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed"));
    }

    @Test
    public void testGetIndexedValues() throws Exception {
        int i;
        Object value = null;
        for (i = 0; i < 5; ++i) {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray", (int)i);
            Assertions.assertNotNull((Object)value, (String)("intArray returned value " + i));
            Assertions.assertInstanceOf(Integer.class, (Object)value, (String)("intArray returned Integer " + i));
            Assertions.assertEquals((int)(i * 10), (int)((Integer)value), (String)("intArray returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)i);
            Assertions.assertNotNull((Object)value, (String)("intIndexed returned value " + i));
            Assertions.assertInstanceOf(Integer.class, (Object)value, (String)("intIndexed returned Integer " + i));
            Assertions.assertEquals((int)(i * 10), (int)((Integer)value), (String)("intIndexed returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed", (int)i);
            Assertions.assertNotNull((Object)value, (String)("listIndexed returned value " + i));
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("list returned String " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)((String)value), (String)("listIndexed returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)i);
            Assertions.assertNotNull((Object)value, (String)("stringArray returned value " + i));
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("stringArray returned String " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)((String)value), (String)("stringArray returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)i);
            Assertions.assertNotNull((Object)value, (String)("stringIndexed returned value " + i));
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("stringIndexed returned String " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)((String)value), (String)("stringIndexed returned correct " + i));
        }
        for (i = 0; i < 5; ++i) {
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("intArray[" + i + "]"));
            Assertions.assertNotNull((Object)value, (String)("intArray returned value " + i));
            Assertions.assertInstanceOf(Integer.class, (Object)value, (String)("intArray returned Integer " + i));
            Assertions.assertEquals((int)(i * 10), (int)((Integer)value), (String)("intArray returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("intIndexed[" + i + "]"));
            Assertions.assertNotNull((Object)value, (String)("intIndexed returned value " + i));
            Assertions.assertInstanceOf(Integer.class, (Object)value, (String)("intIndexed returned Integer " + i));
            Assertions.assertEquals((int)(i * 10), (int)((Integer)value), (String)("intIndexed returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("listIndexed[" + i + "]"));
            Assertions.assertNotNull((Object)value, (String)("listIndexed returned value " + i));
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("listIndexed returned String " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)((String)value), (String)("listIndexed returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("stringArray[" + i + "]"));
            Assertions.assertNotNull((Object)value, (String)("stringArray returned value " + i));
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("stringArray returned String " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)((String)value), (String)("stringArray returned correct " + i));
            value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)("stringIndexed[" + i + "]"));
            Assertions.assertNotNull((Object)value, (String)("stringIndexed returned value " + i));
            Assertions.assertInstanceOf(String.class, (Object)value, (String)("stringIndexed returned String " + i));
            Assertions.assertEquals((Object)("String " + i), (Object)((String)value), (String)("stringIndexed returned correct " + i));
        }
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray", (int)-1));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray", (int)5));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)-1));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)5));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed", (int)-1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed", (int)5));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)-1));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)5));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)-1));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)5));
    }

    @Test
    public void testGetMappedArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getMappedProperty(null, (String)"mappedProperty", (String)"First Key"));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getMappedProperty((Object)this.bean, null, (String)"First Key"));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", null));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getMappedProperty(null, (String)"mappedProperty(First Key)"));
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.getMappedProperty((Object)this.bean, (String)"(Second Key)"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty"));
    }

    @Test
    public void testGetMappedPeriods() throws Exception {
        this.bean.set("mappedProperty", "key.with.a.dot", (Object)"Special Value");
        Assertions.assertEquals((Object)"Special Value", (Object)((String)this.bean.get("mappedProperty", "key.with.a.dot")), (String)"Can retrieve directly");
        Assertions.assertEquals((Object)"Special Value", (Object)PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"key.with.a.dot"), (String)"Can retrieve via getMappedProperty");
        Assertions.assertEquals((Object)"Special Value", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedProperty(key.with.a.dot)"), (String)"Can retrieve via getNestedProperty");
        this.bean.set("mappedObjects", "nested.property", (Object)new TestBean());
        Assertions.assertNotNull((Object)this.bean.get("mappedObjects", "nested.property"), (String)"Can retrieve directly");
        Assertions.assertEquals((Object)"This is a string", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedObjects(nested.property).stringProperty"), (String)"Can retrieve nested");
    }

    @Test
    public void testGetMappedSlashes() throws Exception {
        this.bean.set("mappedProperty", "key/with/a/slash", (Object)"Special Value");
        Assertions.assertEquals((Object)"Special Value", (Object)this.bean.get("mappedProperty", "key/with/a/slash"), (String)"Can retrieve directly");
        Assertions.assertEquals((Object)"Special Value", (Object)PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"key/with/a/slash"), (String)"Can retrieve via getMappedProperty");
        Assertions.assertEquals((Object)"Special Value", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedProperty(key/with/a/slash)"), (String)"Can retrieve via getNestedProperty");
        this.bean.set("mappedObjects", "nested/property", (Object)new TestBean());
        Assertions.assertNotNull((Object)this.bean.get("mappedObjects", "nested/property"), (String)"Can retrieve directly");
        Assertions.assertEquals((Object)"This is a string", (Object)PropertyUtils.getNestedProperty((Object)this.bean, (String)"mappedObjects(nested/property).stringProperty"), (String)"Can retrieve nested");
    }

    @Test
    public void testGetMappedValues() throws Exception {
        Object value = null;
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"First Key");
        Assertions.assertEquals((Object)"First Value", (Object)value, (String)"Can find first value");
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Second Key");
        Assertions.assertEquals((Object)"Second Value", (Object)value, (String)"Can find second value");
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Third Key");
        Assertions.assertNull((Object)value, (String)"Can not find third value");
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(First Key)");
        Assertions.assertEquals((Object)"First Value", (Object)value, (String)"Can find first value");
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(Second Key)");
        Assertions.assertEquals((Object)"Second Value", (Object)value, (String)"Can find second value");
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(Third Key)");
        Assertions.assertNull((Object)value, (String)"Can not find third value");
        value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.First Key");
        Assertions.assertEquals((Object)"First Value", (Object)value, (String)"Can find first value");
        value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.Second Key");
        Assertions.assertEquals((Object)"Second Value", (Object)value, (String)"Can find second value");
        value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.Third Key");
        Assertions.assertNull((Object)value, (String)"Can not find third value");
    }

    @Test
    public void testGetNestedArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getNestedProperty(null, (String)"stringProperty"));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getNestedProperty((Object)this.bean, null));
    }

    @Test
    public void testGetNestedBoolean() throws Exception {
        Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.booleanProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Boolean.class, (Object)value, (String)"Got correct type");
        TestBean nested = (TestBean)this.bean.get("nested");
        Assertions.assertEquals((Object)((Boolean)value), (Object)nested.getBooleanProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetNestedDouble() throws Exception {
        Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.doubleProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Double.class, (Object)value, (String)"Got correct type");
        TestBean nested = (TestBean)this.bean.get("nested");
        Assertions.assertEquals((double)((Double)value), (double)nested.getDoubleProperty(), (double)0.005, (String)"Got correct value");
    }

    @Test
    public void testGetNestedFloat() throws Exception {
        Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.floatProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Float.class, (Object)value, (String)"Got correct type");
        TestBean nested = (TestBean)this.bean.get("nested");
        Assertions.assertEquals((float)((Float)value).floatValue(), (float)nested.getFloatProperty(), (float)0.005f, (String)"Got correct value");
    }

    @Test
    public void testGetNestedInt() throws Exception {
        Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.intProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"Got correct type");
        TestBean nested = (TestBean)this.bean.get("nested");
        Assertions.assertEquals((int)((Integer)value), (int)nested.getIntProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetNestedLong() throws Exception {
        Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.longProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Long.class, (Object)value, (String)"Got correct type");
        TestBean nested = (TestBean)this.bean.get("nested");
        Assertions.assertEquals((long)((Long)value), (long)nested.getLongProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetNestedReadOnly() throws Exception {
        Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.readOnlyProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Got correct type");
        TestBean nested = (TestBean)this.bean.get("nested");
        Assertions.assertEquals((Object)((String)value), (Object)nested.getReadOnlyProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetNestedShort() throws Exception {
        Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.shortProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Short.class, (Object)value, (String)"Got correct type");
        TestBean nested = (TestBean)this.bean.get("nested");
        Assertions.assertEquals((short)((Short)value), (short)nested.getShortProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetNestedString() throws Exception {
        Object value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.stringProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Got correct type");
        TestBean nested = (TestBean)this.bean.get("nested");
        Assertions.assertEquals((Object)((String)value), (Object)nested.getStringProperty(), (String)"Got correct value");
    }

    @Test
    public void testGetNestedUnknown() throws Exception {
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.getNestedProperty((Object)this.bean, (String)"nested.unknown"));
    }

    @Test
    public void testGetSimpleArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getSimpleProperty(null, (String)"stringProperty"));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.getSimpleProperty((Object)this.bean, null));
    }

    @Test
    public void testGetSimpleBoolean() throws Exception {
        Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"booleanProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Boolean.class, (Object)value, (String)"Got correct type");
        Assertions.assertTrue((boolean)((Boolean)value), (String)"Got correct value");
    }

    @Test
    public void testGetSimpleDouble() throws Exception {
        Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"doubleProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Double.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((double)((Double)value), (double)321.0, (double)0.005, (String)"Got correct value");
    }

    @Test
    public void testGetSimpleFloat() throws Exception {
        Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"floatProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Float.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((float)((Float)value).floatValue(), (float)123.0f, (float)0.005f, (String)"Got correct value");
    }

    @Test
    public void testGetSimpleIndexed() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.getSimpleProperty((Object)this.bean, (String)"intIndexed[0]"));
    }

    @Test
    public void testGetSimpleInt() throws Exception {
        Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"intProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((int)((Integer)value), (int)123, (String)"Got correct value");
    }

    @Test
    public void testGetSimpleLong() throws Exception {
        Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"longProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Long.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((long)((Long)value), (long)321L, (String)"Got correct value");
    }

    @Test
    public void testGetSimpleNested() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.getSimpleProperty((Object)this.bean, (String)"nested.stringProperty"));
    }

    @Test
    public void testGetSimpleShort() throws Exception {
        Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"shortProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(Short.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((short)((Short)value), (short)987, (String)"Got correct value");
    }

    @Test
    public void testGetSimpleString() throws Exception {
        Object value = PropertyUtils.getSimpleProperty((Object)this.bean, (String)"stringProperty");
        Assertions.assertNotNull((Object)value, (String)"Got a value");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Got correct type");
        Assertions.assertEquals((Object)((String)value), (Object)"This is a string", (String)"Got correct value");
    }

    @Test
    public void testGetSimpleUnknown() throws Exception {
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.getSimpleProperty((Object)this.bean, (String)"unknown"));
    }

    @Test
    public void testSetIndexedArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setIndexedProperty(null, (String)"intArray", (int)0, (Object)1));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, null, (int)0, (Object)1));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setIndexedProperty(null, (String)"intArray[0]", (Object)1));
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"[0]", (Object)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray", (Object)1));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setIndexedProperty(null, (String)"intIndexed", (int)0, (Object)1));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, null, (int)0, (Object)1));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setIndexedProperty(null, (String)"intIndexed[0]", (Object)1));
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"[0]", (Object)1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed", (Object)1));
    }

    @Test
    public void testSetIndexedValues() throws Exception {
        Object value = null;
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray", (int)0, (Object)1);
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray", (int)0);
        Assertions.assertNotNull((Object)value, (String)"Returned new value 0");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"Returned Integer new value 0");
        Assertions.assertEquals((int)1, (int)((Integer)value), (String)"Returned correct new value 0");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed", (int)1, (Object)11);
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed", (int)1);
        Assertions.assertNotNull((Object)value, (String)"Returned new value 1");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"Returned Integer new value 1");
        Assertions.assertEquals((int)11, (int)((Integer)value), (String)"Returned correct new value 1");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"listIndexed", (int)2, (Object)"New Value 2");
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed", (int)2);
        Assertions.assertNotNull((Object)value, (String)"Returned new value 2");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Returned String new value 2");
        Assertions.assertEquals((Object)"New Value 2", (Object)((String)value), (String)"Returned correct new value 2");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray", (int)2, (Object)"New Value 2");
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)2);
        Assertions.assertNotNull((Object)value, (String)"Returned new value 2");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Returned String new value 2");
        Assertions.assertEquals((Object)"New Value 2", (Object)((String)value), (String)"Returned correct new value 2");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray", (int)3, (Object)"New Value 3");
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray", (int)3);
        Assertions.assertNotNull((Object)value, (String)"Returned new value 3");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Returned String new value 3");
        Assertions.assertEquals((Object)"New Value 3", (Object)((String)value), (String)"Returned correct new value 3");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray[4]", (Object)1);
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intArray[4]");
        Assertions.assertNotNull((Object)value, (String)"Returned new value 4");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"Returned Integer new value 4");
        Assertions.assertEquals((int)1, (int)((Integer)value), (String)"Returned correct new value 4");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed[3]", (Object)11);
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"intIndexed[3]");
        Assertions.assertNotNull((Object)value, (String)"Returned new value 5");
        Assertions.assertInstanceOf(Integer.class, (Object)value, (String)"Returned Integer new value 5");
        Assertions.assertEquals((int)11, (int)((Integer)value), (String)"Returned correct new value 5");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"listIndexed[1]", (Object)"New Value 2");
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"listIndexed[1]");
        Assertions.assertNotNull((Object)value, (String)"Returned new value 6");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Returned String new value 6");
        Assertions.assertEquals((Object)"New Value 2", (Object)((String)value), (String)"Returned correct new value 6");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray[1]", (Object)"New Value 2");
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray[2]");
        Assertions.assertNotNull((Object)value, (String)"Returned new value 6");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Returned String new value 6");
        Assertions.assertEquals((Object)"New Value 2", (Object)((String)value), (String)"Returned correct new value 6");
        PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray[0]", (Object)"New Value 3");
        value = PropertyUtils.getIndexedProperty((Object)this.bean, (String)"stringArray[0]");
        Assertions.assertNotNull((Object)value, (String)"Returned new value 7");
        Assertions.assertInstanceOf(String.class, (Object)value, (String)"Returned String new value 7");
        Assertions.assertEquals((Object)"New Value 3", (Object)((String)value), (String)"Returned correct new value 7");
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray", (int)-1, (Object)0));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intArray", (int)5, (Object)0));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed", (int)-1, (Object)0));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"intIndexed", (int)5, (Object)0));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"listIndexed", (int)5, (Object)"New String"));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"listIndexed", (int)-1, (Object)"New String"));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray", (int)-1, (Object)"New String"));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringArray", (int)5, (Object)"New String"));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)-1, (Object)"New String"));
        Assertions.assertThrows(ArrayIndexOutOfBoundsException.class, () -> PropertyUtils.setIndexedProperty((Object)this.bean, (String)"stringIndexed", (int)5, (Object)"New String"));
    }

    @Test
    public void testSetMappedArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setMappedProperty(null, (String)"mappedProperty", (String)"First Key", (Object)"First Value"));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setMappedProperty((Object)this.bean, null, (String)"First Key", (Object)"First Value"));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty", null, (Object)"First Value"));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setMappedProperty(null, (String)"mappedProperty(First Key)", (Object)"First Value"));
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.setMappedProperty((Object)this.bean, (String)"(Second Key)", (Object)"Second Value"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty", (Object)"Third Value"));
    }

    @Test
    public void testSetMappedValues() throws Exception {
        Object value = null;
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Fourth Key");
        Assertions.assertNull((Object)value, (String)"Can not find fourth value");
        PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Fourth Key", (Object)"Fourth Value");
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty", (String)"Fourth Key");
        Assertions.assertEquals((Object)"Fourth Value", (Object)value, (String)"Can find fourth value");
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(Fifth Key)");
        Assertions.assertNull((Object)value, (String)"Can not find fifth value");
        PropertyUtils.setMappedProperty((Object)this.bean, (String)"mappedProperty(Fifth Key)", (Object)"Fifth Value");
        value = PropertyUtils.getMappedProperty((Object)this.bean, (String)"mappedProperty(Fifth Key)");
        Assertions.assertEquals((Object)"Fifth Value", (Object)value, (String)"Can find fifth value");
        value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.Sixth Key");
        Assertions.assertNull((Object)value, (String)"Can not find sixth value");
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"mapProperty.Sixth Key", (Object)"Sixth Value");
        value = PropertyUtils.getNestedProperty((Object)this.bean, (String)"mapProperty.Sixth Key");
        Assertions.assertEquals((Object)"Sixth Value", (Object)value, (String)"Can find sixth value");
    }

    @Test
    public void testSetNestedArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setNestedProperty(null, (String)"stringProperty", (Object)""));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setNestedProperty((Object)this.bean, null, (Object)""));
    }

    @Test
    public void testSetNestedBoolean() throws Exception {
        boolean oldValue = this.nested.getBooleanProperty();
        boolean newValue = !oldValue;
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.booleanProperty", (Object)newValue);
        Assertions.assertEquals((Object)newValue, (Object)this.nested.getBooleanProperty(), (String)"Matched new value");
    }

    @Test
    public void testSetNestedDouble() throws Exception {
        double oldValue = this.nested.getDoubleProperty();
        double newValue = oldValue + 1.0;
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.doubleProperty", (Object)newValue);
        Assertions.assertEquals((double)newValue, (double)this.nested.getDoubleProperty(), (double)0.005, (String)"Matched new value");
    }

    @Test
    public void testSetNestedFloat() throws Exception {
        float oldValue = this.nested.getFloatProperty();
        float newValue = oldValue + 1.0f;
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.floatProperty", (Object)Float.valueOf(newValue));
        Assertions.assertEquals((float)newValue, (float)this.nested.getFloatProperty(), (float)0.005f, (String)"Matched new value");
    }

    @Test
    public void testSetNestedInt() throws Exception {
        int oldValue = this.nested.getIntProperty();
        int newValue = oldValue + 1;
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.intProperty", (Object)newValue);
        Assertions.assertEquals((int)newValue, (int)this.nested.getIntProperty(), (String)"Matched new value");
    }

    @Test
    public void testSetNestedLong() throws Exception {
        long oldValue = this.nested.getLongProperty();
        long newValue = oldValue + 1L;
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.longProperty", (Object)newValue);
        Assertions.assertEquals((long)newValue, (long)this.nested.getLongProperty(), (String)"Matched new value");
    }

    @Test
    public void testSetNestedReadOnly() throws Exception {
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.readOnlyProperty", (Object)(this.nested.getWriteOnlyPropertyValue() + " Extra Value")));
    }

    @Test
    public void testSetNestedShort() throws Exception {
        short oldValue;
        short newValue = oldValue = this.nested.getShortProperty();
        newValue = (short)(newValue + 1);
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.shortProperty", (Object)newValue);
        Assertions.assertEquals((short)newValue, (short)this.nested.getShortProperty(), (String)"Matched new value");
    }

    @Test
    public void testSetNestedString() throws Exception {
        String oldValue = this.nested.getStringProperty();
        String newValue = oldValue + " Extra Value";
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.stringProperty", (Object)newValue);
        Assertions.assertEquals((Object)newValue, (Object)this.nested.getStringProperty(), (String)"Matched new value");
    }

    @Test
    public void testSetNestedUnknown() throws Exception {
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.unknown", (Object)"New String Value"));
    }

    @Test
    public void testSetNestedWriteOnly() throws Exception {
        String oldValue = this.nested.getWriteOnlyPropertyValue();
        String newValue = oldValue + " Extra Value";
        PropertyUtils.setNestedProperty((Object)this.bean, (String)"nested.writeOnlyProperty", (Object)newValue);
        Assertions.assertEquals((Object)newValue, (Object)this.nested.getWriteOnlyPropertyValue(), (String)"Matched new value");
    }

    @Test
    public void testSetSimpleArguments() {
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setSimpleProperty(null, (String)"stringProperty", (Object)""));
        Assertions.assertThrows(NullPointerException.class, () -> PropertyUtils.setSimpleProperty((Object)this.bean, null, (Object)""));
    }

    @Test
    public void testSetSimpleBoolean() throws Exception {
        boolean oldValue = (Boolean)this.bean.get("booleanProperty");
        boolean newValue = !oldValue;
        PropertyUtils.setSimpleProperty((Object)this.bean, (String)"booleanProperty", (Object)newValue);
        Assertions.assertEquals((Object)newValue, (Object)((Boolean)this.bean.get("booleanProperty")), (String)"Matched new value");
    }

    @Test
    public void testSetSimpleDouble() throws Exception {
        double oldValue = (Double)this.bean.get("doubleProperty");
        double newValue = oldValue + 1.0;
        PropertyUtils.setSimpleProperty((Object)this.bean, (String)"doubleProperty", (Object)newValue);
        Assertions.assertEquals((double)newValue, (double)((Double)this.bean.get("doubleProperty")), (double)0.005, (String)"Matched new value");
    }

    @Test
    public void testSetSimpleFloat() throws Exception {
        float oldValue = ((Float)this.bean.get("floatProperty")).floatValue();
        float newValue = oldValue + 1.0f;
        PropertyUtils.setSimpleProperty((Object)this.bean, (String)"floatProperty", (Object)Float.valueOf(newValue));
        Assertions.assertEquals((float)newValue, (float)((Float)this.bean.get("floatProperty")).floatValue(), (float)0.005f, (String)"Matched new value");
    }

    @Test
    public void testSetSimpleIndexed() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.setSimpleProperty((Object)this.bean, (String)"stringIndexed[0]", (Object)"New String Value"));
    }

    @Test
    public void testSetSimpleInt() throws Exception {
        int oldValue = (Integer)this.bean.get("intProperty");
        int newValue = oldValue + 1;
        PropertyUtils.setSimpleProperty((Object)this.bean, (String)"intProperty", (Object)newValue);
        Assertions.assertEquals((int)newValue, (int)((Integer)this.bean.get("intProperty")), (String)"Matched new value");
    }

    @Test
    public void testSetSimpleLong() throws Exception {
        long oldValue = (Long)this.bean.get("longProperty");
        long newValue = oldValue + 1L;
        PropertyUtils.setSimpleProperty((Object)this.bean, (String)"longProperty", (Object)newValue);
        Assertions.assertEquals((long)newValue, (long)((Long)this.bean.get("longProperty")), (String)"Matched new value");
    }

    @Test
    public void testSetSimpleNested() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> PropertyUtils.setSimpleProperty((Object)this.bean, (String)"nested.stringProperty", (Object)"New String Value"));
    }

    @Test
    public void testSetSimpleShort() throws Exception {
        short oldValue;
        short newValue = oldValue = ((Short)this.bean.get("shortProperty")).shortValue();
        newValue = (short)(newValue + 1);
        PropertyUtils.setSimpleProperty((Object)this.bean, (String)"shortProperty", (Object)newValue);
        Assertions.assertEquals((short)newValue, (short)((Short)this.bean.get("shortProperty")), (String)"Matched new value");
    }

    @Test
    public void testSetSimpleString() throws Exception {
        String oldValue = (String)this.bean.get("stringProperty");
        String newValue = oldValue + " Extra Value";
        PropertyUtils.setSimpleProperty((Object)this.bean, (String)"stringProperty", (Object)newValue);
        Assertions.assertEquals((Object)newValue, (Object)((String)this.bean.get("stringProperty")), (String)"Matched new value");
    }

    @Test
    public void testSetSimpleUnknown() throws Exception {
        Assertions.assertThrows(NoSuchMethodException.class, () -> PropertyUtils.setSimpleProperty((Object)this.bean, (String)"unknown", (Object)"New String Value"));
    }
}

