/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.generate.DistributionFactory;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.operations.OpDistributionFactory;
import org.apache.cassandra.stress.operations.SampledOpDistributionFactory;
import org.apache.cassandra.stress.operations.predefined.PredefinedOperation;
import org.apache.cassandra.stress.settings.Command;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionDistribution;
import org.apache.cassandra.stress.settings.OptionEnumProbabilities;
import org.apache.cassandra.stress.settings.SettingsCommand;
import org.apache.cassandra.stress.settings.SettingsCommandPreDefined;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.Timer;

public class SettingsCommandPreDefinedMixed
extends SettingsCommandPreDefined {
    private final Map<Command, Double> ratios;
    private final DistributionFactory clustering;

    public SettingsCommandPreDefinedMixed(Options options) {
        super(Command.MIXED, options);
        this.clustering = options.clustering.get();
        this.ratios = options.probabilities.ratios();
        if (this.ratios.size() == 0) {
            throw new IllegalArgumentException("Must specify at least one command with a non-zero ratio");
        }
    }

    @Override
    public OpDistributionFactory getFactory(final StressSettings settings) {
        final SeedManager seeds = new SeedManager(settings);
        return new SampledOpDistributionFactory<Command>(this.ratios, this.clustering){

            @Override
            protected List<? extends Operation> get(Timer timer, PartitionGenerator generator, Command key, boolean isWarmup) {
                return Collections.singletonList(PredefinedOperation.operation(key, timer, generator, seeds, settings, SettingsCommandPreDefinedMixed.this.add));
            }

            @Override
            protected PartitionGenerator newGenerator() {
                return SettingsCommandPreDefinedMixed.this.newGenerator(settings);
            }
        };
    }

    public static SettingsCommandPreDefinedMixed build(String[] params) {
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new Options[]{new Options(new SettingsCommand.Uncertainty()), new Options(new SettingsCommand.Count()), new Options(new SettingsCommand.Duration())});
        if (options == null) {
            SettingsCommandPreDefinedMixed.printHelp();
            System.out.println("Invalid MIXED options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsCommandPreDefinedMixed((Options)options);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "mixed", new Options(new SettingsCommand.Uncertainty()), new Options(new SettingsCommand.Count()), new Options(new SettingsCommand.Duration()));
    }

    public static Runnable helpPrinter() {
        return new Runnable(){

            @Override
            public void run() {
                SettingsCommandPreDefinedMixed.printHelp();
            }
        };
    }

    static class Options
    extends SettingsCommandPreDefined.Options {
        static List<OptionEnumProbabilities.Opt<Command>> probabilityOptions = new ArrayList<OptionEnumProbabilities.Opt<Command>>();
        final OptionDistribution clustering = new OptionDistribution("clustering=", "GAUSSIAN(1..10)", "Distribution clustering runs of operations of the same kind");
        final OptionEnumProbabilities probabilities = new OptionEnumProbabilities(probabilityOptions, "ratio", "Specify the ratios for operations to perform; e.g. (read=2,write=1) will perform 2 reads for each write");

        protected Options(SettingsCommand.Options parent) {
            super(parent);
        }

        @Override
        public List<? extends Option> options() {
            return Options.merge(Arrays.asList(this.clustering, this.probabilities), super.options());
        }

        static {
            block4: for (Command command : Command.values()) {
                String defaultValue;
                if (command.category == null) continue;
                switch (command) {
                    case MIXED: {
                        continue block4;
                    }
                    case READ: 
                    case WRITE: {
                        defaultValue = "1";
                        break;
                    }
                    default: {
                        defaultValue = null;
                    }
                }
                probabilityOptions.add(new OptionEnumProbabilities.Opt<Command>(command, defaultValue));
            }
        }
    }
}

