/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.cloud;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceDiscovery;
import org.apache.camel.com.github.benmanes.caffeine.cache.Caffeine;
import org.apache.camel.com.github.benmanes.caffeine.cache.LoadingCache;
import org.apache.camel.util.ObjectHelper;

public final class CachingServiceDiscovery
implements ServiceDiscovery {
    private final ServiceDiscovery delegate;
    private LoadingCache<String, List<ServiceDefinition>> cache;
    private long timeout;

    public CachingServiceDiscovery(ServiceDiscovery delegate) {
        this(delegate, 60000L);
    }

    public CachingServiceDiscovery(ServiceDiscovery delegate, long timeout, TimeUnit unit) {
        this(delegate, unit.toMillis(timeout));
    }

    public CachingServiceDiscovery(ServiceDiscovery delegate, long timeout) {
        this.delegate = ObjectHelper.notNull(delegate, "delegate");
        this.setTimeout(timeout);
    }

    public ServiceDiscovery getDelegate() {
        return this.delegate;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
        this.cache = Caffeine.newBuilder().expireAfterAccess(timeout, TimeUnit.MILLISECONDS).build(this.delegate::getServices);
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.setTimeout(unit.toMillis(timeout));
    }

    public long getTimeout() {
        return this.timeout;
    }

    public CachingServiceDiscovery timeout(long timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public CachingServiceDiscovery timeout(long timeout, TimeUnit unit) {
        this.setTimeout(timeout, unit);
        return this;
    }

    @Override
    public List<ServiceDefinition> getServices(String name) {
        return this.cache.get(name);
    }

    public static CachingServiceDiscovery wrap(ServiceDiscovery delegate) {
        return new CachingServiceDiscovery(delegate);
    }

    public static CachingServiceDiscovery wrap(ServiceDiscovery delegate, long timeout) {
        return new CachingServiceDiscovery(delegate).timeout(timeout);
    }

    public static CachingServiceDiscovery wrap(ServiceDiscovery delegate, long timeout, TimeUnit unit) {
        return new CachingServiceDiscovery(delegate).timeout(timeout, unit);
    }
}

