/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.model.IModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;

public class Validatable<T>
implements IValidatable<T> {
    private T value;
    private ArrayList<IValidationError> errors;
    private IModel<T> model;

    public Validatable() {
    }

    public Validatable(T value) {
        this.value = value;
    }

    public void setModel(IModel<T> model) {
        this.model = model;
    }

    public void setValue(T value) {
        this.value = value;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void error(IValidationError error) {
        if (this.errors == null) {
            this.errors = new ArrayList();
        }
        this.errors.add(error);
    }

    public List<IValidationError> getErrors() {
        if (this.errors == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.errors);
    }

    @Override
    public boolean isValid() {
        return this.errors == null;
    }

    @Override
    public IModel<T> getModel() {
        return this.model;
    }
}

