/*
* Math library
*
* Copyright (C) 2016 Intel Corporation. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
*   * Redistributions of source code must retain the above copyright
*     notice, this list of conditions and the following disclaimer.
*   * Redistributions in binary form must reproduce the above copyright
*     notice, this list of conditions and the following disclaimer in
*     the documentation and/or other materials provided with the
*     distribution.
*   * Neither the name of Intel Corporation nor the names of its
*     contributors may be used to endorse or promote products derived
*     from this software without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
* A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
* OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
* DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
* THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
*
* Author Name <jingwei.zhang@intel.com>
*   History:
*   03-14-2016 Initial version. numerics svn rev. 12864
*/
	.file "exp_table.c"
	.section .rodata, "a"
	.align 8
	.align 8
	.globl __libm_exp_hi_table_64
__libm_exp_hi_table_64:
	.long	0x667f3c00,0x3fe6a09e
	.long	0x3c651a40,0x3fe6dfb2
	.long	0xe8ec5f80,0x3fe71f75
	.long	0x56426800,0x3fe75feb
	.long	0x73eb01c0,0x3fe7a114
	.long	0x36cf4e80,0x3fe7e2f3
	.long	0x994cce20,0x3fe82589
	.long	0x9b449300,0x3fe868d9
	.long	0x422aa0e0,0x3fe8ace5
	.long	0x99157740,0x3fe8f1ae
	.long	0xb0cdc600,0x3fe93737
	.long	0x9fde4e60,0x3fe97d82
	.long	0x82a3f0a0,0x3fe9c491
	.long	0x7b5de580,0x3fea0c66
	.long	0xb23e2560,0x3fea5503
	.long	0x5579fdc0,0x3fea9e6b
	.long	0x995ad3c0,0x3feae89f
	.long	0xb84f1600,0x3feb33a2
	.long	0xf2fb5e60,0x3feb7f76
	.long	0x904bc1e0,0x3febcc1e
	.long	0xdd8552a0,0x3fec199b
	.long	0x2e57d150,0x3fec67f1
	.long	0xdcef9070,0x3fecb720
	.long	0x4a078980,0x3fed072d
	.long	0xdcfba490,0x3fed5818
	.long	0x03db3290,0x3feda9e6
	.long	0x337b9b60,0x3fedfc97
	.long	0xe78b3ff8,0x3fee502e
	.long	0xa2a490e0,0x3feea4af
	.long	0xee615a28,0x3feefa1b
	.long	0x5b6e4544,0x3fef5076
	.long	0x819e90da,0x3fefa7c1
	.long	0x00000000,0x3ff00000
	.long	0x3e778060,0x3ff02c9a
	.long	0xd3158574,0x3ff059b0
	.long	0x18759bc8,0x3ff08745
	.long	0x6cf9890c,0x3ff0b558
	.long	0x32d3d1a0,0x3ff0e3ec
	.long	0xd0125b50,0x3ff11301
	.long	0xaea92dd8,0x3ff1429a
	.long	0x3c7d5178,0x3ff172b8
	.long	0xeb6fcb70,0x3ff1a35b
	.long	0x3168b9a8,0x3ff1d487
	.long	0x88628cd0,0x3ff2063b
	.long	0x6e756230,0x3ff2387a
	.long	0x65e27cd0,0x3ff26b45
	.long	0xf51fdee0,0x3ff29e9d
	.long	0xa6e40300,0x3ff2d285
	.long	0x0a31b710,0x3ff306fe
	.long	0xb26416f0,0x3ff33c08
	.long	0x373aa9c0,0x3ff371a7
	.long	0x34e59ff0,0x3ff3a7db
	.long	0x4c123420,0x3ff3dea6
	.long	0x21f72e20,0x3ff4160a
	.long	0x60618920,0x3ff44e08
	.long	0xb5c13cc0,0x3ff486a2
	.long	0xd5362a20,0x3ff4bfda
	.long	0x769d2ca0,0x3ff4f9b2
	.long	0x569d4f80,0x3ff5342b
	.long	0x36b527c0,0x3ff56f47
	.long	0xdd485420,0x3ff5ab07
	.long	0x15ad2140,0x3ff5e76f
	.long	0xb03a5580,0x3ff6247e
	.long	0x82552220,0x3ff66238
	.long	0x667f3bc0,0x3ff6a09e
	.type	__libm_exp_hi_table_64,@object
	.size	__libm_exp_hi_table_64,520
	.align 8
	.globl __libm_exp_mi_table_64
__libm_exp_mi_table_64:
	.long	0x33018800,0xbfd2bec3
	.long	0x8735cb80,0xbfd2409b
	.long	0x2e274100,0xbfd1c114
	.long	0x537b3000,0xbfd14029
	.long	0x1829fc80,0xbfd0bdd7
	.long	0x92616300,0xbfd03a19
	.long	0x9accc780,0xbfcf69d9
	.long	0x92edb400,0xbfce5c99
	.long	0xf7557c80,0xbfcd4c6a
	.long	0x9baa2300,0xbfcc3945
	.long	0x3cc8e800,0xbfcb2321
	.long	0x8086c680,0xbfca09f5
	.long	0xf5703d80,0xbfc8edb9
	.long	0x12886a00,0xbfc7ce66
	.long	0x37076a80,0xbfc6abf1
	.long	0xaa180900,0xbfc58652
	.long	0x9a94b100,0xbfc45d81
	.long	0x1ec3a800,0xbfc33175
	.long	0x34128680,0xbfc20224
	.long	0xbed0f880,0xbfc0cf85
	.long	0x13d56b00,0xbfbf3321
	.long	0x8d417580,0xbfbcc076
	.long	0x18837c80,0xbfba46f9
	.long	0xafc3b400,0xbfb7c695
	.long	0x1822db80,0xbfb53f39
	.long	0xe1266b80,0xbfb2b0cf
	.long	0x64232500,0xbfb01b46
	.long	0x874c0080,0xbfaafd11
	.long	0xd5b6f200,0xbfa5b505
	.long	0x19ea5d80,0xbfa05e41
	.long	0x92375780,0xbf95f134
	.long	0x985bc980,0xbf860f9f
	.long	0x00000000,0x00000000
	.long	0x3bc03000,0x3f864d1f
	.long	0xc5615d00,0x3f966c34
	.long	0x0eb37900,0x3fa0e8a3
	.long	0x9f312180,0x3fa6ab0d
	.long	0x5a7a3400,0x3fac7d86
	.long	0x0125b500,0x3fb1301d
	.long	0xea92dd80,0x3fb429aa
	.long	0xc7d51780,0x3fb72b83
	.long	0xb6fcb700,0x3fba35be
	.long	0x168b9a80,0x3fbd4873
	.long	0x43146680,0x3fc031dc
	.long	0x73ab1180,0x3fc1c3d3
	.long	0x2f13e680,0x3fc35a2b
	.long	0xa8fef700,0x3fc4f4ef
	.long	0x37201800,0x3fc6942d
	.long	0x518db880,0x3fc837f0
	.long	0x9320b780,0x3fc9e045
	.long	0xb9d54e00,0x3fcb8d39
	.long	0xa72cff80,0x3fcd3ed9
	.long	0x6091a100,0x3fcef532
	.long	0x87dcb880,0x3fd05828
	.long	0x81862480,0x3fd13821
	.long	0xd704f300,0x3fd21a8a
	.long	0x54d8a880,0x3fd2ff6b
	.long	0xda74b280,0x3fd3e6c9
	.long	0x5a753e00,0x3fd4d0ad
	.long	0xdad49f00,0x3fd5bd1c
	.long	0x75215080,0x3fd6ac1f
	.long	0x56b48500,0x3fd79dbc
	.long	0xc0e95600,0x3fd891fa
	.long	0x09548880,0x3fd988e2
	.long	0x99fcef00,0x3fda8279
	.type	__libm_exp_mi_table_64,@object
	.size	__libm_exp_mi_table_64,520
	.align 8
	.globl __libm_exp_lo_table_64
__libm_exp_lo_table_64:
	.long	0x682764c9,0xbcf9b7ba
	.long	0x1d341e44,0xbce10ddf
	.long	0x1e1a21ea,0xbcd845b9
	.long	0xb2ae62dc,0xbcfba048
	.long	0x77ee0499,0xbcfc9415
	.long	0xfd45ea87,0xbcedefa2
	.long	0xeea0a997,0xbcdaea60
	.long	0xe26f53db,0xbce37f1b
	.long	0xea979b4e,0xbcc29160
	.long	0xb17471a2,0xbcd3a8cf
	.long	0xe3c0dabf,0xbceb0baf
	.long	0x6df06e17,0xbce07461
	.long	0x729f1c1b,0xbcdfc707
	.long	0x25747355,0xbceb4d65
	.long	0xdb71a83c,0xbcbba5ed
	.long	0x78840167,0xbc97829b
	.long	0xcb2e88ce,0xbce2a178
	.long	0xbc6109ae,0xbcc42500
	.long	0x4f7e54ac,0xbce91558
	.long	0xbe174986,0xbcdbb708
	.long	0xa76afb72,0xbcbeeef9
	.long	0x200b7c35,0xbcc2d77b
	.long	0xd0b85ad9,0xbccbabf0
	.long	0x743797aa,0xbcc1cbc3
	.long	0xf4a29324,0xbcd1b44b
	.long	0xfcb49256,0xbcd51ee7
	.long	0x53c612d7,0xbca46973
	.long	0xcfeac66e,0xbcad8c2e
	.long	0x3179c289,0xbcc9e9c2
	.long	0xbcada4a8,0xbc911c05
	.long	0xda44ebcf,0xbcbcc583
	.long	0x818b4d9c,0xbcad16f5
	.long	0x00000000,0x00000000
	.long	0x95949ef4,0x3cadcdef
	.long	0xa475b465,0x3c8d73e2
	.long	0x4bb284ff,0x3c6186be
	.long	0xc95b8c21,0x3ccb14c5
	.long	0x1727c57b,0x3cc0103a
	.long	0xe35db263,0x3ca49d77
	.long	0x0650ec96,0x3cdecd04
	.long	0xe4628759,0x3cc6e6fb
	.long	0x63da4b47,0x3cd4f2da
	.long	0xc0144c88,0x3cc3c02d
	.long	0xac0a5425,0x3cd8ee3b
	.long	0xf5b6382c,0x3ce0cd83
	.long	0xce6503a7,0x3cea4af4
	.long	0x15f5a24b,0x3cb2c25d
	.long	0x3aa6da0f,0x3ce68012
	.long	0x56918c17,0x3cd4b7a3
	.long	0x0c21b2cd,0x3cee9939
	.long	0xaa05e8a9,0x3ce54e28
	.long	0x24a67828,0x3cdba86f
	.long	0x911f09ec,0x3cc1ada0
	.long	0x4b71e7b7,0x3ce3f086
	.long	0xde813be0,0x3cea0626
	.long	0xa3b69063,0x3cf013c1
	.long	0x5ebfb10c,0x3cdc750e
	.long	0x62da6a82,0x3cdab4cf
	.long	0x3c49d86a,0x3cbdf0a8
	.long	0xb004764f,0x3cfa66ec
	.long	0x602a323d,0x3ce2b192
	.long	0xc9840733,0x3ce0dd37
	.long	0xe81bf4b7,0x3cd2c7c3
	.long	0x678a6e3d,0x3cd2449f
	.long	0x5f626cdd,0x3ce92116
	.type	__libm_exp_lo_table_64,@object
	.size	__libm_exp_lo_table_64,520
	.align 8
	.globl __libm_exp_table_128
__libm_exp_table_128:
	.long	0x908b2fb1,0x3def3bcc
	.long	0x66600000,0x3fe6a09e
	.long	0xdaed5330,0x3dd7b57d
	.long	0x75000000,0x3fe6c012
	.long	0xc8838b30,0x3dc468bb
	.long	0x3c600000,0x3fe6dfb2
	.long	0xcf87e1b5,0x3de19483
	.long	0xf9400000,0x3fe6ff7d
	.long	0xba46e1e6,0x3dd8bee7
	.long	0xe8e00000,0x3fe71f75
	.long	0xf572693a,0x3dc605ce
	.long	0x48a00000,0x3fe73f9a
	.long	0xfb74d51a,0x3db33e45
	.long	0x56400000,0x3fe75feb
	.long	0x619ae028,0x3dee5d3f
	.long	0x4fc00000,0x3fe78069
	.long	0xafaa2048,0x3dd6030d
	.long	0x73e00000,0x3fe7a114
	.long	0x7c493344,0x3de0c132
	.long	0x01200000,0x3fe7c1ed
	.long	0x20ba0574,0x3dde9cc4
	.long	0x36c00000,0x3fe7e2f3
	.long	0xb60de676,0x3dee1a11
	.long	0x54200000,0x3fe80427
	.long	0x159f115f,0x3dd99c25
	.long	0x99400000,0x3fe82589
	.long	0x7297b5cc,0x3dbe3d66
	.long	0x46200000,0x3fe8471a
	.long	0x03907643,0x3dc24bb2
	.long	0x9b400000,0x3fe868d9
	.long	0xcca6179c,0x3dd4cd32
	.long	0xd9800000,0x3fe88ac7
	.long	0xb74f8ab4,0x3dd541b6
	.long	0x42200000,0x3fe8ace5
	.long	0xef2aa1cd,0x3de5448b
	.long	0x16a00000,0x3fe8cf32
	.long	0x2b982746,0x3de57736
	.long	0x99000000,0x3fe8f1ae
	.long	0x88a61b47,0x3de1ffc5
	.long	0x0b800000,0x3fe9145b
	.long	0xe8a0387e,0x3ddb8bc9
	.long	0xb0c00000,0x3fe93737
	.long	0xd36906d3,0x3dd0a41d
	.long	0xcbc00000,0x3fe95a44
	.long	0x8b9e9210,0x3dee4e4f
	.long	0x9fc00000,0x3fe97d82
	.long	0x74621372,0x3dd40f73
	.long	0x70c00000,0x3fe9a0f1
	.long	0xe3e23584,0x3dbf8480
	.long	0x82a00000,0x3fe9c491
	.long	0xc12653c7,0x3db91918
	.long	0x19e00000,0x3fe9e863
	.long	0xb29ada8c,0x3dede564
	.long	0x7b400000,0x3fea0c66
	.long	0xb182e3ef,0x3dd45a66
	.long	0xec400000,0x3fea309b
	.long	0x8b424492,0x3dee255c
	.long	0xb2200000,0x3fea5503
	.long	0x6f2dfb2b,0x3de0b358
	.long	0x13200000,0x3fea799e
	.long	0x43eb243c,0x3de9fdbf
	.long	0x55600000,0x3fea9e6b
	.long	0xc0db966a,0x3de3f379
	.long	0xbfc00000,0x3feac36b
	.long	0x5e8734d1,0x3dead3ad
	.long	0x99400000,0x3feae89f
	.long	0x2108559c,0x3ddb6ccb
	.long	0x29800000,0x3feb0e07
	.long	0xed7fa1cf,0x3dde2bf5
	.long	0xb8400000,0x3feb33a2
	.long	0x38e20444,0x3dc564e6
	.long	0x8de00000,0x3feb5972
	.long	0xeaa7b082,0x3deb5e46
	.long	0xf2e00000,0x3feb7f76
	.long	0x40cb3c6b,0x3da06498
	.long	0x30a00000,0x3feba5b0
	.long	0x48f741e9,0x3dd783a4
	.long	0x90400000,0x3febcc1e
	.long	0x8408d702,0x3de71e08
	.long	0x5bc00000,0x3febf2c2
	.long	0x88832c4b,0x3dc54a70
	.long	0xdd800000,0x3fec199b
	.long	0x6d14df82,0x3defd07a
	.long	0x5fe00000,0x3fec40ab
	.long	0x4a2137fd,0x3de7d14b
	.long	0x2e400000,0x3fec67f1
	.long	0x46b2f122,0x3dcb9ed4
	.long	0x94000000,0x3fec8f6d
	.long	0x2a0797a4,0x3ddf20d2
	.long	0xdce00000,0x3fecb720
	.long	0xc44f8959,0x3dedc3f9
	.long	0x55400000,0x3fecdf0b
	.long	0x343c8bc8,0x3dce25ee
	.long	0x4a000000,0x3fed072d
	.long	0x15bc2473,0x3ddb13e3
	.long	0x08000000,0x3fed2f87
	.long	0x25da05af,0x3deba487
	.long	0xdce00000,0x3fed5818
	.long	0x7709f3a1,0x3dd3072f
	.long	0x16c00000,0x3fed80e3
	.long	0x708c01a6,0x3deb3285
	.long	0x03c00000,0x3feda9e6
	.long	0xb695de3c,0x3dab4604
	.long	0xf3000000,0x3fedd321
	.long	0xb968cac4,0x3deb9b5e
	.long	0x33600000,0x3fedfc97
	.long	0xa12761fa,0x3de5a128
	.long	0x14e00000,0x3fee2646
	.long	0x4e7a2603,0x3dd67fec
	.long	0xe7800000,0x3fee502e
	.long	0x2d522ca1,0x3dcd320d
	.long	0xfbc00000,0x3fee7a51
	.long	0x163dce86,0x3dc24366
	.long	0xa2a00000,0x3feea4af
	.long	0x1b60625f,0x3ddccfe1
	.long	0x2d800000,0x3feecf48
	.long	0x71fd21a9,0x3da5a277
	.long	0xee600000,0x3feefa1b
	.long	0x9d0d2df8,0x3dd7752e
	.long	0x37600000,0x3fef252b
	.long	0xce9f096f,0x3ddc8a80
	.long	0x5b600000,0x3fef5076
	.long	0x8913b4c0,0x3decbe13
	.long	0xad800000,0x3fef7bfd
	.long	0x2e90a7e7,0x3dee90d8
	.long	0x81800000,0x3fefa7c1
	.long	0x12eb7496,0x3ddee3e2
	.long	0x2b800000,0x3fefd3c2
	.long	0x00000000,0x00000000
	.long	0x00000000,0x3ff00000
	.long	0x6d84a66b,0x3dfb3335
	.long	0xa9e00000,0x3ff0163d
	.long	0xee6f7cad,0x3df78060
	.long	0x3e600000,0x3ff02c9a
	.long	0x7ae71f34,0x3decff09
	.long	0xe8600000,0x3ff04315
	.long	0x3ae7c549,0x3df58574
	.long	0xd3000000,0x3ff059b0
	.long	0xc6dc403b,0x3dfdf6dd
	.long	0x29c00000,0x3ff0706b
	.long	0x08c35f26,0x3df59bc8
	.long	0x18600000,0x3ff08745
	.long	0x14878183,0x3ddbce0d
	.long	0xcac00000,0x3ff09e3e
	.long	0x6298b92b,0x3df9890f
	.long	0x6ce00000,0x3ff0b558
	.long	0x407b705c,0x3df247f7
	.long	0x2b600000,0x3ff0cc92
	.long	0x020742e5,0x3df3d1a2
	.long	0x32c00000,0x3ff0e3ec
	.long	0xf232091e,0x3dfed31a
	.long	0xafe00000,0x3ff0fb66
	.long	0xa4ebbf1b,0x3df25b50
	.long	0xd0000000,0x3ff11301
	.long	0xf72575a6,0x3de86397
	.long	0xc0600000,0x3ff12abd
	.long	0x66820328,0x3de25bbf
	.long	0xaea00000,0x3ff1429a
	.long	0x920355cf,0x3dd63944
	.long	0xc8a00000,0x3ff15a98
	.long	0xdcdf7c8c,0x3dfd517a
	.long	0x3c600000,0x3ff172b8
	.long	0x777ee173,0x3de91bd3
	.long	0x38800000,0x3ff18af9
	.long	0x796d31ed,0x3def96ea
	.long	0xeb600000,0x3ff1a35b
	.long	0x6ac79cad,0x3dd1734e
	.long	0x84000000,0x3ff1bbe0
	.long	0xf00b7005,0x3de17354
	.long	0x31600000,0x3ff1d487
	.long	0xb8819ff6,0x3dfcd91c
	.long	0x22e00000,0x3ff1ed50
	.long	0xdc775815,0x3dc466b1
	.long	0x88600000,0x3ff2063b
	.long	0x2552fd29,0x3dfddc96
	.long	0x91600000,0x3ff21f49
	.long	0x66c1fadb,0x3df56238
	.long	0x6e600000,0x3ff2387a
	.long	0x3582ab7e,0x3df2a63f
	.long	0x4fa00000,0x3ff251ce
	.long	0x2bd33994,0x3dc3e6e9
	.long	0x65e00000,0x3ff26b45
	.long	0x96cf15cf,0x3df56380
	.long	0xe1e00000,0x3ff284df
	.long	0x2c25d15f,0x3dffdee1
	.long	0xf5000000,0x3ff29e9d
	.long	0xfddea465,0x3dfad98f
	.long	0xd0c00000,0x3ff2b87f
	.long	0x0024754e,0x3dd00c2d
	.long	0xa6e00000,0x3ff2d285
	.long	0x11ca0f46,0x3dfe2f56
	.long	0xa9200000,0x3ff2ecaf
	.long	0x2de8d5a4,0x3df1b715
	.long	0x0a200000,0x3ff306fe
	.long	0x6a739e38,0x3de9b062
	.long	0xfc400000,0x3ff32170
	.long	0x32721843,0x3dd05bfd
	.long	0xb2600000,0x3ff33c08
	.long	0xc9462347,0x3df29ff0
	.long	0x5f800000,0x3ff356c5
	.long	0xa7145503,0x3dfaa9ca
	.long	0x37200000,0x3ff371a7
	.long	0x16a72c36,0x3dd76196
	.long	0x6d000000,0x3ff38cae
	.long	0xa86f24a6,0x3dd67fdb
	.long	0x34e00000,0x3ff3a7db
	.long	0x84001f23,0x3df3a8e4
	.long	0xc3000000,0x3ff3c32d
	.long	0x35b41224,0x3df23422
	.long	0x4c000000,0x3ff3dea6
	.long	0x417ee035,0x3de90037
	.long	0x04a00000,0x3ff3fa45
	.long	0xf84325b9,0x3df72e29
	.long	0x21e00000,0x3ff4160a
	.long	0xdc704439,0x3df0a896
	.long	0xd9400000,0x3ff431f5
	.long	0x3136f40a,0x3db892d0
	.long	0x60600000,0x3ff44e08
	.long	0x72512f46,0x3dfd0057
	.long	0xed000000,0x3ff46a41
	.long	0x3c1a3b69,0x3db3cd01
	.long	0xb5c00000,0x3ff486a2
	.long	0x672d8bcf,0x3df7d3de
	.long	0xf0c00000,0x3ff4a32a
	.long	0x1d4397b0,0x3df62a27
	.long	0xd5200000,0x3ff4bfda
	.long	0x63b36ef2,0x3dfddd0d
	.long	0x99e00000,0x3ff4dcb2
	.long	0xad33d8b7,0x3dfd2ca6
	.long	0x76800000,0x3ff4f9b2
	.long	0x8225ea59,0x3deecc83
	.long	0xa2c00000,0x3ff516da
	.long	0xdf0a83c5,0x3dfd4f81
	.long	0x56800000,0x3ff5342b
	.long	0xc52ec620,0x3dfd920e
	.long	0xca400000,0x3ff551a4
	.long	0x66ecb004,0x3df527da
	.long	0x36a00000,0x3ff56f47
	.long	0x252bc2b7,0x3df7c7fd
	.long	0xd4800000,0x3ff58d12
	.long	0xb192602a,0x3de0a852
	.long	0xdd400000,0x3ff5ab07
	.long	0x01c4b1b8,0x3df946b7
	.long	0x8a400000,0x3ff5c926
	.long	0xdd37c984,0x3dea4290
	.long	0x15a00000,0x3ff5e76f
	.long	0xb076f593,0x3df6dc08
	.long	0xb9600000,0x3ff605e1
	.long	0xb1f0fa07,0x3dfa5584
	.long	0xb0200000,0x3ff6247e
	.long	0x8edf0e2a,0x3de9863f
	.long	0x34c00000,0x3ff64346
	.long	0x9127d9e3,0x3df52224
	.long	0x82400000,0x3ff66238
	.long	0x1038ae45,0x3de952e6
	.long	0xd4400000,0x3ff68155
	.long	0x908b2fb1,0x3dff3bcc
	.long	0x66600000,0x3ff6a09e
	.type	__libm_exp_table_128,@object
	.size	__libm_exp_table_128,2064
	.data
	.section .note.GNU-stack, ""
# End
