/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.u2f.data.messages;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.yubico.u2f.data.messages.key.util.U2fB64Encoding;
import com.yubico.u2f.exceptions.U2fBadInputException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;

@Deprecated
public class ClientData {
    private static final String TYPE_PARAM = "typ";
    private static final String CHALLENGE_PARAM = "challenge";
    private static final String ORIGIN_PARAM = "origin";
    private final String type;
    private final String challenge;
    private final String origin;
    private final String rawClientData;

    public String asJson() {
        return this.rawClientData;
    }

    public ClientData(String clientData) throws U2fBadInputException {
        this.rawClientData = new String(U2fB64Encoding.decode(clientData));
        try {
            JsonNode data = new ObjectMapper().readTree(this.rawClientData);
            this.type = ClientData.getString(data, TYPE_PARAM);
            this.challenge = ClientData.getString(data, CHALLENGE_PARAM);
            this.origin = ClientData.getString(data, ORIGIN_PARAM);
        }
        catch (IOException e) {
            throw new U2fBadInputException("Malformed ClientData", e);
        }
    }

    public String toString() {
        return this.rawClientData;
    }

    public String getChallenge() {
        return this.challenge;
    }

    private static String getString(JsonNode data, String key) throws U2fBadInputException {
        JsonNode node = data.get(key);
        if (node == null) {
            throw new U2fBadInputException("Bad clientData: missing field " + key);
        }
        if (!node.isTextual()) {
            throw new U2fBadInputException("Bad clientData: field " + key + " not a string");
        }
        return node.asText();
    }

    public void checkContent(String type, String challenge, Optional<Set<String>> facets) throws U2fBadInputException {
        if (!type.equals(this.type)) {
            throw new U2fBadInputException("Bad clientData: wrong type " + this.type);
        }
        if (!challenge.equals(this.challenge)) {
            throw new U2fBadInputException("Bad clientData: wrong challenge");
        }
        if (facets.isPresent()) {
            String canonicalOrigin;
            Set<String> allowedFacets = ClientData.canonicalizeOrigins((Set)facets.get());
            try {
                canonicalOrigin = ClientData.canonicalizeOrigin(this.origin);
            }
            catch (RuntimeException e) {
                throw new U2fBadInputException("Bad clientData: Malformed origin", e);
            }
            ClientData.verifyOrigin(canonicalOrigin, allowedFacets);
        }
    }

    private static void verifyOrigin(String origin, Set<String> allowedOrigins) throws U2fBadInputException {
        if (!allowedOrigins.contains(origin)) {
            throw new U2fBadInputException(origin + " is not a recognized facet for this application");
        }
    }

    public static Set<String> canonicalizeOrigins(Set<String> origins) {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (String origin : origins) {
            result.add((Object)ClientData.canonicalizeOrigin(origin));
        }
        return result.build();
    }

    public static String canonicalizeOrigin(String url) {
        try {
            URI uri = new URI(url);
            if (uri.getAuthority() == null) {
                return url;
            }
            return uri.getScheme() + "://" + uri.getAuthority();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("specified bad origin", e);
        }
    }
}

