/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.util.List;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.db.SuspensionState;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.SuspensionStateUtil;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.runtime.Execution;
import org.flowable.job.service.JobService;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.TimerJobService;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.SuspendedJobEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;

public abstract class AbstractSetProcessInstanceStateCmd
implements Command<Void> {
    protected final String processInstanceId;

    public AbstractSetProcessInstanceStateCmd(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Void execute(CommandContext commandContext) {
        if (this.processInstanceId == null) {
            throw new FlowableIllegalArgumentException("ProcessInstanceId cannot be null.");
        }
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ExecutionEntityManager executionEntityManager = processEngineConfiguration.getExecutionEntityManager();
        ExecutionEntity executionEntity = (ExecutionEntity)executionEntityManager.findById(this.processInstanceId);
        if (executionEntity == null) {
            throw new FlowableObjectNotFoundException("Cannot find processInstance for id '" + this.processInstanceId + "'.", Execution.class);
        }
        if (!executionEntity.isProcessInstanceType()) {
            throw new FlowableException("Cannot set suspension state for execution '" + this.processInstanceId + "': not a process instance.");
        }
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, executionEntity.getProcessDefinitionId())) {
            if (this.getNewState() == SuspensionState.ACTIVE) {
                processEngineConfiguration.getFlowable5CompatibilityHandler().activateProcessInstance(this.processInstanceId);
            } else {
                processEngineConfiguration.getFlowable5CompatibilityHandler().suspendProcessInstance(this.processInstanceId);
            }
            return null;
        }
        SuspensionStateUtil.setSuspensionState(executionEntity, this.getNewState());
        executionEntityManager.update(executionEntity, false);
        List<ExecutionEntity> childExecutions = executionEntityManager.findChildExecutionsByProcessInstanceId(this.processInstanceId);
        for (ExecutionEntity executionEntity2 : childExecutions) {
            if (executionEntity2.getId().equals(this.processInstanceId)) continue;
            SuspensionStateUtil.setSuspensionState(executionEntity2, this.getNewState());
            executionEntityManager.update(executionEntity2, false);
        }
        List tasks = processEngineConfiguration.getTaskServiceConfiguration().getTaskService().findTasksByProcessInstanceId(this.processInstanceId);
        for (TaskEntity taskEntity : tasks) {
            SuspensionStateUtil.setSuspensionState(taskEntity, this.getNewState());
            processEngineConfiguration.getTaskServiceConfiguration().getTaskService().updateTask(taskEntity, false);
        }
        JobServiceConfiguration jobServiceConfiguration = processEngineConfiguration.getJobServiceConfiguration();
        JobService jobService = jobServiceConfiguration.getJobService();
        if (this.getNewState() == SuspensionState.ACTIVE) {
            List suspendedJobs = jobService.findSuspendedJobsByProcessInstanceId(this.processInstanceId);
            for (SuspendedJobEntity suspendedJob : suspendedJobs) {
                jobService.activateSuspendedJob(suspendedJob);
            }
        } else {
            TimerJobService timerJobService = jobServiceConfiguration.getTimerJobService();
            List timerJobs = timerJobService.findTimerJobsByProcessInstanceId(this.processInstanceId);
            for (Object timerJob : timerJobs) {
                jobService.moveJobToSuspendedJob((AbstractRuntimeJobEntity)timerJob);
            }
            List jobs = jobService.findJobsByProcessInstanceId(this.processInstanceId);
            for (JobEntity job : jobs) {
                jobService.moveJobToSuspendedJob((AbstractRuntimeJobEntity)job);
            }
            List externalWorkerJobs = jobServiceConfiguration.getExternalWorkerJobEntityManager().findJobsByProcessInstanceId(this.processInstanceId);
            for (ExternalWorkerJobEntity externalWorkerJob : externalWorkerJobs) {
                jobService.moveJobToSuspendedJob((AbstractRuntimeJobEntity)externalWorkerJob);
            }
        }
        return null;
    }

    protected abstract SuspensionState getNewState();
}

