/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.serializer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.impl.serializer.APIConfigurationHandlers;
import org.identityconnectors.framework.impl.serializer.CommonObjectHandlers;
import org.identityconnectors.framework.impl.serializer.FilterHandlers;
import org.identityconnectors.framework.impl.serializer.MessageHandlers;
import org.identityconnectors.framework.impl.serializer.ObjectSerializationHandler;
import org.identityconnectors.framework.impl.serializer.ObjectTypeMapper;
import org.identityconnectors.framework.impl.serializer.ObjectTypeMapperImpl;
import org.identityconnectors.framework.impl.serializer.OperationMappings;
import org.identityconnectors.framework.impl.serializer.Primitives;

public final class ObjectSerializerRegistry {
    private static final List<ObjectTypeMapper> HANDLERS = new ArrayList<ObjectTypeMapper>();
    private static final Map<String, ObjectTypeMapper> HANDLERS_BY_SERIAL_TYPE = new HashMap<String, ObjectTypeMapper>();
    private static final Map<Class<?>, ObjectTypeMapper> HANDLERS_BY_OBJECT_TYPE;

    public static ObjectTypeMapper getMapperBySerialType(String type) {
        return HANDLERS_BY_SERIAL_TYPE.get(type);
    }

    public static ObjectTypeMapper getMapperByObjectType(Class<?> clazz) {
        ObjectTypeMapper mapper = HANDLERS_BY_OBJECT_TYPE.get(clazz);
        if (mapper == null) {
            for (ObjectTypeMapper handler : HANDLERS) {
                if (handler.isMatchSubclasses()) {
                    if (!handler.getHandledObjectType().isAssignableFrom(clazz)) continue;
                    mapper = handler;
                    break;
                }
                if (!handler.getHandledObjectType().equals(clazz)) continue;
                mapper = handler;
                break;
            }
            HANDLERS_BY_OBJECT_TYPE.put(clazz, mapper);
        }
        return mapper;
    }

    public static ObjectSerializationHandler getHandlerBySerialType(String type) {
        ObjectTypeMapper mapper = ObjectSerializerRegistry.getMapperBySerialType(type);
        if (mapper instanceof ObjectSerializationHandler) {
            return (ObjectSerializationHandler)mapper;
        }
        return null;
    }

    public static ObjectSerializationHandler getHandlerByObjectType(Class<?> clazz) {
        ObjectTypeMapper mapper = ObjectSerializerRegistry.getMapperByObjectType(clazz);
        if (mapper instanceof ObjectSerializationHandler) {
            return (ObjectSerializationHandler)mapper;
        }
        return null;
    }

    private ObjectSerializerRegistry() {
    }

    static {
        HANDLERS.addAll(Primitives.HANDLERS);
        HANDLERS.addAll(OperationMappings.MAPPINGS);
        HANDLERS.addAll(APIConfigurationHandlers.HANDLERS);
        HANDLERS.addAll(FilterHandlers.HANDLERS);
        HANDLERS.addAll(CommonObjectHandlers.HANDLERS);
        HANDLERS.addAll(MessageHandlers.HANDLERS);
        HANDLERS.add(new ObjectTypeMapperImpl(Object.class, "Object"));
        for (ObjectTypeMapper handler : HANDLERS) {
            ObjectTypeMapper previous = HANDLERS_BY_SERIAL_TYPE.put(handler.getHandledSerialType(), handler);
            if (previous == null) continue;
            throw new ConnectorException("More than one handler of the same type: " + handler.getHandledSerialType());
        }
        HANDLERS_BY_OBJECT_TYPE = Collections.synchronizedMap(new WeakHashMap());
    }
}

