/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.exps.FilterValue;
import org.apache.openjpa.jdbc.kernel.exps.Lit;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.PrimaryKey;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.util.UserException;

public class SolidDBDictionary
extends DBDictionary {
    public boolean storeIsMemory = false;
    public boolean useTriggersForAutoAssign = true;
    public String autoAssignSequenceName = null;
    public boolean openjpa3GeneratedKeyNames = false;
    public String lockingMode = null;
    private static final Localizer _loc = Localizer.forPackage(SolidDBDictionary.class);

    public SolidDBDictionary() {
        this.platform = "SolidDB";
        this.bitTypeName = "TINYINT";
        this.blobTypeName = "LONG VARBINARY";
        this.booleanTypeName = "TINYINT";
        this.clobTypeName = "LONG VARCHAR";
        this.doubleTypeName = "DOUBLE PRECISION";
        this.allowsAliasInBulkClause = false;
        this.useGetStringForClobs = true;
        this.useSetStringForClobs = true;
        this.supportsDeferredConstraints = false;
        this.supportsNullUniqueColumn = false;
        this.concatenateFunction = "CONCAT({0},{1})";
        this.stringLengthFunction = "LENGTH({0})";
        this.trimLeadingFunction = "LTRIM({0})";
        this.trimTrailingFunction = "RTRIM({0})";
        this.trimBothFunction = "TRIM({0})";
        this.currentDateFunction = "CURDATE()";
        this.currentTimeFunction = "CURTIME()";
        this.currentTimestampFunction = "NOW()";
        this.lastGeneratedKeyQuery = "SELECT {0}.CURRENT";
        this.sequenceSQL = "SELECT SEQUENCE_SCHEMA, SEQUENCE_NAME FROM SYS_SEQUENCES";
        this.sequenceSchemaSQL = "SEQSCHEMA = ?";
        this.sequenceNameSQL = "SEQNAME = ?";
        this.reservedWordSet.addAll(Arrays.asList("BIGINT", "BINARY", "DATE", "TIME", "TINYINT", "VARBINARY"));
    }

    @Override
    public void endConfiguration() {
        super.endConfiguration();
        if (this.useTriggersForAutoAssign) {
            this.supportsAutoAssign = true;
        }
    }

    @Override
    public String[] getCreateTableSQL(Table table, SchemaGroup group) {
        Unique[] unqs;
        String pkStr;
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE TABLE ").append(this.getFullName(table, false)).append(" (");
        Column[] cols = table.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.getDeclareColumnSQL(cols[i], false));
        }
        PrimaryKey pk = table.getPrimaryKey();
        if (pk != null && !StringUtil.isEmpty((String)(pkStr = this.getPrimaryKeyConstraintSQL(pk)))) {
            buf.append(", ").append(pkStr);
        }
        for (Unique unq : unqs = table.getUniques()) {
            String unqStr = this.getUniqueConstraintSQL(unq);
            if (unqStr == null) continue;
            buf.append(", ").append(unqStr);
        }
        buf.append(") STORE ");
        if (this.storeIsMemory) {
            buf.append("MEMORY");
        } else {
            buf.append("DISK");
        }
        String[] create = null;
        if (this.lockingMode != null) {
            StringBuilder buf1 = new StringBuilder();
            if (this.lockingMode.equalsIgnoreCase("PESSIMISTIC")) {
                buf1.append("ALTER TABLE ").append(this.getFullName(table, false)).append(" SET PESSIMISTIC");
            } else if (this.lockingMode.equalsIgnoreCase("OPTIMISTIC")) {
                buf1.append("ALTER TABLE ").append(this.getFullName(table, false)).append(" SET OPTIMISTIC");
            } else {
                throw new UserException(_loc.get("invalid-locking-mode", (Object)this.lockingMode));
            }
            create = new String[]{buf.toString(), buf1.toString()};
        } else {
            create = new String[]{buf.toString()};
        }
        if (!this.useTriggersForAutoAssign) {
            return create;
        }
        ArrayList<String> seqs = null;
        for (int i = 0; cols != null && i < cols.length; ++i) {
            if (!cols[i].isAutoAssigned()) continue;
            if (seqs == null) {
                seqs = new ArrayList<String>(4);
            }
            String seq = this.getAutoGenSeqName(cols[i]);
            if (this.sequenceExists(table.getSchemaIdentifier().getName(), seq, group)) {
                seqs.add("DROP SEQUENCE " + seq);
            }
            seqs.add("CREATE SEQUENCE " + seq);
            String trig = this.openjpa3GeneratedKeyNames ? this.getOpenJPA3GeneratedKeyTriggerName(cols[i]) : this.getGeneratedKeyTriggerName(cols[i]);
            seqs.add("CREATE TRIGGER " + trig + " ON " + this.toDBName(table.getIdentifier()) + " BEFORE INSERT REFERENCING NEW " + this.toDBName(cols[i].getIdentifier()) + " AS NEW_COL1 BEGIN EXEC SEQUENCE " + seq + " NEXT INTO NEW_COL1; END");
        }
        if (seqs == null) {
            return create;
        }
        String[] sql = new String[create.length + seqs.size()];
        System.arraycopy(create, 0, sql, 0, create.length);
        for (int i = 0; i < seqs.size(); ++i) {
            sql[create.length + i] = (String)seqs.get(i);
        }
        return sql;
    }

    protected boolean sequenceExists(String schemaName, String seqName, SchemaGroup group) {
        Schema[] schemas;
        for (Schema schema : schemas = group.getSchemas()) {
            Sequence[] seqs;
            String dbSchemaName = schema.getIdentifier().getName();
            if (schemaName != null && !schemaName.equalsIgnoreCase(dbSchemaName)) continue;
            for (Sequence seq : seqs = schema.getSequences()) {
                String dbSeqName = seq.getName();
                if (dbSeqName == null || !dbSeqName.equalsIgnoreCase(seqName)) continue;
                return true;
            }
        }
        return false;
    }

    protected String getGeneratedKeyTriggerName(Column col) {
        String seqName = this.getGeneratedKeySequenceName(col);
        return seqName.substring(0, seqName.length() - 3) + "TRG";
    }

    protected String getOpenJPA3GeneratedKeySequenceName(Column col) {
        Table table = col.getTable();
        DBIdentifier sName = DBIdentifier.preCombine(table.getIdentifier(), "SEQ");
        return this.toDBName(this.getNamingUtil().makeIdentifierValid(sName, table.getSchema().getSchemaGroup(), this.maxTableNameLength, true));
    }

    protected String getOpenJPA3GeneratedKeyTriggerName(Column col) {
        Table table = col.getTable();
        DBIdentifier sName = DBIdentifier.preCombine(table.getIdentifier(), "TRIG");
        return this.toDBName(this.getNamingUtil().makeIdentifierValid(sName, table.getSchema().getSchemaGroup(), this.maxTableNameLength, true));
    }

    protected String getAutoGenSeqName(Column col) {
        String seqName = this.autoAssignSequenceName;
        if (seqName == null) {
            seqName = this.openjpa3GeneratedKeyNames ? this.getOpenJPA3GeneratedKeySequenceName(col) : this.getGeneratedKeySequenceName(col);
        }
        return seqName;
    }

    @Override
    protected String getGenKeySeqName(String query, Column col) {
        return MessageFormat.format(query, this.getAutoGenSeqName(col));
    }

    @Override
    public String convertSchemaCase(DBIdentifier objectName) {
        if (objectName != null && objectName.getName() == null) {
            return "";
        }
        return super.convertSchemaCase(objectName);
    }

    @Override
    public void substring(SQLBuffer buf, FilterValue str, FilterValue start, FilterValue length) {
        if (length != null) {
            super.substring(buf, str, start, length);
        } else {
            buf.append(this.substringFunctionName).append("(");
            str.appendTo(buf);
            buf.append(", ");
            if (start.getValue() instanceof Number) {
                buf.append(Long.toString(this.toLong(start)));
            } else {
                start.appendTo(buf);
            }
            buf.append(", ");
            if (start.getValue() instanceof Number) {
                long startLong = this.toLong(start);
                long endLong = Integer.MAX_VALUE;
                buf.append(Long.toString(endLong - startLong));
            } else {
                buf.append(Integer.toString(Integer.MAX_VALUE));
                buf.append(" - (");
                start.appendTo(buf);
                buf.append(")");
            }
            buf.append(")");
        }
    }

    @Override
    public void indexOf(SQLBuffer buf, FilterValue str, FilterValue find, FilterValue start) {
        buf.append("LOCATE(");
        find.appendTo(buf);
        buf.append(", ");
        str.appendTo(buf);
        if (start != null) {
            buf.append(", ");
            start.appendTo(buf);
        }
        buf.append(")");
    }

    @Override
    public boolean isSystemIndex(DBIdentifier name, Table table) {
        String strName = DBIdentifier.isNull(name) ? null : name.getName();
        boolean startsWith$$ = false;
        if (strName != null) {
            startsWith$$ = name.isDelimited() ? strName.startsWith("\"$$") : strName.startsWith("$$");
        }
        return super.isSystemIndex(name, table) || startsWith$$;
    }

    @Override
    public boolean isSystemSequence(DBIdentifier name, DBIdentifier schema, boolean targetSchema) {
        boolean startsWithSYS_SEQ_;
        if (super.isSystemSequence(name, schema, targetSchema)) {
            return true;
        }
        String schemaName = DBIdentifier.isNull(schema) ? null : schema.getName();
        boolean startsWith_SYSTEM = schema.isDelimited() ? schemaName.startsWith("\"_SYSTEM") : schemaName.startsWith("_SYSTEM");
        String seqName = DBIdentifier.isNull(name) ? null : name.getName();
        boolean bl = startsWithSYS_SEQ_ = name.isDelimited() ? seqName.startsWith("\"SYS_SEQ_") : seqName.startsWith("SYS_SEQ_");
        return startsWith_SYSTEM && startsWithSYS_SEQ_;
    }

    @Override
    public void setBigDecimal(PreparedStatement stmnt, int idx, BigDecimal val, Column col) throws SQLException {
        int type = val == null || col == null ? 24 : col.getJavaType();
        switch (type) {
            case 3: 
            case 19: {
                this.setDouble(stmnt, idx, val.doubleValue(), col);
                break;
            }
            case 4: 
            case 20: {
                this.setFloat(stmnt, idx, val.floatValue(), col);
                break;
            }
            case 6: 
            case 22: {
                this.setLong(stmnt, idx, val.longValue(), col);
                break;
            }
            default: {
                super.setBigDecimal(stmnt, idx, val, col);
            }
        }
    }

    @Override
    public void setDouble(PreparedStatement stmnt, int idx, double val, Column col) throws SQLException {
        int type = col == null ? 3 : col.getJavaType();
        switch (type) {
            case 3: 
            case 19: {
                super.setDouble(stmnt, idx, val, col);
                break;
            }
            case 4: 
            case 20: {
                this.setFloat(stmnt, idx, Double.valueOf(val).floatValue(), col);
                break;
            }
            case 6: 
            case 22: {
                this.setLong(stmnt, idx, Double.valueOf(val).longValue(), col);
            }
        }
    }

    @Override
    public boolean needsToCreateIndex(Index idx, Table table, Unique[] uniques) {
        PrimaryKey pk = table.getPrimaryKey();
        if (pk != null && idx.columnsMatch(pk.getColumns())) {
            return false;
        }
        Column[] icols = idx.getColumns();
        boolean isDuplicate = false;
        boolean mayBeDuplicate = false;
        for (Unique unique : uniques) {
            Column[] ucols = unique.getColumns();
            if (ucols.length < icols.length) continue;
            int j = 0;
            for (int k = 0; j < ucols.length && k < icols.length; ++j, ++k) {
                if (mayBeDuplicate && ucols[j].getQualifiedPath().equals(icols[k].getQualifiedPath())) {
                    if (k == icols.length - 1) {
                        isDuplicate = true;
                        continue;
                    }
                    mayBeDuplicate = true;
                    continue;
                }
                mayBeDuplicate = false;
            }
            if (isDuplicate) break;
        }
        return isDuplicate;
    }

    @Override
    protected String getSequencesSQL(String schemaName, String sequenceName) {
        return this.getSequencesSQL(DBIdentifier.newSchema(schemaName), DBIdentifier.newSequence(sequenceName));
    }

    @Override
    protected String getSequencesSQL(DBIdentifier schemaName, DBIdentifier sequenceName) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.sequenceSQL);
        if (!DBIdentifier.isNull(schemaName) || !DBIdentifier.isNull(sequenceName)) {
            buf.append(" WHERE ");
        }
        if (!DBIdentifier.isNull(schemaName)) {
            buf.append(this.sequenceSchemaSQL);
            if (!DBIdentifier.isNull(sequenceName)) {
                buf.append(" AND ");
            }
        }
        if (!DBIdentifier.isNull(sequenceName)) {
            buf.append(this.sequenceNameSQL);
        }
        return buf.toString();
    }

    @Override
    protected void appendSelect(SQLBuffer selectSQL, Object alias, Select sel, int idx) {
        boolean toCast;
        Object val = sel.getSelects().get(idx);
        boolean bl = toCast = val instanceof Lit && ((Lit)val).getParseType() != 8 && ((Lit)val).getParseType() != 9 && ((Lit)val).getParseType() != 10;
        if (toCast) {
            selectSQL.append("CAST(");
        }
        super.appendSelect(selectSQL, alias, sel, idx);
        if (toCast) {
            Class c = ((Lit)val).getType();
            int javaTypeCode = JavaTypes.getTypeCode((Class)c);
            int jdbcTypeCode = this.getJDBCType(javaTypeCode, false);
            String typeName = this.getTypeName(jdbcTypeCode);
            selectSQL.append(" AS " + typeName);
            if (String.class.equals((Object)c)) {
                selectSQL.append("(" + this.characterColumnSize + ")");
            }
            selectSQL.append(")");
        }
    }

    @Override
    protected ForeignKey newForeignKey(ResultSet fkMeta) throws SQLException {
        ForeignKey fk = super.newForeignKey(fkMeta);
        fk.setDeferred(false);
        return fk;
    }

    @Override
    public boolean isFatalException(int subtype, SQLException ex) {
        String errorState = ex.getSQLState();
        int errorCode = ex.getErrorCode();
        if (subtype == 1 && errorCode == 14529 && "HY000".equals(errorState)) {
            return false;
        }
        return super.isFatalException(subtype, ex);
    }
}

