/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.pages;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.BookmarkablePageLinkBuilder;
import org.apache.syncope.client.console.events.EventCategoryPanel;
import org.apache.syncope.client.console.events.SelectedEventsPanel;
import org.apache.syncope.client.console.pages.BasePage;
import org.apache.syncope.client.console.pages.Dashboard;
import org.apache.syncope.client.console.rest.AuditRestClient;
import org.apache.syncope.common.lib.audit.EventCategory;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.AuditLoggerName;
import org.apache.wicket.Component;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.spring.injection.annot.SpringBean;

public class Audit
extends BasePage {
    private static final long serialVersionUID = -1100228004207271271L;
    @SpringBean
    protected AuditRestClient auditRestClient;
    protected final IModel<List<EventCategory>> eventCategories = new LoadableDetachableModel<List<EventCategory>>(){
        private static final long serialVersionUID = 4659376149825914247L;

        protected List<EventCategory> load() {
            return Audit.this.auditRestClient.listEvents();
        }
    };

    public Audit(PageParameters parameters) {
        super(parameters);
        this.body.add(new Component[]{BookmarkablePageLinkBuilder.build("dashboard", "dashboardBr", Dashboard.class)});
        List events = this.auditRestClient.list().stream().filter(audit -> ((List)this.eventCategories.getObject()).stream().anyMatch(c -> audit.getType() == c.getType() && Objects.equals(audit.getCategory(), c.getCategory()) && Objects.equals(audit.getSubcategory(), c.getSubcategory()))).map(audit -> AuditLoggerName.buildEvent((AuditElements.EventCategoryType)audit.getType(), (String)audit.getCategory(), (String)audit.getSubcategory(), (String)audit.getEvent(), (AuditElements.Result)audit.getResult())).sorted().collect(Collectors.toList());
        WebMarkupContainer content = new WebMarkupContainer("content");
        content.setOutputMarkupId(true);
        Form form = new Form("auditForm");
        content.add(new Component[]{form});
        form.add(new Component[]{new EventCategoryPanel("auditPanel", (List)this.eventCategories.getObject(), (IModel)new ListModel(events)){
            private static final long serialVersionUID = 6113164334533550277L;

            @Override
            protected List<String> getListAuthRoles() {
                return List.of("AUDIT_LIST");
            }

            @Override
            protected List<String> getChangeAuthRoles() {
                return List.of("AUDIT_SET");
            }

            @Override
            public void onEventAction(IEvent<?> event) {
                if (event.getPayload() instanceof SelectedEventsPanel.EventSelectionChanged) {
                    SelectedEventsPanel.EventSelectionChanged eventSelectionChanged = (SelectedEventsPanel.EventSelectionChanged)event.getPayload();
                    eventSelectionChanged.getToBeRemoved().forEach(Audit.this.auditRestClient::delete);
                    eventSelectionChanged.getToBeAdded().forEach(Audit.this.auditRestClient::enable);
                }
            }
        }});
        this.body.add(new Component[]{content});
    }
}

