/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.catalyst.util.QuotingUtils;
import org.apache.spark.sql.connector.catalog.Identifier;

@Evolving
class IdentifierImpl
implements Identifier {
    private String[] namespace;
    private String name;

    IdentifierImpl(String[] namespace, String name) {
        this.namespace = Objects.requireNonNull(namespace, "Identifier namespace cannot be null");
        this.name = Objects.requireNonNull(name, "Identifier name cannot be null");
    }

    @Override
    public String[] namespace() {
        return this.namespace;
    }

    @Override
    public String name() {
        return this.name;
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(".");
        for (String p : this.namespace) {
            joiner.add(QuotingUtils.quoteIfNeeded(p));
        }
        joiner.add(QuotingUtils.quoteIfNeeded(this.name));
        return joiner.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentifierImpl)) {
            return false;
        }
        IdentifierImpl that = (IdentifierImpl)o;
        return Arrays.equals(this.namespace, that.namespace) && this.name.equals(that.name);
    }

    public int hashCode() {
        int result = Objects.hash(this.name);
        result = 31 * result + Arrays.hashCode(this.namespace);
        return result;
    }
}

