/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.org.apache.arrow.vector;

import org.sparkproject.org.apache.arrow.memory.ArrowBuf;
import org.sparkproject.org.apache.arrow.memory.BufferAllocator;
import org.sparkproject.org.apache.arrow.memory.util.ArrowBufPointer;
import org.sparkproject.org.apache.arrow.memory.util.LargeMemoryUtil;
import org.sparkproject.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import org.sparkproject.org.apache.arrow.util.Preconditions;
import org.sparkproject.org.apache.arrow.vector.BaseFixedWidthVector;
import org.sparkproject.org.apache.arrow.vector.BitVectorHelper;
import org.sparkproject.org.apache.arrow.vector.NullCheckingForGet;
import org.sparkproject.org.apache.arrow.vector.ValueIterableVector;
import org.sparkproject.org.apache.arrow.vector.ValueVector;
import org.sparkproject.org.apache.arrow.vector.complex.impl.BitReaderImpl;
import org.sparkproject.org.apache.arrow.vector.complex.reader.FieldReader;
import org.sparkproject.org.apache.arrow.vector.holders.BitHolder;
import org.sparkproject.org.apache.arrow.vector.holders.NullableBitHolder;
import org.sparkproject.org.apache.arrow.vector.types.Types;
import org.sparkproject.org.apache.arrow.vector.types.pojo.Field;
import org.sparkproject.org.apache.arrow.vector.types.pojo.FieldType;
import org.sparkproject.org.apache.arrow.vector.util.OversizedAllocationException;
import org.sparkproject.org.apache.arrow.vector.util.TransferPair;

public final class BitVector
extends BaseFixedWidthVector
implements ValueIterableVector<Boolean> {
    private static final int HASH_CODE_FOR_ZERO = 17;
    private static final int HASH_CODE_FOR_ONE = 19;

    public BitVector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.BIT.getType()), allocator);
    }

    public BitVector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public BitVector(Field field, BufferAllocator allocator) {
        super(field, allocator, 0);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new BitReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.BIT;
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        int size = BitVector.getValidityBufferSizeFromCount(valueCount);
        if ((long)size * 2L > MAX_ALLOCATION_SIZE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed");
        }
        this.lastValueCapacity = valueCount;
    }

    @Override
    protected int getValueBufferValueCapacity() {
        return LargeMemoryUtil.capAtMaxInt(this.valueBuffer.capacity() * 8L);
    }

    @Override
    public int getBufferSizeFor(int count) {
        if (count == 0) {
            return 0;
        }
        return 2 * BitVector.getValidityBufferSizeFromCount(count);
    }

    @Override
    public int getBufferSize() {
        return this.getBufferSizeFor(this.valueCount);
    }

    @Override
    public void splitAndTransferTo(int startIndex, int length, BaseFixedWidthVector target) {
        Preconditions.checkArgument(startIndex >= 0 && length >= 0 && startIndex + length <= this.valueCount, "Invalid parameters startIndex: %s, length: %s for valueCount: %s", (Object)startIndex, (Object)length, (Object)this.valueCount);
        this.compareTypes(target, "splitAndTransferTo");
        target.clear();
        target.validityBuffer = this.splitAndTransferBuffer(startIndex, length, this.validityBuffer, target.validityBuffer);
        target.valueBuffer = this.splitAndTransferBuffer(startIndex, length, this.valueBuffer, target.valueBuffer);
        target.refreshValueCapacity();
        target.setValueCount(length);
    }

    private ArrowBuf splitAndTransferBuffer(int startIndex, int length, ArrowBuf sourceBuffer, ArrowBuf destBuffer) {
        int firstByteSource = BitVectorHelper.byteIndex(startIndex);
        int lastByteSource = BitVectorHelper.byteIndex(this.valueCount - 1);
        int byteSizeTarget = BitVector.getValidityBufferSizeFromCount(length);
        int offset = startIndex % 8;
        if (length > 0) {
            if (offset == 0) {
                if (destBuffer != null) {
                    destBuffer.getReferenceManager().release();
                }
                destBuffer = sourceBuffer.slice(firstByteSource, byteSizeTarget);
                destBuffer.getReferenceManager().retain(1);
            } else {
                byte b1;
                destBuffer = this.allocator.buffer(byteSizeTarget);
                destBuffer.readerIndex(0L);
                destBuffer.setZero(0L, destBuffer.capacity());
                for (int i = 0; i < byteSizeTarget - 1; ++i) {
                    byte b12 = BitVectorHelper.getBitsFromCurrentByte(sourceBuffer, firstByteSource + i, offset);
                    byte b2 = BitVectorHelper.getBitsFromNextByte(sourceBuffer, firstByteSource + i + 1, offset);
                    destBuffer.setByte((long)i, b12 + b2);
                }
                if (firstByteSource + byteSizeTarget - 1 < lastByteSource) {
                    b1 = BitVectorHelper.getBitsFromCurrentByte(sourceBuffer, firstByteSource + byteSizeTarget - 1, offset);
                    byte b2 = BitVectorHelper.getBitsFromNextByte(sourceBuffer, firstByteSource + byteSizeTarget, offset);
                    destBuffer.setByte((long)(byteSizeTarget - 1), b1 + b2);
                } else {
                    b1 = BitVectorHelper.getBitsFromCurrentByte(sourceBuffer, firstByteSource + byteSizeTarget - 1, offset);
                    destBuffer.setByte((long)(byteSizeTarget - 1), b1);
                }
            }
        }
        return destBuffer;
    }

    private int getBit(int index) {
        int byteIndex = index >> 3;
        byte b = this.valueBuffer.getByte(byteIndex);
        int bitIndex = index & 7;
        return b >> bitIndex & 1;
    }

    public int get(int index) throws IllegalStateException {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.getBit(index);
    }

    public void get(int index, NullableBitHolder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.getBit(index);
    }

    @Override
    public Boolean getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.getBit(index) != 0;
    }

    @Override
    public void copyFrom(int fromIndex, int thisIndex, ValueVector from) {
        boolean fromIsSet;
        Preconditions.checkArgument(this.getMinorType() == from.getMinorType());
        boolean bl = fromIsSet = BitVectorHelper.get(from.getValidityBuffer(), fromIndex) != 0;
        if (fromIsSet) {
            BitVectorHelper.setBit(this.validityBuffer, thisIndex);
            BitVectorHelper.setValidityBit(this.valueBuffer, thisIndex, ((BitVector)from).getBit(fromIndex));
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, thisIndex);
        }
    }

    public void set(int index, int value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        if (value != 0) {
            BitVectorHelper.setBit(this.valueBuffer, index);
        } else {
            BitVectorHelper.unsetBit(this.valueBuffer, index);
        }
    }

    public void set(int index, NullableBitHolder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            if (holder.value != 0) {
                BitVectorHelper.setBit(this.valueBuffer, index);
            } else {
                BitVectorHelper.unsetBit(this.valueBuffer, index);
            }
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, BitHolder holder) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        if (holder.value != 0) {
            BitVectorHelper.setBit(this.valueBuffer, index);
        } else {
            BitVectorHelper.unsetBit(this.valueBuffer, index);
        }
    }

    public void setSafe(int index, int value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableBitHolder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, BitHolder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void set(int index, int isSet, int value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setSafe(int index, int isSet, int value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    public void setToOne(int index) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        BitVectorHelper.setBit(this.valueBuffer, index);
    }

    public void setSafeToOne(int index) {
        this.handleSafe(index);
        this.setToOne(index);
    }

    @Override
    public ArrowBufPointer getDataPointer(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBufPointer getDataPointer(int index, ArrowBufPointer reuse) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode(int index) {
        if (this.isNull(index)) {
            return 0;
        }
        if (this.get(index) == 0) {
            return 17;
        }
        return 19;
    }

    @Override
    public int hashCode(int index, ArrowBufHasher hasher) {
        return this.hashCode(index);
    }

    public void setRangeToOne(int firstBitIndex, int count) {
        int startByteIndex = BitVectorHelper.byteIndex(firstBitIndex);
        int lastBitIndex = firstBitIndex + count;
        int endByteIndex = BitVectorHelper.byteIndex(lastBitIndex);
        int startByteBitIndex = BitVectorHelper.bitIndex(firstBitIndex);
        int endBytebitIndex = BitVectorHelper.bitIndex(lastBitIndex);
        if (count < 8 && startByteIndex == endByteIndex) {
            byte bitMask = 0;
            for (int i = startByteBitIndex; i < endBytebitIndex; ++i) {
                bitMask = (byte)(bitMask | (byte)(1L << i));
            }
            BitVectorHelper.setBitMaskedByte(this.validityBuffer, startByteIndex, bitMask);
            BitVectorHelper.setBitMaskedByte(this.valueBuffer, startByteIndex, bitMask);
        } else {
            if (startByteBitIndex != 0) {
                byte bitMask = (byte)(255L << startByteBitIndex);
                BitVectorHelper.setBitMaskedByte(this.validityBuffer, startByteIndex, bitMask);
                BitVectorHelper.setBitMaskedByte(this.valueBuffer, startByteIndex, bitMask);
                ++startByteIndex;
            }
            this.validityBuffer.setOne(startByteIndex, endByteIndex - startByteIndex);
            this.valueBuffer.setOne(startByteIndex, endByteIndex - startByteIndex);
            if (endBytebitIndex != 0) {
                int byteIndex = BitVectorHelper.byteIndex(lastBitIndex - endBytebitIndex);
                byte bitMask = (byte)(255L >>> (8 - endBytebitIndex & 7));
                BitVectorHelper.setBitMaskedByte(this.validityBuffer, byteIndex, bitMask);
                BitVectorHelper.setBitMaskedByte(this.valueBuffer, byteIndex, bitMask);
            }
        }
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new TransferImpl(field, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((BitVector)to);
    }

    private class TransferImpl
    implements TransferPair {
        BitVector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new BitVector(ref, BitVector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(Field field, BufferAllocator allocator) {
            this.to = new BitVector(field, allocator);
        }

        public TransferImpl(BitVector to) {
            this.to = to;
        }

        @Override
        public BitVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            BitVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            BitVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, BitVector.this);
        }
    }
}

