/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceRequestAllocationResult;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceToleration;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceTolerationBuilder;
import io.fabric8.kubernetes.api.model.resource.v1beta1.DeviceTolerationFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class DeviceRequestAllocationResultFluent<A extends DeviceRequestAllocationResultFluent<A>>
extends BaseFluent<A> {
    private Boolean adminAccess;
    private String device;
    private String driver;
    private String pool;
    private String request;
    private ArrayList<DeviceTolerationBuilder> tolerations = new ArrayList();
    private Map<String, Object> additionalProperties;

    public DeviceRequestAllocationResultFluent() {
    }

    public DeviceRequestAllocationResultFluent(DeviceRequestAllocationResult instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(DeviceRequestAllocationResult instance) {
        DeviceRequestAllocationResult deviceRequestAllocationResult = instance = instance != null ? instance : new DeviceRequestAllocationResult();
        if (instance != null) {
            this.withAdminAccess(instance.getAdminAccess());
            this.withDevice(instance.getDevice());
            this.withDriver(instance.getDriver());
            this.withPool(instance.getPool());
            this.withRequest(instance.getRequest());
            this.withTolerations(instance.getTolerations());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getAdminAccess() {
        return this.adminAccess;
    }

    public A withAdminAccess(Boolean adminAccess) {
        this.adminAccess = adminAccess;
        return (A)((Object)this);
    }

    public boolean hasAdminAccess() {
        return this.adminAccess != null;
    }

    public String getDevice() {
        return this.device;
    }

    public A withDevice(String device) {
        this.device = device;
        return (A)((Object)this);
    }

    public boolean hasDevice() {
        return this.device != null;
    }

    public String getDriver() {
        return this.driver;
    }

    public A withDriver(String driver) {
        this.driver = driver;
        return (A)((Object)this);
    }

    public boolean hasDriver() {
        return this.driver != null;
    }

    public String getPool() {
        return this.pool;
    }

    public A withPool(String pool) {
        this.pool = pool;
        return (A)((Object)this);
    }

    public boolean hasPool() {
        return this.pool != null;
    }

    public String getRequest() {
        return this.request;
    }

    public A withRequest(String request) {
        this.request = request;
        return (A)((Object)this);
    }

    public boolean hasRequest() {
        return this.request != null;
    }

    public A addToTolerations(int index, DeviceToleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
        if (index < 0 || index >= this.tolerations.size()) {
            this._visitables.get((Object)"tolerations").add(builder);
            this.tolerations.add(builder);
        } else {
            this._visitables.get((Object)"tolerations").add(builder);
            this.tolerations.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToTolerations(int index, DeviceToleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
        if (index < 0 || index >= this.tolerations.size()) {
            this._visitables.get((Object)"tolerations").add(builder);
            this.tolerations.add(builder);
        } else {
            this._visitables.get((Object)"tolerations").add(builder);
            this.tolerations.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToTolerations(DeviceToleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (DeviceToleration item : items) {
            DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
            this._visitables.get((Object)"tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToTolerations(Collection<DeviceToleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList();
        }
        for (DeviceToleration item : items) {
            DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
            this._visitables.get((Object)"tolerations").add(builder);
            this.tolerations.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromTolerations(DeviceToleration ... items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (DeviceToleration item : items) {
            DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
            this._visitables.get((Object)"tolerations").remove((Object)builder);
            this.tolerations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTolerations(Collection<DeviceToleration> items) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        for (DeviceToleration item : items) {
            DeviceTolerationBuilder builder = new DeviceTolerationBuilder(item);
            this._visitables.get((Object)"tolerations").remove((Object)builder);
            this.tolerations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromTolerations(Predicate<DeviceTolerationBuilder> predicate) {
        if (this.tolerations == null) {
            return (A)((Object)this);
        }
        Iterator<DeviceTolerationBuilder> each = this.tolerations.iterator();
        List visitables = this._visitables.get((Object)"tolerations");
        while (each.hasNext()) {
            DeviceTolerationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<DeviceToleration> buildTolerations() {
        return this.tolerations != null ? DeviceRequestAllocationResultFluent.build(this.tolerations) : null;
    }

    public DeviceToleration buildToleration(int index) {
        return this.tolerations.get(index).build();
    }

    public DeviceToleration buildFirstToleration() {
        return this.tolerations.get(0).build();
    }

    public DeviceToleration buildLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1).build();
    }

    public DeviceToleration buildMatchingToleration(Predicate<DeviceTolerationBuilder> predicate) {
        for (DeviceTolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingToleration(Predicate<DeviceTolerationBuilder> predicate) {
        for (DeviceTolerationBuilder item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTolerations(List<DeviceToleration> tolerations) {
        if (this.tolerations != null) {
            this._visitables.get((Object)"tolerations").clear();
        }
        if (tolerations != null) {
            this.tolerations = new ArrayList();
            for (DeviceToleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)((Object)this);
    }

    public A withTolerations(DeviceToleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove((Object)"tolerations");
        }
        if (tolerations != null) {
            for (DeviceToleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new DeviceToleration(effect, key, operator, tolerationSeconds, value));
    }

    public TolerationsNested<A> addNewToleration() {
        return new TolerationsNested(-1, null);
    }

    public TolerationsNested<A> addNewTolerationLike(DeviceToleration item) {
        return new TolerationsNested(-1, item);
    }

    public TolerationsNested<A> setNewTolerationLike(int index, DeviceToleration item) {
        return new TolerationsNested(index, item);
    }

    public TolerationsNested<A> editToleration(int index) {
        if (this.tolerations.size() <= index) {
            throw new RuntimeException("Can't edit tolerations. Index exceeds size.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public TolerationsNested<A> editFirstToleration() {
        if (this.tolerations.size() == 0) {
            throw new RuntimeException("Can't edit first tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(0, this.buildToleration(0));
    }

    public TolerationsNested<A> editLastToleration() {
        int index = this.tolerations.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tolerations. The list is empty.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public TolerationsNested<A> editMatchingToleration(Predicate<DeviceTolerationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tolerations.size(); ++i) {
            if (!predicate.test(this.tolerations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tolerations. No match found.");
        }
        return this.setNewTolerationLike(index, this.buildToleration(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DeviceRequestAllocationResultFluent that = (DeviceRequestAllocationResultFluent)((Object)o);
        if (!Objects.equals(this.adminAccess, that.adminAccess)) {
            return false;
        }
        if (!Objects.equals(this.device, that.device)) {
            return false;
        }
        if (!Objects.equals(this.driver, that.driver)) {
            return false;
        }
        if (!Objects.equals(this.pool, that.pool)) {
            return false;
        }
        if (!Objects.equals(this.request, that.request)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.adminAccess, this.device, this.driver, this.pool, this.request, this.tolerations, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.adminAccess != null) {
            sb.append("adminAccess:");
            sb.append(this.adminAccess + ",");
        }
        if (this.device != null) {
            sb.append("device:");
            sb.append(this.device + ",");
        }
        if (this.driver != null) {
            sb.append("driver:");
            sb.append(this.driver + ",");
        }
        if (this.pool != null) {
            sb.append("pool:");
            sb.append(this.pool + ",");
        }
        if (this.request != null) {
            sb.append("request:");
            sb.append(this.request + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(String.valueOf(this.tolerations) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAdminAccess() {
        return this.withAdminAccess(true);
    }

    public class TolerationsNested<N>
    extends DeviceTolerationFluent<TolerationsNested<N>>
    implements Nested<N> {
        DeviceTolerationBuilder builder;
        int index;

        TolerationsNested(int index, DeviceToleration item) {
            this.index = index;
            this.builder = new DeviceTolerationBuilder(this, item);
        }

        public N and() {
            return (N)DeviceRequestAllocationResultFluent.this.setToTolerations(this.index, this.builder.build());
        }

        public N endToleration() {
            return this.and();
        }
    }
}

