/*
 * Decompiled with CFR 0.152.
 */
package spire.math;

import algebra.ring.Field;
import java.io.Serializable;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.math.BigDecimal;
import scala.math.BigDecimal$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;
import spire.macros.ArithmeticOverflowException;
import spire.math.DecimalNumber;
import spire.math.FloatNumber;
import spire.math.IntNumber;
import spire.math.Number;
import spire.math.NumberTag;
import spire.math.Rational;
import spire.math.RationalInstances;
import spire.math.RationalNumber;
import spire.math.SafeLong;
import spire.math.SafeLong$;
import spire.math.SafeLongBigInteger;
import spire.math.SafeLongLong;
import spire.math.package$;

public final class Rational$
implements RationalInstances,
Serializable {
    public static final Rational$ MODULE$ = new Rational$();
    private static final Regex RationalString;
    private static final Regex IntegerString;
    private static final Rational zero;
    private static final Rational one;
    private static final BigInt Two31m1;
    private static final BigInt Two31m0;
    private static final BigInt Two63m1;
    private static final BigInt Two63m0;
    private static Field<Rational> RationalAlgebra;
    private static NumberTag<Rational> RationalTag;

    static {
        RationalInstances.$init$(MODULE$);
        RationalString = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(-?\\d+)/(-?\\d+)$"));
        IntegerString = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^(-?\\d+)$"));
        zero = MODULE$.spire$math$Rational$$longRational(0L, 1L);
        one = MODULE$.spire$math$Rational$$longRational(1L, 1L);
        Two31m1 = scala.package$.MODULE$.BigInt().apply(Integer.MAX_VALUE);
        Two31m0 = scala.package$.MODULE$.BigInt().apply(Integer.MIN_VALUE).unary_$minus();
        Two63m1 = scala.package$.MODULE$.BigInt().apply(Long.MAX_VALUE);
        Two63m0 = scala.package$.MODULE$.BigInt().apply(Long.MIN_VALUE).unary_$minus();
    }

    @Override
    public final Field<Rational> RationalAlgebra() {
        return RationalAlgebra;
    }

    @Override
    public final NumberTag<Rational> RationalTag() {
        return RationalTag;
    }

    @Override
    public final void spire$math$RationalInstances$_setter_$RationalAlgebra_$eq(Field<Rational> x$1) {
        RationalAlgebra = x$1;
    }

    @Override
    public final void spire$math$RationalInstances$_setter_$RationalTag_$eq(NumberTag<Rational> x$1) {
        RationalTag = x$1;
    }

    private Regex RationalString() {
        return RationalString;
    }

    private Regex IntegerString() {
        return IntegerString;
    }

    public Rational zero() {
        return zero;
    }

    public Rational one() {
        return one;
    }

    public BigInt Two31m1() {
        return Two31m1;
    }

    public BigInt Two31m0() {
        return Two31m0;
    }

    public BigInt Two63m1() {
        return Two63m1;
    }

    public BigInt Two63m0() {
        return Two63m0;
    }

    public double toDouble(SafeLong n, SafeLong d) {
        double d2;
        int n2 = n.signum();
        switch (n2) {
            case 0: {
                d2 = 0.0;
                break;
            }
            case -1: {
                d2 = -this.toDouble(n.unary_$minus(), d);
                break;
            }
            case 1: {
                int sharedLength = Math.min(n.bitLength(), d.bitLength());
                int dLowerLength = d.bitLength() - sharedLength;
                SafeLong nShared = n.$greater$greater(n.bitLength() - sharedLength);
                SafeLong dShared = d.$greater$greater(dLowerLength);
                int addBit = nShared.$less((Object)dShared) || BoxesRunTime.equalsNumNum((java.lang.Number)((Object)nShared), (java.lang.Number)((Object)dShared)) && d.toBigInteger().getLowestSetBit() < dLowerLength ? 1 : 0;
                int e = d.bitLength() - n.bitLength() + addBit;
                SafeLong ln = n.$less$less(53 + e);
                long lm = ln.$div(d).toLong();
                long m = (lm >> 1) + (lm & 1L) & 0xFFFFFFFFFFFFFL;
                long bits = m | 1023L - (long)e << 52;
                d2 = Double.longBitsToDouble(bits);
                break;
            }
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n2));
            }
        }
        return d2;
    }

    public Rational apply(BigInt n, BigInt d) {
        return this.apply(SafeLong$.MODULE$.apply(n), SafeLong$.MODULE$.apply(d));
    }

    public Rational apply(long n, long d) {
        if (d == 0L) {
            throw new IllegalArgumentException("0 denominator");
        }
        return d > 0L ? this.build0$1(n, d) : (n == Long.MIN_VALUE || d == Long.MIN_VALUE ? this.apply(scala.package$.MODULE$.BigInt().apply(n).unary_$minus(), scala.package$.MODULE$.BigInt().apply(d).unary_$minus()) : this.build0$1(-n, -d));
    }

    public Rational buildWithDiv(long num, long ngcd, long rd, long lden) {
        Rational rational;
        long n = num / ngcd;
        long d = rd / ngcd;
        try {
            rational = this.checked$attempt$macro$1$2(n, lden, d);
        }
        catch (ArithmeticException arithmeticException) {
            rational = this.apply(SafeLong$.MODULE$.apply(n), SafeLong$.MODULE$.apply(lden).$times(d));
        }
        return rational;
    }

    public Rational apply(SafeLong n, SafeLong d) {
        Rational rational;
        block11: {
            Rational rational2;
            while (true) {
                if (d.isZero()) {
                    throw new IllegalArgumentException("0 denominator");
                }
                if (n.isValidLong() && d.isValidLong()) {
                    rational = this.apply(n.toLong(), d.toLong());
                    break block11;
                }
                if (d.signum() >= 0) break;
                d = d.unary_$minus();
                n = n.unary_$minus();
            }
            SafeLong g = n.gcd(d);
            SafeLong safeLong = n.$div(g);
            if (safeLong instanceof SafeLongLong) {
                Rational rational3;
                SafeLongLong safeLongLong = (SafeLongLong)safeLong;
                long x = safeLongLong.x();
                SafeLong safeLong2 = d.$div(g);
                if (safeLong2 instanceof SafeLongLong) {
                    SafeLongLong safeLongLong2 = (SafeLongLong)safeLong2;
                    long y = safeLongLong2.x();
                    rational3 = this.spire$math$Rational$$longRational(x, y);
                } else if (safeLong2 instanceof SafeLongBigInteger) {
                    SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)safeLong2;
                    rational3 = this.spire$math$Rational$$bigRational(SafeLong$.MODULE$.apply(x), safeLongBigInteger);
                } else {
                    throw new MatchError((Object)safeLong2);
                }
                rational2 = rational3;
            } else if (safeLong instanceof SafeLongBigInteger) {
                SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)safeLong;
                rational2 = this.spire$math$Rational$$bigRational(safeLongBigInteger, d.$div(g));
            } else {
                throw new MatchError((Object)safeLong);
            }
            rational = rational2;
        }
        return rational;
    }

    public Rational apply(int x) {
        return x == 0 ? this.zero() : this.spire$math$Rational$$longRational(x, 1L);
    }

    public Rational apply(long x) {
        return x == 0L ? this.zero() : this.spire$math$Rational$$longRational(x, 1L);
    }

    public Rational apply(BigInt x) {
        return this.apply(SafeLong$.MODULE$.apply(x), SafeLong$.MODULE$.one());
    }

    public Rational apply(float x) {
        return this.apply((double)x);
    }

    public Rational apply(double x) {
        Rational rational;
        if (x == 0.0) {
            rational = this.zero();
        } else {
            long bits = Double.doubleToLongBits(x);
            long value = bits >> 63 < 0L ? -(bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L) : bits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
            int exp = (int)(bits >> 52 & 0x7FFL) - 1075;
            rational = exp > 10 ? this.apply(SafeLong$.MODULE$.apply(value).$less$less(exp), SafeLong$.MODULE$.one()) : (exp >= 0 ? this.apply(value << exp, 1L) : (exp >= -52 && ((-1L << -exp ^ 0xFFFFFFFFFFFFFFFFL) & value) == 0L ? this.apply(value >> -exp, 1L) : this.apply(SafeLong$.MODULE$.apply(value), SafeLong$.MODULE$.one().$less$less(-exp))));
        }
        return rational;
    }

    public Rational apply(BigDecimal x) {
        Rational rational;
        if (x.ulp().$greater$eq((Object)BigDecimal$.MODULE$.int2bigDecimal(1))) {
            rational = this.apply(x.toBigInt(), BigInt$.MODULE$.int2bigInt(1));
        } else {
            BigInt n = x.$div(x.ulp()).toBigInt();
            BigInt d = scala.package$.MODULE$.BigDecimal().apply(1.0).$div(x.ulp()).toBigInt();
            rational = this.apply(n, d);
        }
        return rational;
    }

    public Rational apply(String r) {
        Option option;
        Rational rational;
        Option option2;
        String string = r;
        if (string != null && !(option2 = this.RationalString().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((List)option2.get()).lengthCompare(2) == 0) {
            String n = (String)((LinearSeqOps)option2.get()).apply(0);
            String d = (String)((LinearSeqOps)option2.get()).apply(1);
            rational = this.apply(SafeLong$.MODULE$.apply(n), SafeLong$.MODULE$.apply(d));
        } else if (string != null && !(option = this.IntegerString().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0) {
            String n = (String)((LinearSeqOps)option.get()).apply(0);
            rational = this.apply(SafeLong$.MODULE$.apply(n));
        } else {
            Rational rational2;
            try {
                rational2 = this.apply(scala.package$.MODULE$.BigDecimal().apply(string));
            }
            catch (NumberFormatException nfe) {
                throw new NumberFormatException(new StringBuilder(18).append("For input string: ").append(string).toString());
            }
            rational = rational2;
        }
        return rational;
    }

    public Rational apply(SafeLong n) {
        Rational rational;
        SafeLong safeLong = n;
        if (safeLong instanceof SafeLongLong) {
            SafeLongLong safeLongLong = (SafeLongLong)safeLong;
            long x = safeLongLong.x();
            rational = x == 0L ? this.zero() : this.spire$math$Rational$$longRational(x, 1L);
        } else if (safeLong instanceof SafeLongBigInteger) {
            SafeLongBigInteger safeLongBigInteger = (SafeLongBigInteger)safeLong;
            rational = this.spire$math$Rational$$bigRational(safeLongBigInteger, SafeLong$.MODULE$.one());
        } else {
            throw new MatchError((Object)safeLong);
        }
        return rational;
    }

    public Rational apply(Number x) {
        Rational rational;
        Number number = x;
        if (number instanceof RationalNumber) {
            Rational n;
            RationalNumber rationalNumber = (RationalNumber)number;
            rational = n = rationalNumber.n();
        } else if (number instanceof IntNumber) {
            IntNumber intNumber = (IntNumber)number;
            SafeLong n = intNumber.n();
            rational = this.apply(n);
        } else if (number instanceof FloatNumber) {
            FloatNumber floatNumber = (FloatNumber)number;
            double n = floatNumber.n();
            rational = this.apply(n);
        } else if (number instanceof DecimalNumber) {
            DecimalNumber decimalNumber = (DecimalNumber)number;
            BigDecimal n = decimalNumber.n();
            rational = this.apply(n);
        } else {
            throw new MatchError((Object)number);
        }
        return rational;
    }

    public Rational.LongRational spire$math$Rational$$longRational(long n, long d) {
        return new Rational.LongRational(n, d);
    }

    public Rational.BigRational spire$math$Rational$$bigRational(SafeLong n, SafeLong d) {
        return new Rational.BigRational(n, d.isOne() ? SafeLong$.MODULE$.one() : d);
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Rational$.class);
    }

    private final Rational build0$1(long n, long d) {
        long divisor;
        return n == 0L ? this.zero() : ((divisor = package$.MODULE$.gcd(n, d)) == 1L ? this.spire$math$Rational$$longRational(n, d) : this.spire$math$Rational$$longRational(n / divisor, d / divisor));
    }

    private static final Rational checked$fallback$macro$2$2() {
        throw new ArithmeticOverflowException();
    }

    private final Rational checked$attempt$macro$1$2(long n$1, long lden$1, long d$1) {
        long z$macro$3 = lden$1 * d$1;
        if (lden$1 != 0L && (d$1 != z$macro$3 / lden$1 || lden$1 == -1L && d$1 == Long.MIN_VALUE)) {
            return Rational$.checked$fallback$macro$2$2();
        }
        return this.apply(n$1, z$macro$3);
    }

    private Rational$() {
    }
}

