/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DynamicByteArrayOutputStream;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.PhysicalPageOperation;
import org.apache.derby.shared.common.error.StandardException;

public final class PurgeOperation
extends PhysicalPageOperation {
    protected int slot;
    protected int num_rows;
    protected int[] recordIds;
    protected transient ByteArray preparedLog;

    PurgeOperation(RawTransaction rawTransaction, BasePage basePage, int n, int n2, int[] nArray, boolean bl) throws StandardException {
        super(basePage);
        this.slot = n;
        this.num_rows = n2;
        this.recordIds = nArray;
        try {
            this.writeOptionalDataToBuffer(rawTransaction, bl);
        }
        catch (IOException iOException) {
            throw StandardException.newException((String)"XSDA4.S", (Throwable)iOException, (Object[])new Object[0]);
        }
    }

    public PurgeOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        CompressedNumber.writeInt(objectOutput, this.slot);
        CompressedNumber.writeInt(objectOutput, this.num_rows);
        for (int i = 0; i < this.num_rows; ++i) {
            CompressedNumber.writeInt(objectOutput, this.recordIds[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.slot = CompressedNumber.readInt(objectInput);
        this.num_rows = CompressedNumber.readInt(objectInput);
        this.recordIds = new int[this.num_rows];
        for (int i = 0; i < this.num_rows; ++i) {
            this.recordIds[i] = CompressedNumber.readInt(objectInput);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 106;
    }

    @Override
    public void doMe(Transaction transaction, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        for (int i = this.num_rows - 1; i >= 0; --i) {
            this.page.purgeRecord(logInstant, this.slot + i, this.recordIds[i]);
        }
    }

    @Override
    public void undoMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        for (int i = 0; i < this.num_rows; ++i) {
            basePage.storeRecord(logInstant, this.slot + i, true, limitObjectInput);
        }
        basePage.setAuxObject(null);
    }

    @Override
    public void restoreMe(Transaction transaction, BasePage basePage, LogInstant logInstant, LimitObjectInput limitObjectInput) throws StandardException, IOException {
        this.undoMe(transaction, basePage, logInstant, limitObjectInput);
    }

    @Override
    public ByteArray getPreparedLog() {
        return this.preparedLog;
    }

    private void writeOptionalDataToBuffer(RawTransaction rawTransaction, boolean bl) throws StandardException, IOException {
        int n;
        DynamicByteArrayOutputStream dynamicByteArrayOutputStream = rawTransaction.getLogBuffer();
        int n2 = dynamicByteArrayOutputStream.getPosition();
        for (n = 0; n < this.num_rows; ++n) {
            if (bl) {
                this.page.logRecord(n + this.slot, 0, this.recordIds[n], null, dynamicByteArrayOutputStream, null);
                continue;
            }
            this.page.logRecord(n + this.slot, 2, this.recordIds[n], null, dynamicByteArrayOutputStream, null);
        }
        n = dynamicByteArrayOutputStream.getPosition() - n2;
        dynamicByteArrayOutputStream.setPosition(n2);
        this.preparedLog = new ByteArray(dynamicByteArrayOutputStream.getByteArray(), n2, n);
    }

    @Override
    public String toString() {
        return null;
    }
}

