/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.expressions.BinaryMathExpression;
import org.apache.spark.sql.catalyst.expressions.EulerNumber;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Logarithm$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(base, expr) - Returns the logarithm of `expr` with `base`.", examples="\n    Examples:\n      > SELECT _FUNC_(10, 100);\n       2.0\n  ", since="1.5.0", group="math_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mf\u0001\u0002\u000f\u001e\u0001*B\u0001\"\u0011\u0001\u0003\u0016\u0004%\tA\u0011\u0005\t\r\u0002\u0011\t\u0012)A\u0005\u0007\"Aq\t\u0001BK\u0002\u0013\u0005!\t\u0003\u0005I\u0001\tE\t\u0015!\u0003D\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015I\u0005\u0001\"\u0001O\u0011\u0015\t\u0006\u0001\"\u0011S\u0011\u00151\u0006\u0001\"\u0015X\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015q\u0007\u0001\"\u0015p\u0011\u001d!\b!!A\u0005\u0002UDq\u0001\u001f\u0001\u0012\u0002\u0013\u0005\u0011\u0010\u0003\u0005\u0002\n\u0001\t\n\u0011\"\u0001z\u0011%\tY\u0001AA\u0001\n\u0003\ni\u0001C\u0005\u0002 \u0001\t\t\u0011\"\u0001\u0002\"!I\u0011\u0011\u0006\u0001\u0002\u0002\u0013\u0005\u00111\u0006\u0005\n\u0003c\u0001\u0011\u0011!C!\u0003gA\u0011\"!\u0011\u0001\u0003\u0003%\t!a\u0011\t\u0013\u0005\u001d\u0003!!A\u0005B\u0005%\u0003\"CA'\u0001\u0005\u0005I\u0011IA(\u000f%\t\u0019(HA\u0001\u0012\u0003\t)H\u0002\u0005\u001d;\u0005\u0005\t\u0012AA<\u0011\u0019Ie\u0003\"\u0001\u0002\u0010\"I\u0011\u0011\u0013\f\u0002\u0002\u0013\u0015\u00131\u0013\u0005\n\u0003+3\u0012\u0011!CA\u0003/C\u0011\"!(\u0017\u0003\u0003%\t)a(\t\u0013\u0005Ef#!A\u0005\n\u0005M&!\u0003'pO\u0006\u0014\u0018\u000e\u001e5n\u0015\tqr$A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0011\"\u0003!\u0019\u0017\r^1msN$(B\u0001\u0012$\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003I\u0015\nQa\u001d9be.T!AJ\u0014\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0013aA8sO\u000e\u00011\u0003\u0002\u0001,_U\u0002\"\u0001L\u0017\u000e\u0003uI!AL\u000f\u0003)\tKg.\u0019:z\u001b\u0006$\b.\u0012=qe\u0016\u001c8/[8o!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u000e \u000f\u0005]bdB\u0001\u001d<\u001b\u0005I$B\u0001\u001e*\u0003\u0019a$o\\8u}%\t!'\u0003\u0002>c\u00059\u0001/Y2lC\u001e,\u0017BA A\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\ti\u0014'\u0001\u0003mK\u001a$X#A\"\u0011\u00051\"\u0015BA#\u001e\u0005))\u0005\u0010\u001d:fgNLwN\\\u0001\u0006Y\u00164G\u000fI\u0001\u0006e&<\u0007\u000e^\u0001\u0007e&<\u0007\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\rYE*\u0014\t\u0003Y\u0001AQ!Q\u0003A\u0002\rCQaR\u0003A\u0002\r#\"aS(\t\u000bA3\u0001\u0019A\"\u0002\u000b\rD\u0017\u000e\u001c3\u0002\u00119,H\u000e\\1cY\u0016,\u0012a\u0015\t\u0003aQK!!V\u0019\u0003\u000f\t{w\u000e\\3b]\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0019\u0001lW/\u0011\u0005AJ\u0016B\u0001.2\u0005\r\te.\u001f\u0005\u00069\"\u0001\r\u0001W\u0001\u0007S:\u0004X\u000f^\u0019\t\u000byC\u0001\u0019\u0001-\u0002\r%t\u0007/\u001e;3\u0003%!wnR3o\u0007>$W\rF\u0002bO2\u0004\"AY3\u000e\u0003\rT!\u0001Z\u000f\u0002\u000f\r|G-Z4f]&\u0011am\u0019\u0002\t\u000bb\u0004(oQ8eK\")\u0001.\u0003a\u0001S\u0006\u00191\r\u001e=\u0011\u0005\tT\u0017BA6d\u00059\u0019u\u000eZ3hK:\u001cuN\u001c;fqRDQ!\\\u0005A\u0002\u0005\f!!\u001a<\u0002/]LG\u000f\u001b(fo\u000eC\u0017\u000e\u001c3sK:Le\u000e^3s]\u0006dGcA&qe\")\u0011O\u0003a\u0001\u0007\u00069a.Z<MK\u001a$\b\"B:\u000b\u0001\u0004\u0019\u0015\u0001\u00038foJKw\r\u001b;\u0002\t\r|\u0007/\u001f\u000b\u0004\u0017Z<\bbB!\f!\u0003\u0005\ra\u0011\u0005\b\u000f.\u0001\n\u00111\u0001D\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012A\u001f\u0016\u0003\u0007n\\\u0013\u0001 \t\u0004{\u0006\u0015Q\"\u0001@\u000b\u0007}\f\t!A\u0005v]\u000eDWmY6fI*\u0019\u00111A\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.C\u0002\u0002\by\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\b!\u0011\t\t\"a\u0007\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\tA\u0001\\1oO*\u0011\u0011\u0011D\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u001e\u0005M!AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002$A\u0019\u0001'!\n\n\u0007\u0005\u001d\u0012GA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000fF\u0002Y\u0003[A\u0011\"a\f\u0011\u0003\u0003\u0005\r!a\t\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u0004E\u0003\u00028\u0005u\u0002,\u0004\u0002\u0002:)\u0019\u00111H\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002@\u0005e\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2aUA#\u0011!\tyCEA\u0001\u0002\u0004A\u0016A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a\u0004\u0002L!I\u0011qF\n\u0002\u0002\u0003\u0007\u00111E\u0001\u0007KF,\u0018\r\\:\u0015\u0007M\u000b\t\u0006\u0003\u0005\u00020Q\t\t\u00111\u0001YQM\u0001\u0011QKA.\u0003;\n\t'a\u0019\u0002h\u0005%\u0014QNA8!\ra\u0013qK\u0005\u0004\u00033j\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003?\n\u0011i\u0018$V\u001d\u000e{\u0006FY1tK2\u0002S\r\u001f9sS\u0001j\u0003EU3ukJt7\u000f\t;iK\u0002bwnZ1sSRDW\u000eI8gA\u0001,\u0007\u0010\u001d:aA]LG\u000f\u001b\u0011aE\u0006\u001cX\r\u0019\u0018\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!!\u001a\u0002y)\u0001\u0003\u0005\t\u0011Fq\u0006l\u0007\u000f\\3tu)\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013\u0007\r\u0017!cA\u0002\u0014f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u00113]AR\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003W\nQ!\r\u00186]A\nQa\u001a:pkB\f#!!\u001d\u0002\u00155\fG\u000f[0gk:\u001c7/A\u0005M_\u001e\f'/\u001b;i[B\u0011AFF\n\u0006-\u0005e\u0014Q\u0011\t\b\u0003w\n\tiQ\"L\u001b\t\tiHC\u0002\u0002\u0000E\nqA];oi&lW-\u0003\u0003\u0002\u0004\u0006u$!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oeA!\u0011qQAG\u001b\t\tII\u0003\u0003\u0002\f\u0006]\u0011AA5p\u0013\ry\u0014\u0011\u0012\u000b\u0003\u0003k\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u001f\tQ!\u00199qYf$RaSAM\u00037CQ!Q\rA\u0002\rCQaR\rA\u0002\r\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002\"\u00065\u0006#\u0002\u0019\u0002$\u0006\u001d\u0016bAASc\t1q\n\u001d;j_:\u0004R\u0001MAU\u0007\u000eK1!a+2\u0005\u0019!V\u000f\u001d7fe!A\u0011q\u0016\u000e\u0002\u0002\u0003\u00071*A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!.\u0011\t\u0005E\u0011qW\u0005\u0005\u0003s\u000b\u0019B\u0001\u0004PE*,7\r\u001e")
public class Logarithm
extends BinaryMathExpression {
    private final Expression left;
    private final Expression right;

    public static Option<Tuple2<Expression, Expression>> unapply(Logarithm x$0) {
        return Logarithm$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple2<Expression, Expression>, Logarithm> tupled() {
        return Logarithm$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Logarithm>> curried() {
        return Logarithm$.MODULE$.curried();
    }

    @Override
    public Expression left() {
        return this.left;
    }

    @Override
    public Expression right() {
        return this.right;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public Object nullSafeEval(Object input1, Object input2) {
        double dLeft = BoxesRunTime.unboxToDouble((Object)input1);
        double dRight = BoxesRunTime.unboxToDouble((Object)input2);
        if (dLeft <= 0.0 || dRight <= 0.0) {
            return null;
        }
        return BoxesRunTime.boxToDouble((double)(StrictMath.log(dRight) / StrictMath.log(dLeft)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        if (this.left() instanceof EulerNumber) {
            return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(c1, c2) -> "\n          if (" + c2 + " <= 0.0) {\n            " + ev.isNull() + " = true;\n          } else {\n            " + ev.value() + " = java.lang.StrictMath.log(" + c2 + ");\n          }\n        ");
        }
        return this.nullSafeCodeGen(ctx, ev, (Function2<String, String, String>)(Function2 & Serializable)(c1, c2) -> "\n          if (" + c1 + " <= 0.0 || " + c2 + " <= 0.0) {\n            " + ev.isNull() + " = true;\n          } else {\n            " + ev.value() + " = java.lang.StrictMath.log(" + c2 + ") / java.lang.StrictMath.log(" + c1 + ");\n          }\n        ");
    }

    @Override
    public Logarithm withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public Logarithm copy(Expression left, Expression right) {
        return new Logarithm(left, right);
    }

    public Expression copy$default$1() {
        return this.left();
    }

    public Expression copy$default$2() {
        return this.right();
    }

    @Override
    public String productPrefix() {
        return "Logarithm";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.left();
            }
            case 1: {
                return this.right();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Logarithm;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "left";
            }
            case 1: {
                return "right";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Logarithm)) return false;
        boolean bl = true;
        if (!bl) return false;
        Logarithm logarithm = (Logarithm)x$1;
        Expression expression = this.left();
        Expression expression2 = logarithm.left();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.right();
        Expression expression4 = logarithm.right();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!logarithm.canEqual(this)) return false;
        return true;
    }

    public Logarithm(Expression left, Expression right) {
        this.left = left;
        this.right = right;
        super((Function2<Object, Object, Object>)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final double apply(double c1, double c2) {
                return this.apply$mcDDD$sp(c1, c2);
            }

            public final double apply$mcDDD$sp(double c1, double c2) {
                return StrictMath.log(c2) / StrictMath.log(c1);
            }
        }, "LOG");
    }

    public Logarithm(Expression child) {
        this(new EulerNumber(), child);
    }
}

