/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import java.io.IOException;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelimitedJSONSerDe
extends LazySimpleSerDe {
    public static final Logger LOG = LoggerFactory.getLogger((String)DelimitedJSONSerDe.class.getName());

    @Override
    public Object doDeserialize(Writable field) throws SerDeException {
        LOG.error("DelimitedJSONSerDe cannot deserialize.");
        throw new SerDeException("DelimitedJSONSerDe cannot deserialize.");
    }

    @Override
    protected void serializeField(ByteStream.Output out, Object obj, ObjectInspector objInspector, LazySerDeParameters serdeParams) throws SerDeException {
        if (!objInspector.getCategory().equals((Object)ObjectInspector.Category.PRIMITIVE) || objInspector.getTypeName().equalsIgnoreCase("binary")) {
            try {
                DelimitedJSONSerDe.serialize(out, SerDeUtils.getJSONString(obj, objInspector, serdeParams.getNullSequence().toString()), PrimitiveObjectInspectorFactory.javaStringObjectInspector, serdeParams.getSeparators(), 1, serdeParams.getNullSequence(), serdeParams.isEscaped(), serdeParams.getEscapeChar(), serdeParams.getNeedsEscape());
            }
            catch (IOException e) {
                throw new SerDeException(e);
            }
        } else {
            super.serializeField(out, obj, objInspector, serdeParams);
        }
    }
}

