/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.internal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.internal.KubernetesDeserializer;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class KubernetesDeserializerForMap
extends JsonDeserializer<Map<String, KubernetesResource>> {
    private final KubernetesDeserializer kubernetesDeserializer = new KubernetesDeserializer();

    public Map<String, KubernetesResource> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        if (!node.isObject()) {
            throw new JsonMappingException((Closeable)p, "Expected map but found " + String.valueOf(node.getNodeType()));
        }
        LinkedHashMap<String, KubernetesResource> ret = new LinkedHashMap<String, KubernetesResource>();
        Iterator it = node.fields();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            ret.put((String)entry.getKey(), this.kubernetesDeserializer.deserialize(p, (JsonNode)entry.getValue()));
        }
        return ret;
    }
}

