/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.errors;

import java.io.Serializable;
import java.util.Locale;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.spark.QueryContext;
import org.apache.spark.SparkException$;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.SqlBaseParser;
import org.apache.spark.sql.catalyst.trees.Origin;
import org.apache.spark.sql.errors.DataTypeErrorsBase;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.BigDecimal;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class QueryParsingErrors$
implements DataTypeErrorsBase {
    public static final QueryParsingErrors$ MODULE$ = new QueryParsingErrors$();

    static {
        DataTypeErrorsBase.$init$(MODULE$);
    }

    @Override
    public String toSQLId(String parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLId(Seq<String> parts) {
        return DataTypeErrorsBase.toSQLId$((DataTypeErrorsBase)this, parts);
    }

    @Override
    public String toSQLStmt(String text) {
        return DataTypeErrorsBase.toSQLStmt$(this, text);
    }

    @Override
    public String toSQLConf(String conf) {
        return DataTypeErrorsBase.toSQLConf$(this, conf);
    }

    @Override
    public String toSQLType(String text) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, text);
    }

    @Override
    public String toSQLType(AbstractDataType t) {
        return DataTypeErrorsBase.toSQLType$((DataTypeErrorsBase)this, t);
    }

    @Override
    public String toSQLValue(String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, value);
    }

    @Override
    public String toSQLValue(UTF8String value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, value);
    }

    @Override
    public String toSQLValue(short value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, value);
    }

    @Override
    public String toSQLValue(int value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, value);
    }

    @Override
    public String toSQLValue(long value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, value);
    }

    @Override
    public String toSQLValue(float value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, value);
    }

    @Override
    public String toSQLValue(double value) {
        return DataTypeErrorsBase.toSQLValue$((DataTypeErrorsBase)this, value);
    }

    @Override
    public String quoteByDefault(String elem) {
        return DataTypeErrorsBase.quoteByDefault$(this, elem);
    }

    @Override
    public String getSummary(QueryContext sqlContext) {
        return DataTypeErrorsBase.getSummary$(this, sqlContext);
    }

    @Override
    public QueryContext[] getQueryContext(QueryContext context) {
        return DataTypeErrorsBase.getQueryContext$(this, context);
    }

    @Override
    public String toDSOption(String option) {
        return DataTypeErrorsBase.toDSOption$(this, option);
    }

    public Throwable invalidInsertIntoError(SqlBaseParser.InsertIntoContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0001", ctx);
    }

    public Throwable parserStackOverflow(ParserRuleContext parserRuleContext) {
        throw new ParseException("FAILED_TO_PARSE_TOO_COMPLEX", parserRuleContext);
    }

    public Throwable insertOverwriteDirectoryUnsupportedError() {
        return SparkException$.MODULE$.internalError("INSERT OVERWRITE DIRECTORY is not supported.");
    }

    public Throwable columnAliasInOperationNotAllowedError(String op, SqlBaseParser.TableAliasContext ctx) {
        return new ParseException("COLUMN_ALIASES_NOT_ALLOWED", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"op"), (Object)this.toSQLStmt(op))}))), ctx.identifierList());
    }

    public Throwable emptySourceForMergeError(SqlBaseParser.MergeIntoTableContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0004", ctx.source);
    }

    public Throwable insertedValueNumberNotMatchFieldNumberError(SqlBaseParser.NotMatchedClauseContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0006", ctx.notMatchedAction());
    }

    public Throwable mergeStatementWithoutWhenClauseError(SqlBaseParser.MergeIntoTableContext ctx) {
        return new ParseException("MERGE_WITHOUT_WHEN", ctx);
    }

    public Throwable nonLastMatchedClauseOmitConditionError(SqlBaseParser.MergeIntoTableContext ctx) {
        return new ParseException("NON_LAST_MATCHED_CLAUSE_OMIT_CONDITION", ctx);
    }

    public Throwable nonLastNotMatchedClauseOmitConditionError(SqlBaseParser.MergeIntoTableContext ctx) {
        return new ParseException("NON_LAST_NOT_MATCHED_BY_TARGET_CLAUSE_OMIT_CONDITION", ctx);
    }

    public Throwable nonLastNotMatchedBySourceClauseOmitConditionError(SqlBaseParser.MergeIntoTableContext ctx) {
        return new ParseException("NON_LAST_NOT_MATCHED_BY_SOURCE_CLAUSE_OMIT_CONDITION", ctx);
    }

    public Throwable emptyPartitionKeyError(String key, SqlBaseParser.PartitionSpecContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.EMPTY_PARTITION_VALUE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partKey"), (Object)this.toSQLId(key))}))), ctx);
    }

    public Throwable clausesWithPipeOperatorsUnsupportedError(SqlBaseParser.QueryOrganizationContext ctx, String clauses) {
        return new ParseException("UNSUPPORTED_FEATURE.CLAUSE_WITH_PIPE_OPERATORS", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clauses"), (Object)clauses)}))), ctx);
    }

    public Throwable multipleQueryResultClausesWithPipeOperatorsUnsupportedError(SqlBaseParser.QueryOrganizationContext ctx, String clause1, String clause2) {
        return new ParseException("MULTIPLE_QUERY_RESULT_CLAUSES_WITH_PIPE_OPERATORS", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clause1"), (Object)clause1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clause2"), (Object)clause2)}))), ctx);
    }

    public Throwable combinationQueryResultClausesUnsupportedError(SqlBaseParser.QueryOrganizationContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE.COMBINATION_QUERY_RESULT_CLAUSES", ctx);
    }

    public Throwable pipeOperatorAggregateUnsupportedCaseError(String caseArgument, ParserRuleContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE.PIPE_OPERATOR_AGGREGATE_UNSUPPORTED_CASE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"case"), (Object)caseArgument)}))), ctx);
    }

    public Throwable windowClauseInPipeOperatorWhereClauseNotAllowedError(ParserRuleContext ctx) {
        return new ParseException("NOT_ALLOWED_IN_PIPE_OPERATOR_WHERE.WINDOW_CLAUSE", ctx);
    }

    public Throwable distributeByUnsupportedError(SqlBaseParser.QueryOrganizationContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0012", ctx);
    }

    public Throwable transformNotSupportQuantifierError(ParserRuleContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE.TRANSFORM_DISTINCT_ALL", (Map<String, String>)Predef$.MODULE$.Map().empty(), ctx);
    }

    public Throwable transformWithSerdeUnsupportedError(ParserRuleContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE.TRANSFORM_NON_HIVE", (Map<String, String>)Predef$.MODULE$.Map().empty(), ctx);
    }

    public Throwable unpivotWithPivotInFromClauseNotAllowedError(ParserRuleContext ctx) {
        return new ParseException("NOT_ALLOWED_IN_FROM.UNPIVOT_WITH_PIVOT", ctx);
    }

    public Throwable lateralWithPivotInFromClauseNotAllowedError(ParserRuleContext ctx) {
        return new ParseException("NOT_ALLOWED_IN_FROM.LATERAL_WITH_PIVOT", ctx);
    }

    public Throwable lateralWithUnpivotInFromClauseNotAllowedError(ParserRuleContext ctx) {
        return new ParseException("NOT_ALLOWED_IN_FROM.LATERAL_WITH_UNPIVOT", ctx);
    }

    public Throwable lateralJoinWithUsingJoinUnsupportedError(ParserRuleContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE.LATERAL_JOIN_USING", (Map<String, String>)Predef$.MODULE$.Map().empty(), ctx);
    }

    public Throwable unsupportedLateralJoinTypeError(ParserRuleContext ctx, String joinType) {
        return new ParseException("INVALID_LATERAL_JOIN_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"joinType"), (Object)this.toSQLStmt(joinType))}))), ctx);
    }

    public Throwable invalidLateralJoinRelationError(SqlBaseParser.RelationPrimaryContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.LATERAL_WITHOUT_SUBQUERY_OR_TABLE_VALUED_FUNC", ctx);
    }

    public Throwable repetitiveWindowDefinitionError(String name, SqlBaseParser.WindowClauseContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.REPETITIVE_WINDOW_DEFINITION", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"windowName"), (Object)this.toSQLId(name))}))), ctx);
    }

    public Throwable invalidWindowReferenceError(String name, SqlBaseParser.WindowClauseContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.INVALID_WINDOW_REFERENCE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"windowName"), (Object)this.toSQLId(name))}))), ctx);
    }

    public Throwable cannotResolveWindowReferenceError(String name, SqlBaseParser.WindowClauseContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.UNRESOLVED_WINDOW_REFERENCE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"windowName"), (Object)this.toSQLId(name))}))), ctx);
    }

    public Throwable incompatibleJoinTypesError(String joinType1, String joinType2, ParserRuleContext ctx) {
        return new ParseException("INCOMPATIBLE_JOIN_TYPES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"joinType1"), (Object)joinType1.toUpperCase(Locale.ROOT)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"joinType2"), (Object)joinType2.toUpperCase(Locale.ROOT))}))), ctx);
    }

    public Throwable emptyInputForTableSampleError(ParserRuleContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0014", ctx);
    }

    public Throwable tableSampleByBytesUnsupportedError(String msg, SqlBaseParser.SampleMethodContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0015", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)msg)}))), ctx);
    }

    public Throwable invalidByteLengthLiteralError(String bytesStr, SqlBaseParser.SampleByBytesContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0016", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bytesStr"), (Object)bytesStr)}))), ctx);
    }

    public Throwable invalidEscapeStringError(String invalidEscape, SqlBaseParser.PredicateContext ctx) {
        return new ParseException("INVALID_ESC", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidEscape"), (Object)this.toSQLValue(invalidEscape))}))), ctx);
    }

    public Throwable trimOptionUnsupportedError(int trimOption, SqlBaseParser.TrimContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0018", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"trimOption"), (Object)Integer.toString(trimOption))}))), ctx);
    }

    public Throwable functionNameUnsupportedError(String functionName, ParserRuleContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.UNSUPPORTED_FUNC_NAME", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)this.toSQLId(functionName))}))), ctx);
    }

    public Throwable cannotParseValueTypeError(String valueType, String value, SqlBaseParser.TypeConstructorContext ctx) {
        return new ParseException("INVALID_TYPED_LITERAL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"valueType"), (Object)this.toSQLType(valueType)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)this.toSQLValue(value))}))), ctx);
    }

    public Throwable literalValueTypeUnsupportedError(String unsupportedType, Seq<String> supportedTypes, SqlBaseParser.TypeConstructorContext ctx) {
        return new ParseException("UNSUPPORTED_TYPED_LITERAL", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"unsupportedType"), (Object)this.toSQLType(unsupportedType)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"supportedTypes"), (Object)((IterableOnceOps)supportedTypes.map((Function1 & Serializable)text -> MODULE$.toSQLType((String)text))).mkString(", "))}))), ctx);
    }

    public Throwable invalidNumericLiteralRangeError(String rawStrippedQualifier, BigDecimal minValue, BigDecimal maxValue, String typeName, SqlBaseParser.NumberContext ctx) {
        return new ParseException("INVALID_NUMERIC_LITERAL_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"rawStrippedQualifier"), (Object)rawStrippedQualifier), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"minValue"), (Object)minValue.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxValue"), (Object)maxValue.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)typeName)}))), ctx);
    }

    public Throwable moreThanOneFromToUnitInIntervalLiteralError(ParserRuleContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0024", ctx);
    }

    public Throwable invalidIntervalFormError(String value, SqlBaseParser.MultiUnitsIntervalContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0026", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)value)}))), ctx);
    }

    public Throwable invalidFromToUnitValueError(SqlBaseParser.IntervalValueContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0027", ctx);
    }

    public Throwable fromToIntervalUnsupportedError(String from, String to, ParserRuleContext ctx) {
        String string;
        String intervalInput = ctx.getText();
        Regex pattern = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("'([^']*)'"));
        Option option = pattern.findFirstMatchIn((CharSequence)intervalInput);
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            string = m.group(1);
        } else if (None$.MODULE$.equals(option)) {
            string = "";
        } else {
            throw new MatchError((Object)option);
        }
        String input = string;
        return new ParseException("INVALID_INTERVAL_FORMAT.UNSUPPORTED_FROM_TO_EXPRESSION", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), (Object)input), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"from"), (Object)from), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)to)}))), ctx);
    }

    public Throwable mixedIntervalUnitsError(String literal, ParserRuleContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0029", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"literal"), (Object)literal)}))), ctx);
    }

    public Throwable dataTypeUnsupportedError(String dataType, SqlBaseParser.PrimitiveDataTypeContext ctx) {
        return new ParseException("UNSUPPORTED_DATATYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"typeName"), (Object)this.toSQLType(dataType))}))), ctx);
    }

    public Throwable charVarcharTypeMissingLengthError(String dataType, SqlBaseParser.PrimitiveDataTypeContext ctx) {
        return new ParseException("DATATYPE_MISSING_SIZE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)this.toSQLType(dataType))}))), ctx);
    }

    public Throwable nestedTypeMissingElementTypeError(String dataType, SqlBaseParser.ComplexDataTypeContext ctx) {
        String string = dataType.toUpperCase(Locale.ROOT);
        switch (string == null ? 0 : string.hashCode()) {
            case -1838645291: {
                if (!"STRUCT".equals(string)) break;
                return new ParseException("INCOMPLETE_TYPE_DEFINITION.STRUCT", (Map<String, String>)Predef$.MODULE$.Map().empty(), ctx);
            }
            case 76092: {
                if (!"MAP".equals(string)) break;
                return new ParseException("INCOMPLETE_TYPE_DEFINITION.MAP", (Map<String, String>)Predef$.MODULE$.Map().empty(), ctx);
            }
            case 62552633: {
                if (!"ARRAY".equals(string)) break;
                return new ParseException("INCOMPLETE_TYPE_DEFINITION.ARRAY", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"elementType"), (Object)"<INT>")}))), ctx);
            }
        }
        throw new MatchError((Object)string);
    }

    public Throwable partitionTransformNotExpectedError(String name, String expr, SqlBaseParser.ApplyTransformContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.INVALID_COLUMN_REFERENCE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"transform"), (Object)this.toSQLId(name)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)expr)}))), ctx);
    }

    public Throwable wrongNumberArgumentsForTransformError(String name, int actualNum, SqlBaseParser.ApplyTransformContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.TRANSFORM_WRONG_NUM_ARGS", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"transform"), (Object)this.toSQLId(name)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expectedNum"), (Object)"1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualNum"), (Object)Integer.toString(actualNum))}))), ctx);
    }

    public Throwable invalidBucketsNumberError(String describe, SqlBaseParser.ApplyTransformContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0031", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"describe"), (Object)describe)}))), ctx);
    }

    public Throwable cannotCleanReservedNamespacePropertyError(String property, ParserRuleContext ctx, String msg) {
        return new ParseException("UNSUPPORTED_FEATURE.SET_NAMESPACE_PROPERTY", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)property), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)msg)}))), ctx);
    }

    public Throwable propertiesAndDbPropertiesBothSpecifiedError(SqlBaseParser.CreateNamespaceContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE.SET_PROPERTIES_AND_DBPROPERTIES", (Map<String, String>)Predef$.MODULE$.Map().empty(), ctx);
    }

    public Throwable cannotCleanReservedTablePropertyError(String property, ParserRuleContext ctx, String msg) {
        return new ParseException("UNSUPPORTED_FEATURE.SET_TABLE_PROPERTY", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"property"), (Object)property), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)msg)}))), ctx);
    }

    public Throwable duplicatedTablePathsFoundError(String pathOne, String pathTwo, ParserRuleContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0032", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pathOne"), (Object)pathOne), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pathTwo"), (Object)pathTwo)}))), ctx);
    }

    public Throwable storedAsAndStoredByBothSpecifiedError(SqlBaseParser.CreateFileFormatContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0033", ctx);
    }

    public Throwable operationInHiveStyleCommandUnsupportedError(String operation, String command, SqlBaseParser.StatementContext ctx, Option<String> msgOpt) {
        return new ParseException("_LEGACY_ERROR_TEMP_0034", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)operation), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"command"), (Object)command), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), msgOpt.map((Function1 & Serializable)m -> ", " + m).getOrElse((Function0 & Serializable)() -> ""))}))), ctx);
    }

    public Option<String> operationInHiveStyleCommandUnsupportedError$default$4() {
        return None$.MODULE$;
    }

    public Throwable operationNotAllowedError(String message, ParserRuleContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0035", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)message)}))), ctx);
    }

    public Throwable invalidStatementError(String operation, ParserRuleContext ctx) {
        return new ParseException("INVALID_STATEMENT_OR_CLAUSE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"operation"), (Object)this.toSQLStmt(operation))}))), ctx);
    }

    public Throwable descColumnForPartitionUnsupportedError(SqlBaseParser.DescribeRelationContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE.DESC_TABLE_COLUMN_PARTITION", (Map<String, String>)Predef$.MODULE$.Map().empty(), ctx);
    }

    public Throwable computeStatisticsNotExpectedError(SqlBaseParser.IdentifierContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.ANALYZE_TABLE_UNEXPECTED_NOSCAN", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ctx"), (Object)this.toSQLStmt(ctx.getText()))}))), ctx);
    }

    public Throwable addCatalogInCacheTableAsSelectNotAllowedError(String quoted, SqlBaseParser.CacheTableContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0037", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quoted"), (Object)quoted)}))), ctx);
    }

    public Throwable showFunctionsUnsupportedError(String identifier, ParserRuleContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.SHOW_FUNCTIONS_INVALID_SCOPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"scope"), (Object)this.toSQLId(identifier))}))), ctx);
    }

    public Throwable showFunctionsInvalidPatternError(String pattern, ParserRuleContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.SHOW_FUNCTIONS_INVALID_PATTERN", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pattern"), (Object)this.toSQLId(pattern))}))), ctx);
    }

    public Throwable duplicateCteDefinitionNamesError(String duplicateNames, SqlBaseParser.CtesContext ctx) {
        return new ParseException("DUPLICATED_CTE_NAMES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicateNames"), (Object)duplicateNames)}))), ctx);
    }

    public Throwable sqlStatementUnsupportedError(String sqlText, Origin position) {
        return new ParseException((Option<String>)Option$.MODULE$.apply((Object)sqlText), position, "INVALID_SQL_SYNTAX.UNSUPPORTED_SQL_STATEMENT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sqlText"), (Object)sqlText)}))));
    }

    public Throwable invalidIdentifierError(String ident, ParserRuleContext ctx) {
        return new ParseException("INVALID_IDENTIFIER", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ident"), (Object)ident)}))), ctx);
    }

    public Throwable duplicateClausesError(String clauseName, ParserRuleContext ctx) {
        return new ParseException("DUPLICATE_CLAUSES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clauseName"), (Object)clauseName)}))), ctx);
    }

    public Throwable duplicateKeysError(String key, ParserRuleContext ctx) {
        return new ParseException("DUPLICATE_KEY", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"keyColumn"), (Object)this.toSQLId(key))}))), ctx);
    }

    public Throwable unexpectedFormatForSetConfigurationError(ParserRuleContext ctx) {
        return new ParseException("INVALID_SET_SYNTAX", ctx);
    }

    public Throwable invalidPropertyKeyForSetQuotedConfigurationError(String keyCandidate, String valueStr, ParserRuleContext ctx) {
        return new ParseException("INVALID_PROPERTY_KEY", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)this.toSQLConf(keyCandidate)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)this.toSQLConf(valueStr))}))), ctx);
    }

    public Throwable invalidPropertyValueForSetQuotedConfigurationError(String valueCandidate, String keyStr, ParserRuleContext ctx) {
        return new ParseException("INVALID_PROPERTY_VALUE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"value"), (Object)this.toSQLConf(valueCandidate)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)this.toSQLConf(keyStr))}))), ctx);
    }

    public Throwable unexpectedFormatForResetConfigurationError(SqlBaseParser.ResetConfigurationContext ctx) {
        return new ParseException("INVALID_RESET_COMMAND_FORMAT", ctx);
    }

    public Throwable intervalValueOutOfRangeError(String input, SqlBaseParser.IntervalContext ctx) {
        return new ParseException("INVALID_INTERVAL_FORMAT.TIMEZONE_INTERVAL_OUT_OF_RANGE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"input"), (Object)input)}))), ctx);
    }

    public Throwable invalidTimeZoneDisplacementValueError(SqlBaseParser.SetTimeZoneContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0045", ctx);
    }

    public Throwable createTempTableNotSpecifyProviderError(SqlBaseParser.CreateTableContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0046", ctx);
    }

    public Throwable rowFormatNotUsedWithStoredAsError(SqlBaseParser.CreateTableLikeContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0047", ctx);
    }

    public Throwable useDefinedRecordReaderOrWriterClassesError(ParserRuleContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0048", ctx);
    }

    public Throwable directoryPathAndOptionsPathBothSpecifiedError(SqlBaseParser.InsertOverwriteDirContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0049", ctx);
    }

    public Throwable unsupportedLocalFileSchemeError(SqlBaseParser.InsertOverwriteDirContext ctx, String actualSchema) {
        return new ParseException("LOCAL_MUST_WITH_SCHEMA_FILE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualSchema"), (Object)actualSchema)}))), ctx);
    }

    public Throwable invalidGroupingSetError(String element, SqlBaseParser.GroupingAnalyticsContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0051", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"element"), (Object)element)}))), ctx);
    }

    public Throwable identityColumnUnsupportedDataType(SqlBaseParser.IdentityColumnContext ctx, String dataType) {
        return new ParseException("IDENTITY_COLUMNS_UNSUPPORTED_DATA_TYPE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dataType"), (Object)dataType)}))), ctx);
    }

    public Throwable identityColumnIllegalStep(SqlBaseParser.IdentityColSpecContext ctx) {
        return new ParseException("IDENTITY_COLUMNS_ILLEGAL_STEP", (Map<String, String>)Predef$.MODULE$.Map().empty(), ctx);
    }

    public Throwable identityColumnDuplicatedSequenceGeneratorOption(SqlBaseParser.IdentityColSpecContext ctx, String sequenceGeneratorOption) {
        return new ParseException("IDENTITY_COLUMNS_DUPLICATED_SEQUENCE_GENERATOR_OPTION", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sequenceGeneratorOption"), (Object)sequenceGeneratorOption)}))), ctx);
    }

    public Throwable createViewWithBothIfNotExistsAndReplaceError(SqlBaseParser.CreateViewContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0052", ctx);
    }

    public Throwable temporaryViewWithSchemaBindingMode(SqlBaseParser.StatementContext ctx) {
        return new ParseException("UNSUPPORTED_FEATURE.TEMPORARY_VIEW_WITH_SCHEMA_BINDING_MODE", (Map<String, String>)Predef$.MODULE$.Map().empty(), ctx);
    }

    public Throwable parameterMarkerNotAllowed(String statement, Origin origin) {
        return new ParseException(origin.sqlText(), origin, "UNSUPPORTED_FEATURE.PARAMETER_MARKER_IN_UNEXPECTED_STATEMENT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statement"), (Object)statement)}))));
    }

    public Throwable defineTempViewWithIfNotExistsError(SqlBaseParser.CreateViewContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0053", ctx);
    }

    public Throwable notAllowedToAddDBPrefixForTempViewError(Seq<String> nameParts, SqlBaseParser.CreateViewContext ctx) {
        return new ParseException("TEMP_VIEW_NAME_TOO_MANY_NAME_PARTS", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"actualName"), (Object)this.toSQLId(nameParts))}))), ctx);
    }

    public Throwable createFuncWithBothIfNotExistsAndReplaceError(ParserRuleContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.CREATE_ROUTINE_WITH_IF_NOT_EXISTS_AND_REPLACE", ctx);
    }

    public Throwable createTempTableUsingProviderError(SqlBaseParser.CreateTableContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.CREATE_TEMP_TABLE_USING_PROVIDER", ctx);
    }

    public Throwable createFuncWithGeneratedColumnsError(ParserRuleContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.CREATE_FUNC_WITH_GENERATED_COLUMNS_AS_PARAMETERS", ctx);
    }

    public Throwable createFuncWithConstraintError(ParserRuleContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.CREATE_FUNC_WITH_COLUMN_CONSTRAINTS", ctx);
    }

    public Throwable defineTempFuncWithIfNotExistsError(ParserRuleContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.CREATE_TEMP_FUNC_WITH_IF_NOT_EXISTS", ctx);
    }

    public Throwable unsupportedFunctionNameError(Seq<String> funcName, ParserRuleContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.MULTI_PART_NAME", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statement"), (Object)this.toSQLStmt("CREATE TEMPORARY FUNCTION")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.toSQLId(funcName))}))), ctx);
    }

    public Throwable specifyingDBInCreateTempFuncError(String databaseName, ParserRuleContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.CREATE_TEMP_FUNC_WITH_DATABASE", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"database"), (Object)this.toSQLId(databaseName))}))), ctx);
    }

    public Throwable invalidTableValuedFunctionNameError(Seq<String> name, SqlBaseParser.TableValuedFunctionContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.INVALID_TABLE_VALUED_FUNC_NAME", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"funcName"), (Object)this.toSQLId(name))}))), ctx);
    }

    public Throwable unclosedBracketedCommentError(String command, Origin start, Origin stop) {
        return new ParseException((Option<String>)new Some((Object)command), start, "UNCLOSED_BRACKETED_COMMENT", (Map<String, String>)Predef$.MODULE$.Map().empty());
    }

    public Throwable invalidTimeTravelSpec(String reason, ParserRuleContext ctx) {
        return new ParseException("_LEGACY_ERROR_TEMP_0056", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)reason)}))), ctx);
    }

    public Throwable invalidNameForDropTempFunc(Seq<String> name, ParserRuleContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.MULTI_PART_NAME", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statement"), (Object)this.toSQLStmt("DROP TEMPORARY FUNCTION")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.toSQLId(name))}))), ctx);
    }

    public Throwable invalidNameForSetCatalog(Seq<String> name, ParserRuleContext ctx) {
        return new ParseException("INVALID_SQL_SYNTAX.MULTI_PART_NAME", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"statement"), (Object)this.toSQLStmt("SET CATALOG")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)this.toSQLId(name))}))), ctx);
    }

    public Throwable defaultColumnNotImplementedYetError(ParserRuleContext ctx) {
        return new ParseException("UNSUPPORTED_DEFAULT_VALUE.WITHOUT_SUGGESTION", ctx);
    }

    public Throwable defaultColumnNotEnabledError(ParserRuleContext ctx) {
        return new ParseException("UNSUPPORTED_DEFAULT_VALUE.WITH_SUGGESTION", ctx);
    }

    public Throwable defaultColumnReferencesNotAllowedInPartitionSpec(ParserRuleContext ctx) {
        return new ParseException("REF_DEFAULT_VALUE_IS_NOT_ALLOWED_IN_PARTITION", ctx);
    }

    public Throwable duplicateArgumentNamesError(Seq<String> arguments, ParserRuleContext ctx) {
        return new ParseException("EXEC_IMMEDIATE_DUPLICATE_ARGUMENT_ALIASES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"aliases"), (Object)((IterableOnceOps)arguments.map((Function1 & Serializable)parts -> MODULE$.toSQLId((String)parts))).mkString(", "))}))), ctx);
    }

    public Throwable duplicateTableColumnDescriptor(ParserRuleContext ctx, String columnName, String optionName, boolean isCreate, String alterType) {
        String errorClass = isCreate ? "CREATE_TABLE_COLUMN_DESCRIPTOR_DUPLICATE" : "ALTER_TABLE_COLUMN_DESCRIPTOR_DUPLICATE";
        Map alterTypeMap = isCreate ? Predef$.MODULE$.Map().empty() : (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)alterType)}));
        return new ParseException(errorClass, (Map<String, String>)((Map)alterTypeMap.$plus$plus((IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columnName"), (Object)columnName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"optionName"), (Object)optionName)})))), ctx);
    }

    public boolean duplicateTableColumnDescriptor$default$4() {
        return true;
    }

    public String duplicateTableColumnDescriptor$default$5() {
        return "ADD";
    }

    public Throwable invalidDatetimeUnitError(ParserRuleContext ctx, String functionName, String invalidValue) {
        return new ParseException("INVALID_PARAMETER_VALUE.DATETIME_UNIT", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"functionName"), (Object)this.toSQLId(functionName)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameter"), (Object)this.toSQLId("unit")), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"invalidValue"), (Object)invalidValue)}))), ctx);
    }

    public Throwable invalidTableFunctionIdentifierArgumentMissingParentheses(ParserRuleContext ctx, String argumentName) {
        return new ParseException("INVALID_SQL_SYNTAX.INVALID_TABLE_FUNCTION_IDENTIFIER_ARGUMENT_MISSING_PARENTHESES", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"argumentName"), (Object)this.toSQLId(argumentName))}))), ctx);
    }

    public Throwable clusterByWithPartitionedBy(ParserRuleContext ctx) {
        return new ParseException("SPECIFY_CLUSTER_BY_WITH_PARTITIONED_BY_IS_NOT_ALLOWED", ctx);
    }

    public Throwable clusterByWithBucketing(ParserRuleContext ctx) {
        return new ParseException("SPECIFY_CLUSTER_BY_WITH_BUCKETING_IS_NOT_ALLOWED", ctx);
    }

    public Throwable invalidConstraintCharacteristics(ParserRuleContext ctx, String characteristics) {
        return new ParseException("INVALID_CONSTRAINT_CHARACTERISTICS", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"characteristics"), (Object)characteristics)}))), ctx);
    }

    public Throwable multiplePrimaryKeysError(ParserRuleContext ctx, String columns) {
        return new ParseException("MULTIPLE_PRIMARY_KEYS", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"columns"), (Object)columns)}))), ctx);
    }

    public Nothing$ unexpectedUseOfParameterMarker(ParserRuleContext ctx) {
        throw new ParseException("UNEXPECTED_USE_OF_PARAMETER_MARKER", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"parameterMarker"), (Object)ctx.getText())}))), ctx);
    }

    private QueryParsingErrors$() {
    }
}

