/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.client.spi;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.client.impl.cache.CacheKey;
import io.vertx.ext.web.client.impl.cache.CachedHttpResponse;
import io.vertx.ext.web.client.impl.cache.LocalCacheStore;
import io.vertx.ext.web.client.impl.cache.NoOpCacheStore;
import io.vertx.ext.web.client.impl.cache.SharedDataCacheStore;

public interface CacheStore {
    public static CacheStore build() {
        return new NoOpCacheStore();
    }

    public static CacheStore sharedDataStore(Vertx vertx) {
        return new SharedDataCacheStore(vertx);
    }

    public static CacheStore localStore() {
        return new LocalCacheStore();
    }

    public Future<CachedHttpResponse> get(CacheKey var1);

    public Future<CachedHttpResponse> set(CacheKey var1, CachedHttpResponse var2);

    public Future<Void> delete(CacheKey var1);

    public Future<Void> flush();

    default public void get(CacheKey key, Handler<AsyncResult<CachedHttpResponse>> handler) {
        this.get(key).onComplete(handler);
    }

    default public void set(CacheKey key, CachedHttpResponse response, Handler<AsyncResult<CachedHttpResponse>> handler) {
        this.set(key, response).onComplete(handler);
    }

    default public void delete(CacheKey key, Handler<AsyncResult<Void>> handler) {
        this.delete(key).onComplete(handler);
    }

    default public void flush(Handler<AsyncResult<Void>> handler) {
        this.flush().onComplete(handler);
    }
}

