/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.LogBlockId;
import org.apache.spark.storage.LogBlockId$;
import org.apache.spark.storage.LogBlockWriter$;
import org.apache.spark.storage.LogLine;
import org.apache.spark.storage.LogLine$;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.StringContext;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005}e!B\u0012%\u0001\u0019b\u0003\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0011}\u0002!\u0011!Q\u0001\n\u0001C\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\t/\u0002\u0011\t\u0011)A\u00051\")1\f\u0001C\u00019\"A!\r\u0001a\u0001\n\u0003!3\r\u0003\u0005m\u0001\u0001\u0007I\u0011\u0001\u0013n\u0011\u0019\u0019\b\u0001)Q\u0005I\"9A\u000f\u0001a\u0001\n\u0013)\b\u0002C@\u0001\u0001\u0004%I!!\u0001\t\u000f\u0005\u0015\u0001\u0001)Q\u0005m\"I\u0011q\u0001\u0001A\u0002\u0013%\u0011\u0011\u0002\u0005\n\u0003/\u0001\u0001\u0019!C\u0005\u00033A\u0001\"!\b\u0001A\u0003&\u00111\u0002\u0005\n\u0003?\u0001\u0001\u0019!C\u0005\u0003CA\u0011\"!\u000b\u0001\u0001\u0004%I!a\u000b\t\u0011\u0005=\u0002\u0001)Q\u0005\u0003GA\u0011\"!\r\u0001\u0001\u0004%I!!\t\t\u0013\u0005M\u0002\u00011A\u0005\n\u0005U\u0002\u0002CA\u001d\u0001\u0001\u0006K!a\t\t\u0013\u0005m\u0002\u00011A\u0005\n\u0005u\u0002\"CA \u0001\u0001\u0007I\u0011BA!\u0011\u001d\t)\u0005\u0001Q!\naCq!a\u0012\u0001\t\u0013\tI\u0005C\u0004\u0002L\u0001!\t!!\u0014\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R!9\u0011Q\f\u0001\u0005\u0002\u0005}\u0003bBA6\u0001\u0011\u0005\u0011\u0011\n\u0005\t\u0003[\u0002A\u0011\u0001\u0013\u0002J!A\u0011q\u000e\u0001\u0005\u0002\u0011\n\th\u0002\u0006\u0002\u0000\u0011\n\t\u0011#\u0001'\u0003\u00033\u0011b\t\u0013\u0002\u0002#\u0005a%a!\t\rm\u0003C\u0011AAC\u0011%\t9\tII\u0001\n\u0003\tII\u0001\bM_\u001e\u0014En\\2l/JLG/\u001a:\u000b\u0005\u00152\u0013aB:u_J\fw-\u001a\u0006\u0003O!\nQa\u001d9be.T!!\u000b\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0013aA8sON\u0019\u0001!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0003A\nQa]2bY\u0006L!AM\u0018\u0003\r\u0005s\u0017PU3g!\t!t'D\u00016\u0015\t1d%\u0001\u0005j]R,'O\\1m\u0013\tATGA\u0004M_\u001e<\u0017N\\4\u0002\u0019\tdwnY6NC:\fw-\u001a:\u0004\u0001A\u0011A(P\u0007\u0002I%\u0011a\b\n\u0002\r\u00052|7m['b]\u0006<WM]\u0001\rY><'\t\\8dWRK\b/\u001a\t\u0003\u0003>s!AQ'\u000f\u0005\rceB\u0001#L\u001d\t)%J\u0004\u0002G\u00136\tqI\u0003\u0002Iu\u00051AH]8pizJ\u0011aK\u0005\u0003S)J!a\n\u0015\n\u0005\u00152\u0013B\u0001(%\u00031aun\u001a\"m_\u000e\\G+\u001f9f\u0013\t\u0001\u0016K\u0001\u0007M_\u001e\u0014En\\2l)f\u0004XM\u0003\u0002OI\u0005I1\u000f]1sW\u000e{gN\u001a\t\u0003)Vk\u0011AJ\u0005\u0003-\u001a\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\u0015\t,hMZ3s'&TX\r\u0005\u0002/3&\u0011!l\f\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\bF\u0003^=~\u0003\u0017\r\u0005\u0002=\u0001!)\u0011(\u0002a\u0001w!)q(\u0002a\u0001\u0001\")!+\u0002a\u0001'\"9q+\u0002I\u0001\u0002\u0004A\u0016a\u0002;na\u001aKG.Z\u000b\u0002IB\u0011QM[\u0007\u0002M*\u0011q\r[\u0001\u0003S>T\u0011![\u0001\u0005U\u00064\u0018-\u0003\u0002lM\n!a)\u001b7f\u0003-!X\u000e\u001d$jY\u0016|F%Z9\u0015\u00059\f\bC\u0001\u0018p\u0013\t\u0001xF\u0001\u0003V]&$\bb\u0002:\b\u0003\u0003\u0005\r\u0001Z\u0001\u0004q\u0012\n\u0014\u0001\u0003;na\u001aKG.\u001a\u0011\u0002\u0007\r|7/F\u0001w!\t9X0D\u0001y\u0015\tI(0\u0001\u0004pkR\u0004X\u000f\u001e\u0006\u0003OnT!\u0001 \u0015\u0002\u000f\r|W.\\8og&\u0011a\u0010\u001f\u0002\u0015\u0007>,h\u000e^5oO>+H\u000f];u'R\u0014X-Y7\u0002\u000f\r|7o\u0018\u0013fcR\u0019a.a\u0001\t\u000fIT\u0011\u0011!a\u0001m\u0006!1m\\:!\u0003\u0019y'M[(viV\u0011\u00111\u0002\t\u0005\u0003\u001b\t\u0019\"\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003\u0014\u0002\u0015M,'/[1mSj,'/\u0003\u0003\u0002\u0016\u0005=!aE*fe&\fG.\u001b>bi&|gn\u0015;sK\u0006l\u0017AC8cU>+Ho\u0018\u0013fcR\u0019a.a\u0007\t\u0011Il\u0011\u0011!a\u0001\u0003\u0017\tqa\u001c2k\u001fV$\b%A\u0007iCN\u0014U-\u001a8DY>\u001cX\rZ\u000b\u0003\u0003G\u00012ALA\u0013\u0013\r\t9c\f\u0002\b\u0005>|G.Z1o\u0003EA\u0017m\u001d\"fK:\u001cEn\\:fI~#S-\u001d\u000b\u0004]\u00065\u0002\u0002\u0003:\u0011\u0003\u0003\u0005\r!a\t\u0002\u001d!\f7OQ3f]\u000ecwn]3eA\u0005q!/Z2pe\u0012\u001cxK]5ui\u0016t\u0017A\u0005:fG>\u0014Hm],sSR$XM\\0%KF$2A\\A\u001c\u0011!\u00118#!AA\u0002\u0005\r\u0012a\u0004:fG>\u0014Hm],sSR$XM\u001c\u0011\u0002#Q|G/\u00197CsR,7o\u0016:jiR,g.F\u0001Y\u0003U!x\u000e^1m\u0005f$Xm],sSR$XM\\0%KF$2A\\A\"\u0011\u001d\u0011h#!AA\u0002a\u000b!\u0003^8uC2\u0014\u0015\u0010^3t/JLG\u000f^3oA\u0005Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u00039\fABY=uKN<&/\u001b;uK:$\u0012\u0001W\u0001\toJLG/\u001a'pOR\u0019a.a\u0015\t\u000f\u0005U#\u00041\u0001\u0002X\u0005AAn\\4F]R\u0014\u0018\u0010E\u0002=\u00033J1!a\u0017%\u0005\u001daun\u001a'j]\u0016\fAa]1wKR\u0019a.!\u0019\t\u000f\u0005\r4\u00041\u0001\u0002f\u00059!\r\\8dW&#\u0007c\u0001\u001f\u0002h%\u0019\u0011\u0011\u000e\u0013\u0003\u00151{wM\u00117pG.LE-A\u0003dY>\u001cX-A\u0003gYV\u001c\b.\u0001\ntCZ,Gk\u001c\"m_\u000e\\W*\u00198bO\u0016\u0014HCBA\u0012\u0003g\n)\bC\u0004\u0002dy\u0001\r!!\u001a\t\u000f\u0005]d\u00041\u0001\u0002z\u0005I!\r\\8dWNK'0\u001a\t\u0004]\u0005m\u0014bAA?_\t!Aj\u001c8h\u00039aun\u001a\"m_\u000e\\wK]5uKJ\u0004\"\u0001\u0010\u0011\u0014\u0005\u0001jCCAAA\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u0012\u0016\u00041\u000655FAAH!\u0011\t\t*a'\u000e\u0005\u0005M%\u0002BAK\u0003/\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005eu&\u0001\u0006b]:|G/\u0019;j_:LA!!(\u0002\u0014\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class LogBlockWriter
implements Logging {
    private final BlockManager blockManager;
    private final Enumeration.Value logBlockType;
    private final SparkConf sparkConf;
    private final int bufferSize;
    private File tmpFile;
    private CountingOutputStream cos;
    private SerializationStream objOut;
    private boolean hasBeenClosed;
    private boolean recordsWritten;
    private int totalBytesWritten;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int $lessinit$greater$default$4() {
        return LogBlockWriter$.MODULE$.$lessinit$greater$default$4();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body2) {
        Logging.withLogContext$((Logging)this, context, body2);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public File tmpFile() {
        return this.tmpFile;
    }

    public void tmpFile_$eq(File x$1) {
        this.tmpFile = x$1;
    }

    private CountingOutputStream cos() {
        return this.cos;
    }

    private void cos_$eq(CountingOutputStream x$1) {
        this.cos = x$1;
    }

    private SerializationStream objOut() {
        return this.objOut;
    }

    private void objOut_$eq(SerializationStream x$1) {
        this.objOut = x$1;
    }

    private boolean hasBeenClosed() {
        return this.hasBeenClosed;
    }

    private void hasBeenClosed_$eq(boolean x$1) {
        this.hasBeenClosed = x$1;
    }

    private boolean recordsWritten() {
        return this.recordsWritten;
    }

    private void recordsWritten_$eq(boolean x$1) {
        this.recordsWritten = x$1;
    }

    private int totalBytesWritten() {
        return this.totalBytesWritten;
    }

    private void totalBytesWritten_$eq(int x$1) {
        this.totalBytesWritten = x$1;
    }

    private void initialize() {
        try {
            File dir = new File(Utils$.MODULE$.getLocalDir(this.sparkConf));
            this.tmpFile_$eq(File.createTempFile("spark_log_" + this.logBlockType, "", dir));
            FileOutputStream fos = new FileOutputStream(this.tmpFile(), false);
            BufferedOutputStream bos = new BufferedOutputStream(fos, this.bufferSize);
            this.cos_$eq(new CountingOutputStream((OutputStream)bos));
            LogBlockId emptyBlockId = LogBlockId$.MODULE$.empty(this.logBlockType);
            this.objOut_$eq(this.blockManager.serializerManager().blockSerializationStream(emptyBlockId, (OutputStream)this.cos(), LogLine$.MODULE$.getClassTag(this.logBlockType)));
        }
        catch (Exception e) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to initialize LogBlockWriter."}))).log((Seq)Nil$.MODULE$)), (Throwable)e);
            this.close();
            throw e;
        }
    }

    public int bytesWritten() {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.cos()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.getCount())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> this.totalBytesWritten()));
    }

    public void writeLog(LogLine logEntry) {
        if (this.hasBeenClosed()) {
            throw SparkException$.MODULE$.internalError("Writer already closed. Cannot write more data.", "STORAGE");
        }
        try {
            this.objOut().writeObject(logEntry, ClassTag$.MODULE$.apply(LogLine.class));
            this.recordsWritten_$eq(true);
        }
        catch (Exception e) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to write log entry."}))).log((Seq)Nil$.MODULE$)), (Throwable)e);
            throw e;
        }
    }

    public void save(LogBlockId blockId) {
        if (this.hasBeenClosed()) {
            throw SparkException$.MODULE$.internalError("Writer already closed. Cannot save.", "STORAGE");
        }
        try {
            Enumeration.Value value = blockId.logBlockType();
            Enumeration.Value value2 = this.logBlockType;
            if (value == null ? value2 != null : !value.equals(value2)) {
                throw SparkException$.MODULE$.internalError("LogBlockWriter is for " + this.logBlockType + ", but got blockId " + blockId);
            }
            this.objOut().flush();
            this.objOut().close();
            this.objOut_$eq(null);
            if (this.recordsWritten()) {
                this.totalBytesWritten_$eq(this.cos().getCount());
                boolean success = this.saveToBlockManager(blockId, this.totalBytesWritten());
                if (!success) {
                    throw SparkException$.MODULE$.internalError("Failed to save log block " + blockId + " to BlockManager");
                }
            }
        }
        finally {
            this.close();
        }
    }

    public void close() {
        if (this.hasBeenClosed()) {
            return;
        }
        try {
            try {
                if (this.objOut() != null) {
                    this.objOut().close();
                }
                if (this.tmpFile() != null && this.tmpFile().exists()) {
                    this.tmpFile().delete();
                }
            }
            catch (Exception e) {
                this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to close resources of LogBlockWriter"}))).log((Seq)Nil$.MODULE$)), (Throwable)e);
            }
        }
        finally {
            this.objOut_$eq(null);
            this.cos_$eq(null);
            this.hasBeenClosed_$eq(true);
        }
    }

    public void flush() {
        if (this.objOut() != null) {
            this.objOut().flush();
            return;
        }
    }

    public boolean saveToBlockManager(LogBlockId blockId, long blockSize) {
        return new BlockManager.TempFileBasedBlockStoreUpdater<LogLine>(this.blockManager, blockId, StorageLevel$.MODULE$.DISK_ONLY(), LogLine$.MODULE$.getClassTag(this.logBlockType), this.tmpFile(), blockSize, this.blockManager.TempFileBasedBlockStoreUpdater().apply$default$6(), this.blockManager.TempFileBasedBlockStoreUpdater().apply$default$7()).save();
    }

    public LogBlockWriter(BlockManager blockManager, Enumeration.Value logBlockType, SparkConf sparkConf, int bufferSize) {
        this.blockManager = blockManager;
        this.logBlockType = logBlockType;
        this.sparkConf = sparkConf;
        this.bufferSize = bufferSize;
        Logging.$init$((Logging)this);
        this.tmpFile = null;
        this.cos = null;
        this.objOut = null;
        this.hasBeenClosed = false;
        this.recordsWritten = false;
        this.totalBytesWritten = 0;
        this.initialize();
    }
}

