/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.util.Locale;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StringType$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class TeradataDialect$
extends JdbcDialect
implements Product {
    public static TeradataDialect$ MODULE$;
    private final Set<String> supportedAggregateFunctions;
    private final Set<String> supportedFunctions;

    static {
        new TeradataDialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:teradata");
    }

    private Set<String> supportedAggregateFunctions() {
        return this.supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return this.supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        if (StringType$.MODULE$.equals(dataType)) {
            return new Some((Object)new JdbcType("VARCHAR(255)", 12));
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return Option$.MODULE$.apply((Object)new JdbcType("CHAR(1)", 1));
        }
        return None$.MODULE$;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(16).append("DELETE FROM ").append(table).append(" ALL").toString();
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public String renameTable(Identifier oldTable, Identifier newTable) {
        return new StringBuilder(17).append("RENAME TABLE ").append(this.getFullyQualifiedQuotedTableName(oldTable)).append(" TO ").append(this.getFullyQualifiedQuotedTableName(newTable)).toString();
    }

    @Override
    public String getLimitClause(Integer limit) {
        return "";
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        int n = sqlType;
        switch (n) {
            case 2: {
                if (md == null) {
                    return new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT());
                }
                long scale = md.build().getLong("scale");
                if (size == 40) {
                    if (scale == 0L) {
                        return new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT());
                    }
                    return new Some((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), (int)scale));
                }
                return new Some((Object)new DecimalType(size, (int)scale));
            }
        }
        return None$.MODULE$;
    }

    public String productPrefix() {
        return "TeradataDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TeradataDialect$;
    }

    public int hashCode() {
        return -1014754660;
    }

    public String toString() {
        return "TeradataDialect";
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TeradataDialect$() {
        MODULE$ = this;
        Product.$init$((Product)this);
        this.supportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP", "COVAR_POP", "COVAR_SAMP", "CORR"}));
        this.supportedFunctions = this.supportedAggregateFunctions();
    }
}

