/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.spark.deploy.SparkHadoopUtil$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;

public final class HdfsUtils$ {
    public static HdfsUtils$ MODULE$;

    static {
        new HdfsUtils$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FSDataOutputStream getOutputStream(String path, Configuration conf) {
        FSDataOutputStream fSDataOutputStream;
        Path dfsPath = new Path(path);
        FileSystem dfs = this.getFileSystemForPath(dfsPath, conf);
        if (dfs.isFile(dfsPath)) {
            if (!conf.getBoolean("dfs.support.append", true) && !conf.getBoolean("hdfs.append.support", false)) {
                if (!(dfs instanceof RawLocalFileSystem)) throw new IllegalStateException("File exists and there is no append support!");
            }
            fSDataOutputStream = dfs.append(dfsPath);
            return fSDataOutputStream;
        } else {
            fSDataOutputStream = SparkHadoopUtil$.MODULE$.createFile(dfs, dfsPath, false);
        }
        return fSDataOutputStream;
    }

    public FSDataInputStream getInputStream(String path, Configuration conf) {
        FSDataInputStream fSDataInputStream;
        Path dfsPath = new Path(path);
        FileSystem dfs = this.getFileSystemForPath(dfsPath, conf);
        try {
            fSDataInputStream = dfs.open(dfsPath);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fSDataInputStream = null;
        }
        catch (IOException e) {
            if (!dfs.getFileStatus(dfsPath).isFile()) {
                fSDataInputStream = null;
            }
            throw e;
        }
        return fSDataInputStream;
    }

    public void checkState(boolean state, Function0<String> errorMsg) {
        if (!state) {
            throw new IllegalStateException((String)errorMsg.apply());
        }
    }

    public String[] getFileSegmentLocations(String path, long offset, long length, Configuration conf) {
        Path dfsPath = new Path(path);
        FileSystem dfs = this.getFileSystemForPath(dfsPath, conf);
        FileStatus fileStatus = dfs.getFileStatus(dfsPath);
        Option blockLocs = Option$.MODULE$.apply((Object)dfs.getFileBlockLocations(fileStatus, offset, length));
        return (String[])blockLocs.map((Function1 & Serializable & scala.Serializable)x$1 -> (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$1)).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.getHosts())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
    }

    public FileSystem getFileSystemForPath(Path path, Configuration conf) {
        FileSystem fs = path.getFileSystem(conf);
        FileSystem fileSystem = fs;
        if (fileSystem instanceof LocalFileSystem) {
            LocalFileSystem localFileSystem = (LocalFileSystem)fileSystem;
            return localFileSystem.getRawFileSystem();
        }
        return fs;
    }

    public boolean checkFileExists(String path, Configuration conf) {
        boolean bl;
        Path hdpPath = new Path(path);
        FileSystem fs = this.getFileSystemForPath(hdpPath, conf);
        try {
            bl = fs.getFileStatus(hdpPath).isFile();
        }
        catch (FileNotFoundException fileNotFoundException) {
            bl = false;
        }
        return bl;
    }

    private HdfsUtils$() {
        MODULE$ = this;
    }
}

