/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import java.io.CharConversionException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.charset.MalformedInputException;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonUtils$;
import org.apache.spark.sql.catalyst.json.JsonInferSchema$;
import org.apache.spark.sql.catalyst.util.DropMalformedMode$;
import org.apache.spark.sql.catalyst.util.FailFastMode$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.ParseMode;
import org.apache.spark.sql.catalyst.util.PermissiveMode$;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.util.control.Exception$;

@ScalaSignature(bytes="\u0006\u0005\u0005=h!\u0002\u000f\u001e\u0001\u0005J\u0003\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u000b\t\u0003A\u0011A\"\t\u000f\u0019\u0003!\u0019!C\u0005\u000f\"11\f\u0001Q\u0001\n!Cq\u0001\u0018\u0001C\u0002\u0013%Q\f\u0003\u0004e\u0001\u0001\u0006IA\u0018\u0005\bK\u0002\u0011\r\u0011\"\u0003^\u0011\u00191\u0007\u0001)A\u0005=\"9q\r\u0001b\u0001\n\u0013A\u0007B\u00027\u0001A\u0003%\u0011\u000eC\u0004n\u0001\t\u0007I\u0011\u00025\t\r9\u0004\u0001\u0015!\u0003j\u0011\u0015y\u0007\u0001\"\u0003q\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!a\u0018\u0001\t\u0003\t\t\u0007\u0003\u0005\u0002n\u0001!\taHA8\u000f\u001d\tI(\bE\u0001\u0003w2a\u0001H\u000f\t\u0002\u0005u\u0004B\u0002\"\u0013\t\u0003\tI\tC\u0005\u0002\fJ\u0011\r\u0011\"\u0001\u0002\u000e\"A\u0011Q\u0013\n!\u0002\u0013\ty\tC\u0004\u00024J!\t!!.\t\u000f\u0005\u0005'\u0003\"\u0001\u0002D\"9\u00111\u001b\n\u0005\u0002\u0005U\u0007\u0002CAo%\u0001\u0006I!a/\t\u000f\u0005}'\u0003\"\u0001\u0002b\"I\u00111\u001e\n\u0002\u0002\u0013%\u0011Q\u001e\u0002\u0010\u0015N|g.\u00138gKJ\u001c6\r[3nC*\u0011adH\u0001\u0005UN|gN\u0003\u0002!C\u0005A1-\u0019;bYf\u001cHO\u0003\u0002#G\u0005\u00191/\u001d7\u000b\u0005\u0011*\u0013!B:qCJ\\'B\u0001\u0014(\u0003\u0019\t\u0007/Y2iK*\t\u0001&A\u0002pe\u001e\u001c2\u0001\u0001\u00161!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\u0019\te.\u001f*fMB\u0011\u0011G\u000f\b\u0003ear!aM\u001c\u000e\u0003QR!!\u000e\u001c\u0002\rq\u0012xn\u001c;?\u0007\u0001I\u0011!L\u0005\u0003s1\nq\u0001]1dW\u0006<W-\u0003\u0002<y\ta1+\u001a:jC2L'0\u00192mK*\u0011\u0011\bL\u0001\b_B$\u0018n\u001c8t!\ty\u0004)D\u0001\u001e\u0013\t\tUDA\u0006K'>su\n\u001d;j_:\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0002E\u000bB\u0011q\b\u0001\u0005\u0006{\t\u0001\rAP\u0001\u000eI\u0016\u001c\u0017.\\1m!\u0006\u00148/\u001a:\u0016\u0003!\u0003BaK%L'&\u0011!\n\f\u0002\n\rVt7\r^5p]F\u0002\"\u0001\u0014)\u000f\u00055s\u0005CA\u001a-\u0013\tyE&\u0001\u0004Qe\u0016$WMZ\u0005\u0003#J\u0013aa\u0015;sS:<'BA(-!\t!\u0016,D\u0001V\u0015\t1v+\u0001\u0003nCRD'\"\u0001-\u0002\t)\fg/Y\u0005\u00035V\u0013!BQ5h\t\u0016\u001c\u0017.\\1m\u00039!WmY5nC2\u0004\u0016M]:fe\u0002\n!\u0003^5nKN$\u0018-\u001c9G_Jl\u0017\r\u001e;feV\ta\f\u0005\u0002`E6\t\u0001M\u0003\u0002b?\u0005!Q\u000f^5m\u0013\t\u0019\u0007M\u0001\nUS6,7\u000f^1na\u001a{'/\\1ui\u0016\u0014\u0018a\u0005;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;uKJ\u0004\u0013!\u0006;j[\u0016\u001cH/Y7q\u001dRSfi\u001c:nCR$XM]\u0001\u0017i&lWm\u001d;b[BtEK\u0017$pe6\fG\u000f^3sA\u0005a\u0011n\u001d#fM\u0006,H\u000e\u001e(U5V\t\u0011\u000e\u0005\u0002,U&\u00111\u000e\f\u0002\b\u0005>|G.Z1o\u00035I7\u000fR3gCVdGO\u0014+[A\u0005QA.Z4bGflu\u000eZ3\u0002\u00171,w-Y2z\u001b>$W\rI\u0001\u001cQ\u0006tG\r\\3Kg>tWI\u001d:peN\u0014\u0015\u0010U1sg\u0016lu\u000eZ3\u0015\u000bETx0a\u0001\u0011\u0007-\u0012H/\u0003\u0002tY\t1q\n\u001d;j_:\u0004\"!\u001e=\u000e\u0003YT!a^\u0011\u0002\u000bQL\b/Z:\n\u0005e4(AC*ueV\u001cG\u000fV=qK\")10\u0004a\u0001y\u0006I\u0001/\u0019:tK6{G-\u001a\t\u0003?vL!A 1\u0003\u0013A\u000b'o]3N_\u0012,\u0007BBA\u0001\u001b\u0001\u00071*A\rd_2,XN\u001c(b[\u0016|emQ8seV\u0004HOU3d_J$\u0007bBA\u0003\u001b\u0001\u0007\u0011qA\u0001\u0002KB\u0019\u0011'!\u0003\n\u0007\u0005-AHA\u0005UQJ|w/\u00192mK\u0006)\u0011N\u001c4feV!\u0011\u0011CA\u0013)\u0015!\u00181CA\u001c\u0011\u0019qb\u00021\u0001\u0002\u0016A1\u0011qCA\u000f\u0003Ci!!!\u0007\u000b\u0007\u0005m1%A\u0002sI\u0012LA!a\b\u0002\u001a\t\u0019!\u000b\u0012#\u0011\t\u0005\r\u0012Q\u0005\u0007\u0001\t\u001d\t9C\u0004b\u0001\u0003S\u0011\u0011\u0001V\t\u0005\u0003W\t\t\u0004E\u0002,\u0003[I1!a\f-\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aKA\u001a\u0013\r\t)\u0004\f\u0002\u0004\u0003:L\bbBA\u001d\u001d\u0001\u0007\u00111H\u0001\rGJ,\u0017\r^3QCJ\u001cXM\u001d\t\nW\u0005u\u0012\u0011IA\u0011\u00033J1!a\u0010-\u0005%1UO\\2uS>t'\u0007\u0005\u0003\u0002D\u0005USBAA#\u0015\u0011\t9%!\u0013\u0002\t\r|'/\u001a\u0006\u0005\u0003\u0017\ni%A\u0004kC\u000e\\7o\u001c8\u000b\t\u0005=\u0013\u0011K\u0001\nM\u0006\u001cH/\u001a:y[2T!!a\u0015\u0002\u0007\r|W.\u0003\u0003\u0002X\u0005\u0015#a\u0003&t_:4\u0015m\u0019;pef\u0004B!a\u0011\u0002\\%!\u0011QLA#\u0005)Q5o\u001c8QCJ\u001cXM]\u0001\u000bS:4WM\u001d$jK2$G\u0003BA2\u0003S\u00022!^A3\u0013\r\t9G\u001e\u0002\t\t\u0006$\u0018\rV=qK\"9\u00111N\bA\u0002\u0005e\u0013A\u00029beN,'/\u0001\tdC:|g.[2bY&TX\rV=qKR1\u0011\u0011OA:\u0003o\u0002Ba\u000b:\u0002d!9\u0011Q\u000f\tA\u0002\u0005\r\u0014a\u0001;qK\")Q\b\u0005a\u0001}\u0005y!j]8o\u0013:4WM]*dQ\u0016l\u0017\r\u0005\u0002@%M!!CKA@!\u0011\t\t)a\"\u000e\u0005\u0005\r%bAAC/\u0006\u0011\u0011n\\\u0005\u0004w\u0005\rECAA>\u0003U\u0019HO];di\u001aKW\r\u001c3D_6\u0004\u0018M]1u_J,\"!a$\u0013\r\u0005E\u0015qSAR\r\u0019\t\u0019*\u0006\u0001\u0002\u0010\naAH]3gS:,W.\u001a8u}\u000512\u000f\u001e:vGR4\u0015.\u001a7e\u0007>l\u0007/\u0019:bi>\u0014\b\u0005\u0005\u0003\u0002\u001a\u0006}UBAAN\u0015\r\tijV\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\"\u0006m%AB(cU\u0016\u001cG\u000f\u0005\u0004\u0002&\u0006%\u0016QV\u0007\u0003\u0003OS!!Y,\n\t\u0005-\u0016q\u0015\u0002\u000b\u0007>l\u0007/\u0019:bi>\u0014\bcA;\u00020&\u0019\u0011\u0011\u0017<\u0003\u0017M#(/^2u\r&,G\u000eZ\u0001\tSN\u001cvN\u001d;fIR\u0019\u0011.a.\t\u000f\u0005ef\u00031\u0001\u0002<\u0006\u0019\u0011M\u001d:\u0011\u000b-\ni,!,\n\u0007\u0005}FFA\u0003BeJ\f\u00170\u0001\txSRD7i\u001c:skB$h)[3mIRIA/!2\u0002J\u00065\u0017\u0011\u001b\u0005\u0007\u0003\u000f<\u0002\u0019\u0001;\u0002\rM$(/^2u\u0011\u001d\tYm\u0006a\u0001\u0003G\nQa\u001c;iKJDa!a4\u0018\u0001\u0004Y\u0015AG2pYVlgNT1nK>37i\u001c:skB$(+Z2pe\u0012\u001c\b\"B>\u0018\u0001\u0004a\u0018AE2p[B\fG/\u001b2mKJ{w\u000e\u001e+za\u0016$b!a6\u0002Z\u0006m\u0007#C\u0016\u0002>\u0005\r\u00141MA2\u0011\u0019\ty\r\u0007a\u0001\u0017\")1\u0010\u0007a\u0001y\u0006)R-\u001c9usN#(/^2u\r&,G\u000eZ!se\u0006L\u0018AD2p[B\fG/\u001b2mKRK\b/\u001a\u000b\u0007\u0003G\n\u0019/a:\t\u000f\u0005\u0015(\u00041\u0001\u0002d\u0005\u0011A/\r\u0005\b\u0003ST\u0002\u0019AA2\u0003\t!('\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002\u0018\u0002")
public class JsonInferSchema
implements Serializable {
    private final JSONOptions options;
    private final Function1<String, BigDecimal> decimalParser;
    private final TimestampFormatter timestampFormatter;
    private final TimestampFormatter timestampNTZFormatter;
    private final boolean isDefaultNTZ;
    private final boolean legacyMode;

    public static DataType compatibleType(DataType t1, DataType t2) {
        return JsonInferSchema$.MODULE$.compatibleType(t1, t2);
    }

    public static Function2<DataType, DataType, DataType> compatibleRootType(String columnNameOfCorruptRecords, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.compatibleRootType(columnNameOfCorruptRecords, parseMode);
    }

    public static StructType withCorruptField(StructType struct, DataType other, String columnNameOfCorruptRecords, ParseMode parseMode) {
        return JsonInferSchema$.MODULE$.withCorruptField(struct, other, columnNameOfCorruptRecords, parseMode);
    }

    public static boolean isSorted(StructField[] arr) {
        return JsonInferSchema$.MODULE$.isSorted(arr);
    }

    public static Comparator<StructField> structFieldComparator() {
        return JsonInferSchema$.MODULE$.structFieldComparator();
    }

    private Function1<String, BigDecimal> decimalParser() {
        return this.decimalParser;
    }

    private TimestampFormatter timestampFormatter() {
        return this.timestampFormatter;
    }

    private TimestampFormatter timestampNTZFormatter() {
        return this.timestampNTZFormatter;
    }

    private boolean isDefaultNTZ() {
        return this.isDefaultNTZ;
    }

    private boolean legacyMode() {
        return this.legacyMode;
    }

    private Option<StructType> handleJsonErrorsByParseMode(ParseMode parseMode, String columnNameOfCorruptRecord, Throwable e) {
        None$ none$;
        ParseMode parseMode2 = parseMode;
        if (PermissiveMode$.MODULE$.equals(parseMode2)) {
            none$ = new Some((Object)new StructType((StructField[])((Object[])new StructField[]{new StructField(columnNameOfCorruptRecord, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        } else if (DropMalformedMode$.MODULE$.equals(parseMode2)) {
            none$ = None$.MODULE$;
        } else {
            if (FailFastMode$.MODULE$.equals(parseMode2)) {
                throw QueryExecutionErrors$.MODULE$.malformedRecordsDetectedInSchemaInferenceError(e);
            }
            throw new MatchError((Object)parseMode2);
        }
        return none$;
    }

    public <T> StructType infer(RDD<T> json, Function2<JsonFactory, T, JsonParser> createParser) {
        ParseMode parseMode = this.options.parseMode();
        String columnNameOfCorruptRecord = this.options.columnNameOfCorruptRecord();
        Function2<DataType, DataType, DataType> typeMerger = JsonInferSchema$.MODULE$.compatibleRootType(columnNameOfCorruptRecord, parseMode);
        RDD mergedTypesFromPartitions = json.mapPartitions((Function1 & Serializable)iter -> {
            JsonFactory factory = $this.options.buildJsonFactory();
            return iter.flatMap((Function1 & Serializable)row -> {
                Option<StructType> option;
                try {
                    option = (Option<StructType>)Utils$.MODULE$.tryWithResource((Function0 & Serializable)() -> (JsonParser)createParser.apply((Object)factory, row), (Function1 & Serializable)parser -> {
                        parser.nextToken();
                        return new Some((Object)this.inferField((JsonParser)parser));
                    });
                    return option;
                }
                catch (Throwable throwable) {
                    Option<StructType> option2;
                    Throwable throwable2 = throwable;
                    boolean bl = throwable2 instanceof RuntimeException ? true : (throwable2 instanceof JsonProcessingException ? true : throwable2 instanceof MalformedInputException);
                    if (bl) {
                        option2 = this.handleJsonErrorsByParseMode(parseMode, columnNameOfCorruptRecord, throwable2);
                    } else {
                        if (!(throwable2 instanceof CharConversionException)) throw throwable;
                        CharConversionException charConversionException = (CharConversionException)throwable2;
                        if (!$this.options.encoding().isEmpty()) throw throwable;
                        String msg = new StringBuilder(0).append(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("JSON parser cannot handle a character in its input.\n                |Specifying encoding as an input option explicitly might help to resolve the issue.\n                |"))).append(charConversionException.getMessage()).toString();
                        CharConversionException wrappedCharException = new CharConversionException(msg);
                        wrappedCharException.initCause(charConversionException);
                        option2 = this.handleJsonErrorsByParseMode(parseMode, columnNameOfCorruptRecord, wrappedCharException);
                    }
                    option = option2;
                }
                return option;
            }).reduceOption(typeMerger).iterator();
        }, json.mapPartitions$default$2(), ClassTag$.MODULE$.apply(DataType.class));
        SQLConf existingConf = SQLConf$.MODULE$.get();
        ObjectRef rootType = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil()));
        Function1 & Serializable foldPartition = (Function1 & Serializable)iter -> (DataType)iter.fold((Object)StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil()), typeMerger);
        Function2 & Serializable mergeResult = (Function2 & Serializable)(index, taskResult) -> {
            rootType.elem = (DataType)SQLConf$.MODULE$.withExistingConf(existingConf, (Function0 & Serializable)() -> (DataType)typeMerger$1.apply((Object)((DataType)rootType$1.elem), (Object)taskResult));
            return BoxedUnit.UNIT;
        };
        json.sparkContext().runJob(mergedTypesFromPartitions, (Function1)foldPartition, (Function2)mergeResult, ClassTag$.MODULE$.apply(DataType.class));
        return (StructType)Option$.MODULE$.option2Iterable(this.canonicalizeType((DataType)rootType.elem, this.options)).find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JsonInferSchema.$anonfun$infer$8(x$1))).getOrElse((Function0 & Serializable)() -> StructType$.MODULE$.apply((Seq)package$.MODULE$.Nil()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataType inferField(JsonParser parser) {
        boolean bl = false;
        JsonToken jsonToken = null;
        JsonToken jsonToken2 = parser.getCurrentToken();
        boolean bl2 = jsonToken2 == null ? true : JsonToken.VALUE_NULL.equals(jsonToken2);
        if (bl2) {
            return NullType$.MODULE$;
        }
        if (JsonToken.FIELD_NAME.equals(jsonToken2)) {
            parser.nextToken();
            return this.inferField(parser);
        }
        if (JsonToken.VALUE_STRING.equals(jsonToken2)) {
            bl = true;
            jsonToken = jsonToken2;
            if (parser.getTextLength() < 1) {
                return NullType$.MODULE$;
            }
        }
        if (bl) {
            UTF8String utf8Value;
            LazyRef decimalTry$lzy = new LazyRef();
            String field = parser.getText();
            Object object = this.options.prefersDecimal() && this.decimalTry$1(decimalTry$lzy, field).isDefined() ? (DataType)this.decimalTry$1(decimalTry$lzy, field).get() : (this.options.inferTimestamp() ? (this.isDefaultNTZ() && this.timestampNTZFormatter().parseWithoutTimeZoneOptional(field, false).isDefined() ? TimestampNTZType$.MODULE$ : (this.timestampFormatter().parseOptional(field).isDefined() ? TimestampType$.MODULE$ : (this.legacyMode() ? (SparkDateTimeUtils$.MODULE$.stringToTimestampWithoutTimeZone(utf8Value = UTF8String.fromString((String)field), false).isDefined() ? TimestampType$.MODULE$ : StringType$.MODULE$) : StringType$.MODULE$))) : StringType$.MODULE$);
            return object;
        }
        if (JsonToken.START_OBJECT.equals(jsonToken2)) {
            ArrayBuilder builder = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(StructField.class));
            while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_OBJECT)) {
                builder.$plus$eq((Object)new StructField(parser.getCurrentName(), this.inferField(parser), true, StructField$.MODULE$.apply$default$4()));
            }
            StructField[] fields = (StructField[])builder.result();
            Arrays.sort((Object[])fields, JsonInferSchema$.MODULE$.structFieldComparator());
            return new StructType(fields);
        }
        if (JsonToken.START_ARRAY.equals(jsonToken2)) {
            NullType$ elementType = NullType$.MODULE$;
            while (JacksonUtils$.MODULE$.nextUntil(parser, JsonToken.END_ARRAY)) {
                elementType = JsonInferSchema$.MODULE$.compatibleType((DataType)elementType, this.inferField(parser));
            }
            return ArrayType$.MODULE$.apply((DataType)elementType);
        }
        boolean bl3 = JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2);
        if (bl3 && this.options.primitivesAsString()) {
            return StringType$.MODULE$;
        }
        boolean bl4 = JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2);
        if (bl4 && this.options.primitivesAsString()) {
            return StringType$.MODULE$;
        }
        boolean bl5 = JsonToken.VALUE_NUMBER_INT.equals(jsonToken2) ? true : JsonToken.VALUE_NUMBER_FLOAT.equals(jsonToken2);
        if (bl5) {
            LongType$ longType$;
            JsonParser.NumberType numberType = parser.getNumberType();
            boolean bl6 = JsonParser.NumberType.INT.equals(numberType) ? true : JsonParser.NumberType.LONG.equals(numberType);
            if (bl6) {
                longType$ = LongType$.MODULE$;
                return longType$;
            } else {
                boolean bl7 = JsonParser.NumberType.BIG_INTEGER.equals(numberType) ? true : JsonParser.NumberType.BIG_DECIMAL.equals(numberType);
                if (bl7) {
                    BigDecimal v = parser.getDecimalValue();
                    longType$ = Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION() ? new DecimalType(Math.max(v.precision(), v.scale()), v.scale()) : DoubleType$.MODULE$;
                    return longType$;
                } else {
                    boolean bl8 = JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType);
                    if (bl8 && this.options.prefersDecimal()) {
                        BigDecimal v = parser.getDecimalValue();
                        longType$ = Math.max(v.precision(), v.scale()) <= DecimalType$.MODULE$.MAX_PRECISION() ? new DecimalType(Math.max(v.precision(), v.scale()), v.scale()) : DoubleType$.MODULE$;
                        return longType$;
                    } else {
                        boolean bl9 = JsonParser.NumberType.FLOAT.equals(numberType) ? true : JsonParser.NumberType.DOUBLE.equals(numberType);
                        if (!bl9) throw new MatchError((Object)numberType);
                        longType$ = DoubleType$.MODULE$;
                    }
                }
            }
            return longType$;
        }
        boolean bl10 = JsonToken.VALUE_TRUE.equals(jsonToken2) ? true : JsonToken.VALUE_FALSE.equals(jsonToken2);
        if (!bl10) throw QueryExecutionErrors$.MODULE$.malformedJSONError();
        return BooleanType$.MODULE$;
    }

    public Option<DataType> canonicalizeType(DataType tpe, JSONOptions options) {
        Object object;
        DataType dataType = tpe;
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            object = this.canonicalizeType(arrayType.elementType(), options).map((Function1 & Serializable)t -> arrayType.copy(t, arrayType.copy$default$2()));
        } else {
            StructType structType;
            StructField[] fields;
            StructField[] canonicalFields;
            object = dataType instanceof StructType ? (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])(canonicalFields = (StructField[])ArrayOps$.MODULE$.flatMap$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])(fields = (structType = (StructType)dataType).fields())), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2.name()))))), (Function1 & Serializable)f -> this.canonicalizeType(f.dataType(), options).map((Function1 & Serializable)t -> {
                DataType x$1 = t;
                String x$2 = f.copy$default$1();
                boolean x$3 = f.copy$default$3();
                Metadata x$4 = f.copy$default$4();
                return f.copy(x$2, x$1, x$3, x$4);
            }), ClassTag$.MODULE$.apply(StructField.class))))) ? None$.MODULE$ : new Some((Object)new StructType(canonicalFields))) : (NullType$.MODULE$.equals(dataType) ? (options.dropFieldIfAllNull() ? None$.MODULE$ : new Some((Object)StringType$.MODULE$)) : new Some((Object)dataType));
        }
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$infer$8(DataType x$1) {
        return x$1 instanceof StructType;
    }

    private final /* synthetic */ Option decimalTry$lzycompute$1(LazyRef decimalTry$lzy$1, String field$1) {
        Option option;
        LazyRef lazyRef = decimalTry$lzy$1;
        synchronized (lazyRef) {
            option = decimalTry$lzy$1.initialized() ? (Option)decimalTry$lzy$1.value() : (Option)decimalTry$lzy$1.initialize((Object)Exception$.MODULE$.allCatch().opt((Function0 & Serializable)() -> {
                BigDecimal bigDecimal = (BigDecimal)this.decimalParser().apply((Object)field$1);
                return new DecimalType(bigDecimal.precision(), bigDecimal.scale());
            }));
        }
        return option;
    }

    private final Option decimalTry$1(LazyRef decimalTry$lzy$1, String field$1) {
        return decimalTry$lzy$1.initialized() ? (Option)decimalTry$lzy$1.value() : this.decimalTry$lzycompute$1(decimalTry$lzy$1, field$1);
    }

    public JsonInferSchema(JSONOptions options) {
        this.options = options;
        this.decimalParser = ExprUtils$.MODULE$.getDecimalParser(options.locale());
        this.timestampFormatter = TimestampFormatter$.MODULE$.apply(options.timestampFormatInRead(), options.zoneId(), options.locale(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true);
        this.timestampNTZFormatter = TimestampFormatter$.MODULE$.apply(options.timestampNTZFormatInRead(), options.zoneId(), LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT(), true, true);
        AtomicType atomicType = SQLConf$.MODULE$.get().timestampType();
        TimestampNTZType$ timestampNTZType$ = TimestampNTZType$.MODULE$;
        this.isDefaultNTZ = !(atomicType != null ? !atomicType.equals(timestampNTZType$) : timestampNTZType$ != null);
        Enumeration.Value value = SQLConf$.MODULE$.get().legacyTimeParserPolicy();
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        this.legacyMode = !(value != null ? !value.equals(value2) : value2 != null);
    }
}

