/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.gridded;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.measure.Quantity;
import org.apache.sis.pending.jdk.JDK19;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.internal.shared.AffineTransform2D;
import org.apache.sis.referencing.internal.shared.IntervalRectangle;
import org.apache.sis.referencing.operation.gridded.GridFile;
import org.apache.sis.referencing.operation.gridded.LoadedGrid;
import org.apache.sis.referencing.operation.gridded.Tile;
import org.apache.sis.referencing.operation.gridded.TileOrganizer;
import org.apache.sis.util.collection.Containers;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

public final class GridGroup<C extends Quantity<C>, T extends Quantity<T>>
extends LoadedGrid<C, T> {
    private static final long serialVersionUID = -1602724619897451422L;
    private final Region[] regions;

    private GridGroup(Tile[] tiles, Map<Tile, LoadedGrid<C, T>> grids, AffineTransform2D gridToCRS, Dimension gridSize) throws IOException, NoninvertibleTransformException {
        super(grids.get(tiles[0]), gridToCRS, gridSize.width, gridSize.height);
        int n = grids.size();
        this.regions = new Region[n];
        this.subgrids = new LoadedGrid[n];
        for (int i = 0; i < n; ++i) {
            Tile tile = tiles[i];
            LoadedGrid<C, T> grid = grids.get(tile);
            this.regions[i] = new Region(tile);
            this.subgrids[i] = grid;
            if (!(grid.accuracy > this.accuracy)) continue;
            this.accuracy = grid.accuracy;
        }
    }

    public static <C extends Quantity<C>, T extends Quantity<T>> GridGroup<C, T> create(GridFile file, List<LoadedGrid<C, T>> subgrids) throws IOException, FactoryException, NoninvertibleTransformException {
        TileOrganizer mosaic = new TileOrganizer(null);
        LinkedHashMap grids = JDK19.newLinkedHashMap((int)subgrids.size());
        for (LoadedGrid<C, T> grid : subgrids) {
            int[] size = grid.getGridSize();
            Tile tile = new Tile(new Rectangle(size[0], size[1]), (AffineTransform)((Object)grid.getCoordinateToGrid().inverse()));
            if (!mosaic.add(tile) || grids.put(tile, grid) != null) {
                throw new AssertionError(tile);
            }
        }
        Map.Entry result = (Map.Entry)Containers.peekIfSingleton(mosaic.tiles().entrySet());
        if (result == null) {
            throw new FactoryException(Resources.format((short)94, file.parameter));
        }
        Tile global = (Tile)result.getKey();
        return new GridGroup<C, T>((Tile[])result.getValue(), grids, global.getGridToCRS(), global.getSize());
    }

    private GridGroup(GridGroup<C, T> other, LoadedGrid<C, T>[] data) {
        super(other);
        this.subgrids = data;
        this.regions = other.regions;
    }

    @Override
    protected final LoadedGrid<C, T> setData(Object[] other) {
        return new GridGroup<C, T>(this, (LoadedGrid[])other);
    }

    @Override
    protected Object[] getData() {
        return this.subgrids;
    }

    @Override
    public int getTranslationDimensions() {
        return this.subgrids[0].getTranslationDimensions();
    }

    @Override
    public double getCellValue(int dim, int gridX, int gridY) {
        for (int i = 0; i < this.regions.length; ++i) {
            Region r = this.regions[i];
            if (!r.containsInclusive(gridX, gridY)) continue;
            double shift = this.subgrids[i].getCellValue(dim, Math.toIntExact(Math.round(r.x(gridX))), Math.toIntExact(Math.round(r.y(gridY))));
            if (this.isCellValueRatio()) {
                shift *= r.relativeCellSize(dim);
            }
            return shift;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void interpolateInCell(double gridX, double gridY, double[] vector) {
        int ni = 0;
        Region nearest = this.regions[ni];
        double dmin = nearest.distanceSquared(gridX, gridY);
        for (int i = 1; i < this.regions.length; ++i) {
            Region r = this.regions[i];
            double d = r.distanceSquared(gridX, gridY);
            if (!(d < dmin)) continue;
            dmin = d;
            nearest = r;
            ni = i;
            if (d == 0.0) break;
        }
        this.subgrids[ni].interpolateInCell(nearest.x(gridX), nearest.y(gridY), vector);
        if (this.isCellValueRatio()) {
            for (int dim = 0; dim < 2; ++dim) {
                int n = dim;
                vector[n] = vector[n] * nearest.relativeCellSize(dim);
            }
        }
    }

    private static final class Region
    extends IntervalRectangle {
        private static final long serialVersionUID = -2925837396412170681L;
        private final double sx;
        private final double sy;

        Region(Tile tile) throws IOException {
            Rectangle r = tile.getRegionOnFinestLevel();
            Dimension s = tile.getSubsampling();
            this.xmin = r.getMinX();
            this.xmax = r.getMaxX();
            this.ymin = r.getMinY();
            this.ymax = r.getMaxY();
            this.sx = s.width;
            this.sy = s.height;
        }

        final double x(double p) {
            return (p - this.xmin) / this.sx;
        }

        final double y(double p) {
            return (p - this.ymin) / this.sy;
        }

        final double relativeCellSize(int dim) {
            switch (dim) {
                case 0: {
                    return this.sx;
                }
                case 1: {
                    return this.sy;
                }
            }
            throw new IndexOutOfBoundsException();
        }
    }
}

