/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.internal.shared;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;

public final class FilteredIterator<S, T>
implements Iterator<T> {
    private final Iterator<S> source;
    private final Function<S, T> mapper;
    private T next;

    public FilteredIterator(Iterator<S> source, Function<S, T> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public boolean hasNext() {
        while (this.next == null) {
            if (this.source.hasNext()) {
                this.next = this.mapper.apply(this.source.next());
                continue;
            }
            return false;
        }
        return true;
    }

    @Override
    public T next() {
        T element = this.next;
        this.next = null;
        while (element == null) {
            element = this.mapper.apply(this.source.next());
        }
        return element;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        T element = this.next;
        if (element != null) {
            this.next = null;
            action.accept(element);
        }
        while (this.source.hasNext()) {
            element = this.mapper.apply(this.source.next());
            if (element == null) continue;
            action.accept(element);
        }
    }
}

