/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PnDcp_Pdu_RealTimeCyclic extends PnDcp_Pdu implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final PnIo_CyclicServiceDataUnit dataUnit;
  protected final int cycleCounter;
  protected final boolean ignore;
  protected final boolean stationProblemIndicatorOk;
  protected final boolean providerStateRun;
  protected final boolean dataValid;
  protected final boolean redundancy;
  protected final boolean statePrimary;

  // Reserved Fields
  private Boolean reservedField0;
  private Boolean reservedField1;
  private Short reservedField2;

  public PnDcp_Pdu_RealTimeCyclic(
      int frameIdValue,
      PnIo_CyclicServiceDataUnit dataUnit,
      int cycleCounter,
      boolean ignore,
      boolean stationProblemIndicatorOk,
      boolean providerStateRun,
      boolean dataValid,
      boolean redundancy,
      boolean statePrimary) {
    super(frameIdValue);
    this.dataUnit = dataUnit;
    this.cycleCounter = cycleCounter;
    this.ignore = ignore;
    this.stationProblemIndicatorOk = stationProblemIndicatorOk;
    this.providerStateRun = providerStateRun;
    this.dataValid = dataValid;
    this.redundancy = redundancy;
    this.statePrimary = statePrimary;
  }

  public PnIo_CyclicServiceDataUnit getDataUnit() {
    return dataUnit;
  }

  public int getCycleCounter() {
    return cycleCounter;
  }

  public boolean getIgnore() {
    return ignore;
  }

  public boolean getStationProblemIndicatorOk() {
    return stationProblemIndicatorOk;
  }

  public boolean getProviderStateRun() {
    return providerStateRun;
  }

  public boolean getDataValid() {
    return dataValid;
  }

  public boolean getRedundancy() {
    return redundancy;
  }

  public boolean getStatePrimary() {
    return statePrimary;
  }

  @Override
  protected void serializePnDcp_PduChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PnDcp_Pdu_RealTimeCyclic");

    // Manual Field (dataUnit)
    writeManualField(
        "dataUnit",
        () ->
            org.apache.plc4x.java.profinet.readwrite.utils.StaticHelper.writeDataUnit(
                writeBuffer, dataUnit),
        writeBuffer,
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (cycleCounter)
    writeSimpleField(
        "cycleCounter",
        cycleCounter,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (ignore)
    writeSimpleField(
        "ignore",
        ignore,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (boolean) false,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (stationProblemIndicatorOk)
    writeSimpleField(
        "stationProblemIndicatorOk",
        stationProblemIndicatorOk,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (providerStateRun)
    writeSimpleField(
        "providerStateRun",
        providerStateRun,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField1 != null ? reservedField1 : (boolean) false,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (dataValid)
    writeSimpleField(
        "dataValid",
        dataValid,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (redundancy)
    writeSimpleField(
        "redundancy",
        redundancy,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (statePrimary)
    writeSimpleField(
        "statePrimary",
        statePrimary,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField2 != null ? reservedField2 : (short) 0x00,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("PnDcp_Pdu_RealTimeCyclic");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    PnDcp_Pdu_RealTimeCyclic _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Manual Field (dataUnit)
    lengthInBits += ((dataUnit.getLengthInBytes())) * (8);

    // Simple field (cycleCounter)
    lengthInBits += 16;

    // Simple field (ignore)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Simple field (stationProblemIndicatorOk)
    lengthInBits += 1;

    // Simple field (providerStateRun)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Simple field (dataValid)
    lengthInBits += 1;

    // Simple field (redundancy)
    lengthInBits += 1;

    // Simple field (statePrimary)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static PnDcp_PduBuilder staticParsePnDcp_PduBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("PnDcp_Pdu_RealTimeCyclic");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PnIo_CyclicServiceDataUnit dataUnit =
        readManualField(
            "dataUnit",
            readBuffer,
            () ->
                (PnIo_CyclicServiceDataUnit)
                    (org.apache.plc4x.java.profinet.readwrite.utils.StaticHelper.readDataUnit(
                        readBuffer)),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    int cycleCounter =
        readSimpleField(
            "cycleCounter",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean ignore =
        readSimpleField(
            "ignore", readBoolean(readBuffer), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    Boolean reservedField0 =
        readReservedField(
            "reserved",
            readBoolean(readBuffer),
            (boolean) false,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean stationProblemIndicatorOk =
        readSimpleField(
            "stationProblemIndicatorOk",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean providerStateRun =
        readSimpleField(
            "providerStateRun",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    Boolean reservedField1 =
        readReservedField(
            "reserved",
            readBoolean(readBuffer),
            (boolean) false,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean dataValid =
        readSimpleField(
            "dataValid", readBoolean(readBuffer), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean redundancy =
        readSimpleField(
            "redundancy", readBoolean(readBuffer), WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean statePrimary =
        readSimpleField(
            "statePrimary",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    Short reservedField2 =
        readReservedField(
            "reserved",
            readUnsignedShort(readBuffer, 8),
            (short) 0x00,
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("PnDcp_Pdu_RealTimeCyclic");
    // Create the instance
    return new PnDcp_Pdu_RealTimeCyclicBuilderImpl(
        dataUnit,
        cycleCounter,
        ignore,
        stationProblemIndicatorOk,
        providerStateRun,
        dataValid,
        redundancy,
        statePrimary,
        reservedField0,
        reservedField1,
        reservedField2);
  }

  public static class PnDcp_Pdu_RealTimeCyclicBuilderImpl implements PnDcp_Pdu.PnDcp_PduBuilder {
    private final PnIo_CyclicServiceDataUnit dataUnit;
    private final int cycleCounter;
    private final boolean ignore;
    private final boolean stationProblemIndicatorOk;
    private final boolean providerStateRun;
    private final boolean dataValid;
    private final boolean redundancy;
    private final boolean statePrimary;
    private final Boolean reservedField0;
    private final Boolean reservedField1;
    private final Short reservedField2;

    public PnDcp_Pdu_RealTimeCyclicBuilderImpl(
        PnIo_CyclicServiceDataUnit dataUnit,
        int cycleCounter,
        boolean ignore,
        boolean stationProblemIndicatorOk,
        boolean providerStateRun,
        boolean dataValid,
        boolean redundancy,
        boolean statePrimary,
        Boolean reservedField0,
        Boolean reservedField1,
        Short reservedField2) {
      this.dataUnit = dataUnit;
      this.cycleCounter = cycleCounter;
      this.ignore = ignore;
      this.stationProblemIndicatorOk = stationProblemIndicatorOk;
      this.providerStateRun = providerStateRun;
      this.dataValid = dataValid;
      this.redundancy = redundancy;
      this.statePrimary = statePrimary;
      this.reservedField0 = reservedField0;
      this.reservedField1 = reservedField1;
      this.reservedField2 = reservedField2;
    }

    public PnDcp_Pdu_RealTimeCyclic build(int frameIdValue) {
      PnDcp_Pdu_RealTimeCyclic pnDcp_Pdu_RealTimeCyclic =
          new PnDcp_Pdu_RealTimeCyclic(
              frameIdValue,
              dataUnit,
              cycleCounter,
              ignore,
              stationProblemIndicatorOk,
              providerStateRun,
              dataValid,
              redundancy,
              statePrimary);
      pnDcp_Pdu_RealTimeCyclic.reservedField0 = reservedField0;
      pnDcp_Pdu_RealTimeCyclic.reservedField1 = reservedField1;
      pnDcp_Pdu_RealTimeCyclic.reservedField2 = reservedField2;
      return pnDcp_Pdu_RealTimeCyclic;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PnDcp_Pdu_RealTimeCyclic)) {
      return false;
    }
    PnDcp_Pdu_RealTimeCyclic that = (PnDcp_Pdu_RealTimeCyclic) o;
    return (getDataUnit() == that.getDataUnit())
        && (getCycleCounter() == that.getCycleCounter())
        && (getIgnore() == that.getIgnore())
        && (getStationProblemIndicatorOk() == that.getStationProblemIndicatorOk())
        && (getProviderStateRun() == that.getProviderStateRun())
        && (getDataValid() == that.getDataValid())
        && (getRedundancy() == that.getRedundancy())
        && (getStatePrimary() == that.getStatePrimary())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getDataUnit(),
        getCycleCounter(),
        getIgnore(),
        getStationProblemIndicatorOk(),
        getProviderStateRun(),
        getDataValid(),
        getRedundancy(),
        getStatePrimary());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
