/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SearchRequest extends KnxNetIpMessage implements Message {

  // Accessors for discriminator values.
  public Integer getMsgType() {
    return (int) 0x0201;
  }

  // Properties.
  protected final HPAIDiscoveryEndpoint hpaiIDiscoveryEndpoint;

  public SearchRequest(HPAIDiscoveryEndpoint hpaiIDiscoveryEndpoint) {
    super();
    this.hpaiIDiscoveryEndpoint = hpaiIDiscoveryEndpoint;
  }

  public HPAIDiscoveryEndpoint getHpaiIDiscoveryEndpoint() {
    return hpaiIDiscoveryEndpoint;
  }

  @Override
  protected void serializeKnxNetIpMessageChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SearchRequest");

    // Simple Field (hpaiIDiscoveryEndpoint)
    writeSimpleField(
        "hpaiIDiscoveryEndpoint",
        hpaiIDiscoveryEndpoint,
        writeComplex(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("SearchRequest");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SearchRequest _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (hpaiIDiscoveryEndpoint)
    lengthInBits += hpaiIDiscoveryEndpoint.getLengthInBits();

    return lengthInBits;
  }

  public static KnxNetIpMessageBuilder staticParseKnxNetIpMessageBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("SearchRequest");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    HPAIDiscoveryEndpoint hpaiIDiscoveryEndpoint =
        readSimpleField(
            "hpaiIDiscoveryEndpoint",
            readComplex(() -> HPAIDiscoveryEndpoint.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("SearchRequest");
    // Create the instance
    return new SearchRequestBuilderImpl(hpaiIDiscoveryEndpoint);
  }

  public static class SearchRequestBuilderImpl implements KnxNetIpMessage.KnxNetIpMessageBuilder {
    private final HPAIDiscoveryEndpoint hpaiIDiscoveryEndpoint;

    public SearchRequestBuilderImpl(HPAIDiscoveryEndpoint hpaiIDiscoveryEndpoint) {
      this.hpaiIDiscoveryEndpoint = hpaiIDiscoveryEndpoint;
    }

    public SearchRequest build() {
      SearchRequest searchRequest = new SearchRequest(hpaiIDiscoveryEndpoint);
      return searchRequest;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SearchRequest)) {
      return false;
    }
    SearchRequest that = (SearchRequest) o;
    return (getHpaiIDiscoveryEndpoint() == that.getHpaiIDiscoveryEndpoint())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getHpaiIDiscoveryEndpoint());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
