/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum AccessLevel {
  Level0((byte) 0x0, (String) "system manufacturer", (boolean) true),
  Level1((byte) 0x1, (String) "product manufacturer", (boolean) true),
  Level2((byte) 0x2, (String) "configuration", (boolean) true),
  Level3((byte) 0x3, (String) "end-user", (boolean) false),
  Level15((byte) 0xF, (String) "read access", (boolean) false);
  private static final Map<Byte, AccessLevel> map;

  static {
    map = new HashMap<>();
    for (AccessLevel value : AccessLevel.values()) {
      map.put((byte) value.getValue(), value);
    }
  }

  private final byte value;
  private final String purpose;
  private final boolean needsAuthentication;

  AccessLevel(byte value, String purpose, boolean needsAuthentication) {
    this.value = value;
    this.purpose = purpose;
    this.needsAuthentication = needsAuthentication;
  }

  public byte getValue() {
    return value;
  }

  public String getPurpose() {
    return purpose;
  }

  public static AccessLevel firstEnumForFieldPurpose(String fieldValue) {
    for (AccessLevel _val : AccessLevel.values()) {
      if (_val.getPurpose().equals(fieldValue)) {
        return _val;
      }
    }
    return null;
  }

  public static List<AccessLevel> enumsForFieldPurpose(String fieldValue) {
    List<AccessLevel> _values = new ArrayList<>();
    for (AccessLevel _val : AccessLevel.values()) {
      if (_val.getPurpose().equals(fieldValue)) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public boolean getNeedsAuthentication() {
    return needsAuthentication;
  }

  public static AccessLevel firstEnumForFieldNeedsAuthentication(boolean fieldValue) {
    for (AccessLevel _val : AccessLevel.values()) {
      if (_val.getNeedsAuthentication() == fieldValue) {
        return _val;
      }
    }
    return null;
  }

  public static List<AccessLevel> enumsForFieldNeedsAuthentication(boolean fieldValue) {
    List<AccessLevel> _values = new ArrayList<>();
    for (AccessLevel _val : AccessLevel.values()) {
      if (_val.getNeedsAuthentication() == fieldValue) {
        _values.add(_val);
      }
    }
    return _values;
  }

  public static AccessLevel enumForValue(byte value) {
    return map.get(value);
  }

  public static Boolean isDefined(byte value) {
    return map.containsKey(value);
  }
}
